/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.player;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.network.PacketHandler;
import pcl.OpenFM.network.message.MessageRadioPlaying;

public class OGGPlayer {
    private IntBuffer buffer;
    private IntBuffer source;
    private float volume = 0.0f;
    private int posX;
    private int posY;
    private int posZ;
    private World world;
    private String streamURL;
    private boolean playing = false;

    private boolean alError() {
        if (AL10.alGetError() != 0) {
            OpenFM.logger.error(String.format("AL10 Error: %d: %s", AL10.alGetError(), AL10.alGetString((int)AL10.alGetError())));
            return true;
        }
        return false;
    }

    public void play(String streamURL) throws IOException {
        this.streamURL = streamURL;
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(streamURL).build();
        Response response = client.newCall(request).execute();
        BufferedInputStream bis = new BufferedInputStream(response.body().byteStream());
        try (AudioInputStream in = AudioSystem.getAudioInputStream(bis);){
            AudioFormat outFormat = this.getOutFormat(in.getFormat());
            this.source = BufferUtils.createIntBuffer((int)1);
            AL10.alGenSources((IntBuffer)this.source);
            if (this.alError()) {
                this.close();
                return;
            }
            AL10.alSourcei((int)this.source.get(0), (int)4103, (int)0);
            AL10.alSourcef((int)this.source.get(0), (int)4099, (float)1.0f);
            AL10.alSourcef((int)this.source.get(0), (int)4106, (float)(this.volume * Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.RECORDS)));
            if (this.alError()) {
                this.close();
                return;
            }
            this.playing = true;
            this.stream(AudioSystem.getAudioInputStream(outFormat, in));
            if (this.playing) {
                while (AL10.alGetSourcei((int)this.source.get(0), (int)4112) == 4114) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.close();
        }
        catch (IOException | UnsupportedAudioFileException e) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageRadioPlaying(this.posX, this.posY, this.posZ, false).wrap());
            FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"msg.OpenFM.invalid_link")));
            OpenFM.logger.error((Object)e);
            throw new IllegalStateException(e);
        }
    }

    private AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
    }

    private void stream(AudioInputStream in) throws IOException {
        AudioFormat format = in.getFormat();
        byte[] databuffer = new byte[65536];
        int n = 0;
        while (this.playing && n != -1) {
            if (n > 0) {
                if (this.buffer == null) {
                    this.buffer = BufferUtils.createIntBuffer((int)1);
                } else {
                    int processed = AL10.alGetSourcei((int)this.source.get(0), (int)4118);
                    if (processed > 0) {
                        AL10.alSourceUnqueueBuffers((int)this.source.get(0), (IntBuffer)this.buffer);
                        this.alError();
                    }
                }
                AL10.alGenBuffers((IntBuffer)this.buffer);
                ByteBuffer data = (ByteBuffer)BufferUtils.createByteBuffer((int)n).order(ByteOrder.LITTLE_ENDIAN).put(databuffer, 0, n).flip();
                AL10.alBufferData((int)this.buffer.get(0), (int)(format.getChannels() > 1 ? 4355 : 4353), (ByteBuffer)data, (int)((int)format.getSampleRate()));
                AL10.alSourceQueueBuffers((int)this.source.get(0), (IntBuffer)this.buffer);
                int state = AL10.alGetSourcei((int)this.source.get(0), (int)4112);
                if (this.playing && state != 4114) {
                    AL10.alSourcePlay((int)this.source.get(0));
                }
            }
            n = in.read(databuffer, 0, databuffer.length);
        }
    }

    private void close() {
        this.playing = false;
        if (this.source != null) {
            AL10.alSourceStop((IntBuffer)this.source);
            AL10.alDeleteSources((IntBuffer)this.source);
            this.source = null;
        }
        if (this.buffer != null) {
            AL10.alDeleteBuffers((IntBuffer)this.buffer);
            this.buffer = null;
        }
    }

    public void stop() {
        this.playing = false;
        if (this.source != null) {
            AL10.alSourcef((int)this.source.get(0), (int)4106, (float)0.0f);
            AL10.alSourceStop((IntBuffer)this.source);
        }
    }

    public void setVolume(float f) {
        this.volume = f;
        if (this.playing && this.source != null) {
            AL10.alSourcef((int)this.source.get(0), (int)4106, (float)(f * Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.RECORDS)));
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public void setID(World world, int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = world;
    }

    public boolean isPlaying() {
        return this.playing;
    }
}

