/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.utils;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stevekung.mods.stevekunglib.utils.enums.EnumEntityTrackerType;

public class CommonRegistryUtils {
    private static int ID;
    private final String resourcePath;

    public CommonRegistryUtils(@Nonnull String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void registerBlock(Block block) {
        this.registerBlock(block, ItemBlock::new);
    }

    public void registerBlock(Block block, @Nullable Function<Block, ItemBlock> itemBlock) {
        String name = block.func_149739_a().substring(5);
        ForgeRegistries.BLOCKS.register(block.setRegistryName(name));
        if (itemBlock != null) {
            ForgeRegistries.ITEMS.register(itemBlock.apply(block).setRegistryName(block.getRegistryName()));
        }
    }

    public void registerItem(Item item) {
        String name = item.func_77658_a().substring(5);
        ForgeRegistries.ITEMS.register(item.setRegistryName(name));
    }

    public void registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
    }

    public void registerForgeBucket(Fluid fluid) {
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public void registerTileEntity(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (ResourceLocation)new ResourceLocation(this.resourcePath + ":" + name));
    }

    public void registerPotion(Potion potion, String name) {
        ForgeRegistries.POTIONS.register(potion.setRegistryName(this.resourcePath + ":" + name));
    }

    public void registerBiome(Biome biome, String name) {
        ForgeRegistries.BIOMES.register(biome.setRegistryName(this.resourcePath + ":" + name));
    }

    public void registerBiomeType(Biome biome, BiomeDictionary.Type ... biomeType) {
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])biomeType);
        if (biome.func_185363_b()) {
            Biome.field_185373_j.func_148746_a((Object)biome, Biome.func_185362_a((Biome)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(this.resourcePath + ":" + biome.field_185364_H)))));
        }
    }

    public void registerEntity(Class<? extends Entity> entity, String name, int backgroundColor, int foregroundColor) {
        this.registerEntity(entity, name, backgroundColor, foregroundColor, EnumEntityTrackerType.NORMAL);
    }

    public void registerEntity(Class<? extends Entity> entity, String name, int backgroundColor, int foregroundColor, EnumEntityTrackerType type) {
        this.registerEntity(entity, name, backgroundColor, foregroundColor, type.getTrackingRange(), type.getUpdateFrequency());
    }

    public void registerEntity(Class<? extends Entity> entity, String name, int backgroundColor, int foregroundColor, int trackingRange, int updateFrequency) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(this.resourcePath + ":" + name), entity, (String)(this.resourcePath + "." + name), (int)ID++, (Object)this.resourcePath, (int)trackingRange, (int)updateFrequency, (boolean)true, (int)backgroundColor, (int)foregroundColor);
    }

    public void registerNonMobEntity(Class<? extends Entity> entity, String name) {
        this.registerNonMobEntity(entity, name, EnumEntityTrackerType.NORMAL);
    }

    public void registerNonMobEntity(Class<? extends Entity> entity, String name, EnumEntityTrackerType type) {
        this.registerNonMobEntity(entity, name, type.getTrackingRange(), type.getUpdateFrequency(), type.sendsVelocityUpdates());
    }

    public void registerNonMobEntity(Class<? extends Entity> entity, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(this.resourcePath + ":" + name), entity, (String)(this.resourcePath + "." + name), (int)ID++, (Object)this.resourcePath, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public void registerEntityPlacement(Class<? extends Entity> entity, EntityLiving.SpawnPlacementType type) {
        EntitySpawnPlacementRegistry.setPlacementType(entity, (EntityLiving.SpawnPlacementType)type);
    }

    public void registerCarriable(Block block) {
        EntityEnderman.setCarriable((Block)block, (boolean)true);
    }

    public void registerProjectileDispense(Item item, IBehaviorDispenseItem projectile) {
        BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)projectile);
    }

    public SoundEvent registerSound(String name) {
        ResourceLocation resource = new ResourceLocation(this.resourcePath + ":" + name);
        SoundEvent event = (SoundEvent)new SoundEvent(resource).setRegistryName(resource);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        return event;
    }

    public SoundEvent registerRecord(String name) {
        return this.registerSound("record." + name);
    }

    public ResourceLocation registerEntityLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(this.resourcePath + ":entities/" + name));
    }

    public ResourceLocation registerEntitySubLoot(String folder, String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(this.resourcePath + ":entities/" + folder + "/" + name));
    }

    public ResourceLocation registerChestLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(this.resourcePath + ":chests/" + name));
    }

    public ResourceLocation registerGameplayLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(this.resourcePath + ":gameplay/" + name));
    }

    public ResourceLocation registerFishingLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(this.resourcePath + ":gameplay/fishing/" + name));
    }
}

