/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.world.gen;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class MapGenRavineBase
extends MapGenBase {
    protected static final IBlockState FLOWING_LAVA = Blocks.field_150356_k.func_176223_P();
    private IBlockState top = Blocks.field_150349_c.func_176223_P();
    private final IBlockState lava;
    private Set<Block> topBlock = new HashSet<Block>();
    private final Set<Block> digBlock;
    private final Set<Block> fluidBlock;
    private final float[] rs = new float[1024];

    public MapGenRavineBase(Set<Block> topBlock, IBlockState lava, Set<Block> digBlock, Set<Block> fluidBlock) {
        this.topBlock = topBlock;
        this.lava = lava;
        this.digBlock = digBlock;
        this.fluidBlock = fluidBlock;
    }

    public MapGenRavineBase(IBlockState top, IBlockState lava, Set<Block> digBlock) {
        this(top, lava, digBlock, new HashSet<Block>());
    }

    public MapGenRavineBase(IBlockState top, IBlockState lava, Set<Block> digBlock, Set<Block> fluidBlock) {
        this.top = top;
        this.lava = lava;
        this.digBlock = digBlock;
        this.fluidBlock = fluidBlock;
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer primer) {
        if (this.field_75038_b.nextInt(50) == 0) {
            double d0 = chunkX * 16 + this.field_75038_b.nextInt(16);
            double d1 = this.field_75038_b.nextInt(this.field_75038_b.nextInt(40) + 8) + 20;
            double d2 = chunkZ * 16 + this.field_75038_b.nextInt(16);
            for (int j = 0; j < 1; ++j) {
                float f = this.field_75038_b.nextFloat() * ((float)Math.PI * 2);
                float f1 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = (this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat()) * 2.0f;
                this.addTunnel(this.field_75038_b.nextLong(), originalX, originalZ, primer, d0, d1, d2, f2, f, f1, 0, 0, 3.0);
            }
        }
    }

    protected void addTunnel(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double p_180707_6_, double p_180707_8_, double p_180707_10_, float p_180707_12_, float p_180707_13_, float p_180707_14_, int p_180707_15_, int p_180707_16_, double p_180707_17_) {
        Random random = new Random(seed);
        double d0 = chunkX * 16 + 8;
        double d1 = chunkZ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        if (p_180707_16_ <= 0) {
            int i = this.field_75040_a * 16 - 16;
            p_180707_16_ = i - random.nextInt(i / 4);
        }
        boolean flag1 = false;
        if (p_180707_15_ == -1) {
            p_180707_15_ = p_180707_16_ / 2;
            flag1 = true;
        }
        float f2 = 1.0f;
        for (int j = 0; j < 256; ++j) {
            if (j == 0 || random.nextInt(3) == 0) {
                f2 = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.rs[j] = f2 * f2;
        }
        while (p_180707_15_ < p_180707_16_) {
            double d9 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)p_180707_15_ * (float)Math.PI / (float)p_180707_16_)) * p_180707_12_);
            double d2 = d9 * p_180707_17_;
            d9 *= (double)random.nextFloat() * 0.25 + 0.75;
            d2 *= (double)random.nextFloat() * 0.25 + 0.75;
            float f3 = MathHelper.func_76134_b((float)p_180707_14_);
            float f4 = MathHelper.func_76126_a((float)p_180707_14_);
            p_180707_6_ += (double)(MathHelper.func_76134_b((float)p_180707_13_) * f3);
            p_180707_8_ += (double)f4;
            p_180707_10_ += (double)(MathHelper.func_76126_a((float)p_180707_13_) * f3);
            p_180707_14_ *= 0.7f;
            p_180707_14_ += f1 * 0.05f;
            p_180707_13_ += f * 0.05f;
            f1 *= 0.8f;
            f *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (flag1 || random.nextInt(4) != 0) {
                double d3 = p_180707_6_ - d0;
                double d4 = p_180707_10_ - d1;
                double d5 = p_180707_16_ - p_180707_15_;
                double d6 = p_180707_12_ + 2.0f + 16.0f;
                if (d3 * d3 + d4 * d4 - d5 * d5 > d6 * d6) {
                    return;
                }
                if (p_180707_6_ >= d0 - 16.0 - d9 * 2.0 && p_180707_10_ >= d1 - 16.0 - d9 * 2.0 && p_180707_6_ <= d0 + 16.0 + d9 * 2.0 && p_180707_10_ <= d1 + 16.0 + d9 * 2.0) {
                    int k2 = MathHelper.func_76128_c((double)(p_180707_6_ - d9)) - chunkX * 16 - 1;
                    int k = MathHelper.func_76128_c((double)(p_180707_6_ + d9)) - chunkX * 16 + 1;
                    int l2 = MathHelper.func_76128_c((double)(p_180707_8_ - d2)) - 1;
                    int l = MathHelper.func_76128_c((double)(p_180707_8_ + d2)) + 1;
                    int i3 = MathHelper.func_76128_c((double)(p_180707_10_ - d9)) - chunkZ * 16 - 1;
                    int i1 = MathHelper.func_76128_c((double)(p_180707_10_ + d9)) - chunkZ * 16 + 1;
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if (k > 16) {
                        k = 16;
                    }
                    if (l2 < 1) {
                        l2 = 1;
                    }
                    if (l > 248) {
                        l = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i1 > 16) {
                        i1 = 16;
                    }
                    boolean flag2 = false;
                    for (int j1 = k2; !flag2 && j1 < k; ++j1) {
                        for (int k1 = i3; !flag2 && k1 < i1; ++k1) {
                            for (int l1 = l + 1; !flag2 && l1 >= l2 - 1; --l1) {
                                if (l1 < 0 || l1 >= 256) continue;
                                if (this.isOceanBlock(primer, j1, l1, k1, chunkX, chunkZ)) {
                                    flag2 = true;
                                }
                                if (l1 == l2 - 1 || j1 == k2 || j1 == k - 1 || k1 == i3 || k1 == i1 - 1) continue;
                                l1 = l2;
                            }
                        }
                    }
                    if (!flag2) {
                        for (int j3 = k2; j3 < k; ++j3) {
                            double d10 = ((double)(j3 + chunkX * 16) + 0.5 - p_180707_6_) / d9;
                            for (int i2 = i3; i2 < i1; ++i2) {
                                double d7 = ((double)(i2 + chunkZ * 16) + 0.5 - p_180707_10_) / d9;
                                boolean flag = false;
                                if (!(d10 * d10 + d7 * d7 < 1.0)) continue;
                                for (int j2 = l; j2 > l2; --j2) {
                                    double d8 = ((double)(j2 - 1) + 0.5 - p_180707_8_) / d2;
                                    if (!((d10 * d10 + d7 * d7) * (double)this.rs[j2 - 1] + d8 * d8 / 6.0 < 1.0)) continue;
                                    if (this.isTopBlock(primer, j3, j2, i2, chunkX, chunkZ)) {
                                        flag = true;
                                    }
                                    this.digBlock(primer, j3, j2, i2, chunkX, chunkZ, flag);
                                }
                            }
                        }
                        if (flag1) break;
                    }
                }
            }
            ++p_180707_15_;
        }
    }

    private boolean isOceanBlock(ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ) {
        Block block = primer.func_177856_a(x, y, z).func_177230_c();
        if (this.fluidBlock.isEmpty()) {
            return false;
        }
        for (Block fluidBlock : this.fluidBlock) {
            if (!fluidBlock.equals(block)) continue;
            return true;
        }
        return block == Blocks.field_150358_i || block == Blocks.field_150355_j;
    }

    private boolean isTopBlock(ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ) {
        IBlockState state = primer.func_177856_a(x, y, z);
        if (this.topBlock.isEmpty()) {
            return false;
        }
        for (Block topBlock : this.topBlock) {
            if (!topBlock.equals(state.func_177230_c())) continue;
            return true;
        }
        return state.func_177230_c() == this.top.func_177230_c();
    }

    private void digBlock(ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        IBlockState state = primer.func_177856_a(x, y, z);
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState top = biome.field_76752_A;
        IBlockState filler = biome.field_76753_B;
        if (this.canReplaceBlock(state) || state.func_177230_c() == top.func_177230_c() || state.func_177230_c() == filler.func_177230_c()) {
            if (y - 1 < 10) {
                primer.func_177855_a(x, y, z, this.lava);
            } else {
                primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                if (foundTop && primer.func_177856_a(x, y - 1, z).func_177230_c() == filler.func_177230_c()) {
                    primer.func_177855_a(x, y - 1, z, top.func_177230_c().func_176223_P());
                }
            }
        }
    }

    private boolean canReplaceBlock(IBlockState state) {
        for (Block block : this.digBlock) {
            if (!state.func_177230_c().equals(block)) continue;
            return true;
        }
        return state.func_177230_c() == this.top.func_177230_c();
    }
}

