/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.diona.world.gen.structure;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockEnclosed;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineTiered;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockLaserTurret;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityLaserTurret;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityChestMP;
import stevekung.mods.moreplanets.utils.world.gen.feature.ElectricFireBlockProcessor;
import stevekung.mods.stevekunglib.utils.enums.CachedEnum;

public class StructureAbandonedSatellitePieces
extends StructureComponent {
    private static final ResourceLocation SATELLITE_BASE_ID = new ResourceLocation("moreplanets:abandoned_satellite/satellite_base");
    private static final ResourceLocation SATELLITE_DISH_BASE_ID = new ResourceLocation("moreplanets:abandoned_satellite/dish_base");
    private static final ResourceLocation SATELLITE_DISH_ID = new ResourceLocation("moreplanets:abandoned_satellite/dish");
    protected int width;
    protected int height;
    protected int depth;
    protected int horizontalPos = -1;

    public StructureAbandonedSatellitePieces() {
    }

    public StructureAbandonedSatellitePieces(Random rand, int x, int z) {
        this(rand, x, 64, z, 4, 11, 4);
    }

    protected StructureAbandonedSatellitePieces(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(0);
        this.width = sizeX;
        this.height = sizeY;
        this.depth = sizeZ;
        this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        nbt.func_74768_a("Width", this.width);
        nbt.func_74768_a("Height", this.height);
        nbt.func_74768_a("Depth", this.depth);
        nbt.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        this.width = nbt.func_74762_e("Width");
        this.height = nbt.func_74762_e("Height");
        this.depth = nbt.func_74762_e("Depth");
        this.horizontalPos = nbt.func_74762_e("HPos");
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox structureBoundingBox) {
        if (!this.offsetToAverageGroundLevel(world, structureBoundingBox, -1)) {
            return false;
        }
        StructureBoundingBox box = this.func_74874_b();
        BlockPos pos = new BlockPos(box.field_78897_a, box.field_78895_b, box.field_78896_c);
        Rotation[] arotation = CachedEnum.rotationValues;
        Rotation rotation = arotation[rand.nextInt(arotation.length)];
        MinecraftServer server = world.func_73046_m();
        TemplateManager manager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186225_a(Blocks.field_189881_dj).func_186223_a(box);
        settings.func_189946_a(0.85f);
        Template template = manager.func_186237_a(server, SATELLITE_BASE_ID);
        Template template1 = manager.func_186237_a(server, SATELLITE_DISH_BASE_ID);
        Template template2 = manager.func_186237_a(server, SATELLITE_DISH_ID);
        this.addBlocksToWorldChunk(template, world, pos, settings);
        BlockPos blockpos1 = template.func_186262_a(settings, new BlockPos(0, 4, 0), settings, new BlockPos(-1, 0, -1));
        this.addBlocksToWorldChunk(template1, world, pos.func_177971_a((Vec3i)blockpos1), settings);
        BlockPos blockpos4 = pos.func_177971_a((Vec3i)template.func_186262_a(settings, new BlockPos(0, 8, 0), settings, new BlockPos(0, 0, 4)));
        this.addBlocksToWorldChunk(template2, world, blockpos4, settings);
        Map map = template.func_186258_a(pos, settings);
        for (Map.Entry entry : map.entrySet()) {
            TileEntity tile;
            BlockPos blockpos2;
            if ("laser_turret".equals(entry.getValue())) {
                blockpos2 = (BlockPos)entry.getKey();
                world.func_180501_a(blockpos2, VenusBlocks.laserTurret.func_176223_P().func_177226_a((IProperty)BlockLaserTurret.FACING, (Comparable)rotation.func_185831_a(EnumFacing.NORTH)), 3);
                tile = world.func_175625_s(blockpos2);
                if (!(tile instanceof TileEntityLaserTurret)) continue;
                TileEntityLaserTurret turret = (TileEntityLaserTurret)tile;
                turret.setOwnerUUID(UUID.randomUUID());
                turret.addPlayer("");
                turret.targetMeteors = false;
                turret.getPositions(blockpos2, new ArrayList());
                turret.onCreate(world, blockpos2);
                continue;
            }
            if ("chest_and_wire".equals(entry.getValue())) {
                blockpos2 = (BlockPos)entry.getKey();
                world.func_180501_a(blockpos2, GCBlocks.sealableBlock.func_176223_P().func_177226_a((IProperty)BlockEnclosed.TYPE, (Comparable)BlockEnclosed.EnumEnclosedBlockType.ALUMINUM_WIRE_HEAVY), 3);
                tile = world.func_175625_s(blockpos2.func_177977_b());
                if (!(tile instanceof TileEntityChestMP)) continue;
                ((TileEntityChestMP)tile).func_189404_a(MPLootTables.CRASHED_ALIEN_PROBE, rand.nextLong());
                continue;
            }
            if (!"energy_storage".equals(entry.getValue())) continue;
            blockpos2 = (BlockPos)entry.getKey();
            world.func_180501_a(blockpos2, GCBlocks.machineTiered.func_176223_P().func_177226_a((IProperty)BlockMachineTiered.TYPE, (Comparable)BlockMachineTiered.EnumTieredMachineType.STORAGE_MODULE).func_177226_a((IProperty)BlockMachineBase.FACING, (Comparable)rotation.func_185831_a(EnumFacing.SOUTH)), 3);
            tile = world.func_175625_s(blockpos2);
            if (!(tile instanceof TileEntityEnergyStorageModule)) continue;
            TileEntityEnergyStorageModule module = (TileEntityEnergyStorageModule)tile;
            module.storage.setEnergyStored(500000.0f);
            module.func_70299_a(1, new ItemStack(VenusItems.atomicBattery));
        }
        return true;
    }

    private void addBlocksToWorldChunk(Template template, World world, BlockPos pos, PlacementSettings placement) {
        placement.func_186224_i();
        template.func_189960_a(world, pos, (ITemplateProcessor)new ElectricFireBlockProcessor(pos, placement), placement, 2);
    }

    private boolean offsetToAverageGroundLevel(World world, StructureBoundingBox box, int yOffset) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                mutablePos.func_181079_c(l, 64, k);
                if (!box.func_175898_b((Vec3i)mutablePos)) continue;
                i += Math.max(world.func_175672_r((BlockPos)mutablePos).func_177956_o(), 56);
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.horizontalPos = i / j;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
        return true;
    }
}

