/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.biome;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityGiantWorm;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedChicken;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedCow;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedCreeper;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedSkeleton;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedSquid;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedZombie;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityShlime;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.BiomeDecoratorNibiru;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedBigTree;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedTrees;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedVinesDirt;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenNibiruFossils;
import stevekung.mods.moreplanets.utils.world.gen.biome.BiomeMP;
import stevekung.mods.stevekunglib.world.gen.WorldGenFlowersBase;

public class BiomeNibiru
extends BiomeMP {
    protected IBlockState stoneBlock;
    protected IBlockState liquidBlock;
    protected final BiomeDecoratorNibiru field_76760_I = new BiomeDecoratorNibiru();
    protected static final WorldGenInfectedBigTree BIG_TREE = new WorldGenInfectedBigTree(true, MPBlocks.INFECTED_OAK_LOG.func_176223_P(), MPBlocks.INFECTED_OAK_LEAVES.func_176223_P());
    protected static final WorldGenInfectedBigTree BIG_TREE_NO_LEAVES = new WorldGenInfectedBigTree(false, MPBlocks.INFECTED_OAK_LOG.func_176223_P(), MPBlocks.INFECTED_OAK_LEAVES.func_176223_P());
    protected static final WorldGenInfectedTrees TREE = new WorldGenInfectedTrees(true, MPBlocks.INFECTED_OAK_LOG.func_176223_P(), MPBlocks.INFECTED_OAK_LEAVES.func_176223_P());
    protected static final WorldGenInfectedTrees TREE_NO_LEAVES = new WorldGenInfectedTrees(false, MPBlocks.INFECTED_OAK_LOG.func_176223_P(), MPBlocks.INFECTED_OAK_LEAVES.func_176223_P());
    protected static final WorldGenInfectedVinesDirt SCATTERED_DIRT = new WorldGenInfectedVinesDirt();
    protected static final WorldGenNibiruFossils FOSSILS = new WorldGenNibiruFossils();
    protected static final WorldGenFlowersBase GRASS = new WorldGenFlowersBase(MPBlocks.INFECTED_GRASS.func_176223_P());

    public BiomeNibiru(Biome.BiomeProperties prop) {
        super(prop);
        this.field_76752_A = MPBlocks.INFECTED_GRASS_BLOCK.func_176223_P();
        this.field_76753_B = MPBlocks.INFECTED_DIRT.func_176223_P();
        this.stoneBlock = MPBlocks.NIBIRU_ROCK.func_176223_P();
        this.liquidBlock = MPBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityInfectedZombie.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityInfectedSkeleton.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityInfectedCreeper.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityGiantWorm.class, 20, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityInfectedChicken.class, 10, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityInfectedCow.class, 8, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityShlime.class, 12, 4, 4));
        this.field_76755_L.add(new Biome.SpawnListEntry(EntityInfectedSquid.class, 10, 4, 4));
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        this.field_76760_I.func_180292_a(world, rand, this, pos);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return rand.nextInt(10) == 0 ? BIG_TREE : TREE;
    }

    public WorldGenerator func_76730_b(Random rand) {
        return GRASS;
    }

    public void addDefaultFlowers() {
        this.addFlower(MPBlocks.PURE_HERB.func_176223_P(), 20);
    }

    @Override
    public IBlockState pickRandomModdedFlower(Random rand, BlockPos pos) {
        return MPBlocks.PURE_HERB.func_176223_P();
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int chunkX, int chunkZ, double noiseVal) {
        int seaLevel = world.func_181545_F();
        IBlockState topState = this.field_76752_A;
        IBlockState fillerState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int x = chunkZ & 0xF;
        int z = chunkX & 0xF;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = 255; y >= 0; --y) {
            if (y <= rand.nextInt(5)) {
                primer.func_177855_a(x, y, z, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            IBlockState stoneState = primer.func_177856_a(x, y, z);
            if (stoneState.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (stoneState.func_177230_c() != MPBlocks.NIBIRU_ROCK) continue;
            primer.func_177855_a(x, y, z, this.stoneBlock);
            if (j == -1) {
                if (k <= 0) {
                    topState = null;
                    fillerState = MPBlocks.NIBIRU_ROCK.func_176223_P();
                } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                    topState = this.field_76752_A;
                    fillerState = this.field_76753_B;
                }
                if (y < seaLevel && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = this.func_180626_a((BlockPos)mutablePos.func_181079_c(chunkX, y, chunkZ)) < 0.15f ? MPBlocks.INFECTED_ICE.func_176223_P() : this.liquidBlock;
                }
                j = k;
                if (y >= seaLevel - 1) {
                    primer.func_177855_a(x, y, z, topState);
                    continue;
                }
                if (y < seaLevel - 7 - k) {
                    topState = null;
                    fillerState = MPBlocks.NIBIRU_ROCK.func_176223_P();
                    primer.func_177855_a(x, y, z, MPBlocks.INFECTED_GRAVEL.func_176223_P());
                    continue;
                }
                primer.func_177855_a(x, y, z, fillerState);
                continue;
            }
            if (j <= 0) continue;
            primer.func_177855_a(x, y, z, fillerState);
            if (--j != 0 || fillerState.func_177230_c() != MPBlocks.INFECTED_SAND) continue;
            j = rand.nextInt(4) + Math.max(0, y - 63);
            fillerState = MPBlocks.INFECTED_SANDSTONE.func_176223_P();
        }
    }
}

