/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.arch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kr.pe.ecmaxp.openpython.arch.OpenComputersLikeSaveHandler;
import kr.pe.ecmaxp.openpython.arch.OpenPythonFirmware;
import kr.pe.ecmaxp.openpython.arch.OpenPythonInterruptHandler;
import kr.pe.ecmaxp.openpython.arch.OpenPythonMemoryRegion;
import kr.pe.ecmaxp.openpython.arch.OpenPythonVirtualMachineState;
import kr.pe.ecmaxp.openpython.arch.types.Interrupt;
import kr.pe.ecmaxp.thumbsf.CPU;
import kr.pe.ecmaxp.thumbsf.Memory;
import kr.pe.ecmaxp.thumbsf.MemoryRegion;
import kr.pe.ecmaxp.thumbsf.Registers;
import kr.pe.ecmaxp.thumbsf.exc.InvalidMemoryException;
import kr.pe.ecmaxp.thumbsf.signal.ControlSignal;
import li.cil.oc.api.machine.ExecutionResult;
import li.cil.oc.api.machine.Machine;
import li.cil.oc.api.machine.MachineHost;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\"2\u0006\u0010$\u001a\u00020%J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachine;", "", "machine", "Lli/cil/oc/api/machine/Machine;", "memorySize", "", "firmware", "Lkr/pe/ecmaxp/openpython/arch/OpenPythonFirmware;", "(Lli/cil/oc/api/machine/Machine;ILkr/pe/ecmaxp/openpython/arch/OpenPythonFirmware;)V", "cpu", "Lkr/pe/ecmaxp/thumbsf/CPU;", "getCpu", "()Lkr/pe/ecmaxp/thumbsf/CPU;", "getFirmware", "()Lkr/pe/ecmaxp/openpython/arch/OpenPythonFirmware;", "setFirmware", "(Lkr/pe/ecmaxp/openpython/arch/OpenPythonFirmware;)V", "interruptHandler", "Lkr/pe/ecmaxp/openpython/arch/OpenPythonInterruptHandler;", "getInterruptHandler", "()Lkr/pe/ecmaxp/openpython/arch/OpenPythonInterruptHandler;", "setInterruptHandler", "(Lkr/pe/ecmaxp/openpython/arch/OpenPythonInterruptHandler;)V", "getMachine", "()Lli/cil/oc/api/machine/Machine;", "getMemorySize", "()I", "state", "Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachineState;", "getState", "()Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachineState;", "setState", "(Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachineState;)V", "close", "", "load", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "save", "step", "Lli/cil/oc/api/machine/ExecutionResult;", "synchronized", "", "OpenPython"})
public final class OpenPythonVirtualMachine {
    @NotNull
    private final CPU cpu;
    @NotNull
    private OpenPythonVirtualMachineState state;
    @NotNull
    private OpenPythonInterruptHandler interruptHandler;
    @NotNull
    private final Machine machine;
    private final int memorySize;
    @NotNull
    private OpenPythonFirmware firmware;

    @NotNull
    public final CPU getCpu() {
        return this.cpu;
    }

    @NotNull
    public final OpenPythonVirtualMachineState getState() {
        return this.state;
    }

    public final void setState(@NotNull OpenPythonVirtualMachineState openPythonVirtualMachineState) {
        Intrinsics.checkParameterIsNotNull((Object)openPythonVirtualMachineState, (String)"<set-?>");
        this.state = openPythonVirtualMachineState;
    }

    @NotNull
    public final OpenPythonInterruptHandler getInterruptHandler() {
        return this.interruptHandler;
    }

    public final void setInterruptHandler(@NotNull OpenPythonInterruptHandler openPythonInterruptHandler) {
        Intrinsics.checkParameterIsNotNull((Object)openPythonInterruptHandler, (String)"<set-?>");
        this.interruptHandler = openPythonInterruptHandler;
    }

    public final void close() {
    }

    @NotNull
    public final ExecutionResult step(boolean bl) {
        ExecutionResult executionResult;
        try {
            this.cpu.run(bl ? 1 : 10000000, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, bl){
                final /* synthetic */ OpenPythonVirtualMachine this$0;
                final /* synthetic */ boolean $synchronized;

                public final void invoke(int it) {
                    Interrupt interrupt = new Interrupt(this.this$0.getCpu(), it, this.this$0);
                    this.this$0.getInterruptHandler().invoke(interrupt, this.$synchronized);
                }
                {
                    this.this$0 = openPythonVirtualMachine;
                    this.$synchronized = bl;
                    super(1);
                }
            }));
            executionResult = (ExecutionResult)new ExecutionResult.Sleep(0);
        }
        catch (ControlSignal controlSignal) {
            if (!(controlSignal.getValue() instanceof ExecutionResult)) {
                throw (Throwable)controlSignal;
            }
            executionResult = (ExecutionResult)controlSignal.getValue();
        }
        catch (InvalidMemoryException e) {
            ExecutionResult.Error error;
            this.firmware.printLastTracebackCPU(this.cpu);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%08X";
            Object[] objectArray = new Object[]{e.getAddress()};
            StringBuilder stringBuilder = new StringBuilder().append("memory access violation:\n0x");
            ExecutionResult.Error error2 = error;
            ExecutionResult.Error error3 = error;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            error2(stringBuilder.append(string3).toString());
            executionResult = (ExecutionResult)error3;
        }
        catch (Throwable e) {
            this.firmware.printLastTracebackCPU(this.cpu);
            throw e;
        }
        return executionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull NBTTagCompound tag) {
        NBTTagCompound stateTag;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        MachineHost machineHost = this.machine.host();
        Intrinsics.checkExpressionValueIsNotNull((Object)machineHost, (String)"machine.host()");
        String string = this.machine.node().address();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"machine.node().address()");
        NBTTagCompound nBTTagCompound = OpenComputersLikeSaveHandler.INSTANCE.loadNbt(machineHost, tag, string);
        if (nBTTagCompound == null) {
            OpenPythonVirtualMachine openPythonVirtualMachine;
            OpenPythonVirtualMachine $receiver = openPythonVirtualMachine = this;
            if ($receiver.machine.isRunning()) {
                $receiver.machine.crash("Missing data");
            }
            return;
        }
        NBTTagCompound rootTag = nBTTagCompound;
        NBTTagCompound firmwareTag = rootTag.func_74775_l("firmware");
        String firmwareName = firmwareTag.func_74779_i("name");
        if (Intrinsics.areEqual((Object)this.firmware.getName(), (Object)firmwareName) ^ true) {
            try {
                String string2 = firmwareName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"firmwareName");
                this.firmware = new OpenPythonFirmware(string2);
            }
            catch (Exception e) {
                String string3 = firmwareName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"firmwareName");
                if (StringsKt.startsWith$default((String)string3, (String)"v1.0.", (boolean)false, (int)2, null)) {
                    e.printStackTrace();
                    this.firmware = OpenPythonFirmware.Companion.getV1_0_1();
                }
                throw (Throwable)e;
            }
        }
        NBTTagCompound cpuTag = rootTag.func_74775_l("cpu");
        Registers registers = this.cpu.getRegs();
        int[] nArray = cpuTag.func_74759_k("regs");
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"cpuTag.getIntArray(\"regs\")");
        registers.store(nArray);
        NBTTagList memoryTag = cpuTag.func_150295_c("memory", (int)new NBTTagCompound().func_74732_a());
        Iterator iterator = memoryTag.iterator();
        while (iterator.hasNext()) {
            byte[] byArray;
            GZIPInputStream gZIPInputStream;
            NBTBase regionBaseTag;
            NBTBase nBTBase = regionBaseTag = (NBTBase)iterator.next();
            if (nBTBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            NBTTagCompound regionTag = (NBTTagCompound)nBTBase;
            int address = (int)regionTag.func_74763_f("address");
            byte[] compressed = regionTag.func_74770_j("buffer");
            Intrinsics.checkExpressionValueIsNotNull((Object)compressed, (String)"compressed");
            Object object = compressed;
            GZIPInputStream gZIPInputStream2 = gZIPInputStream;
            GZIPInputStream gZIPInputStream3 = gZIPInputStream;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            gZIPInputStream2(byteArrayInputStream);
            object = gZIPInputStream3;
            Throwable throwable = null;
            try {
                GZIPInputStream it = (GZIPInputStream)object;
                byArray = ByteStreamsKt.readBytes$default((InputStream)it, (int)0, (int)1, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            byte[] content = byArray;
            try {
                this.cpu.getMemory().writeBuffer(address, content);
            }
            catch (InvalidMemoryException e) {
                this.machine.crash("InvalidMemoryException while load() from world");
                return;
            }
        }
        NBTTagCompound nBTTagCompound2 = stateTag = rootTag.func_74775_l("state");
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound2, (String)"stateTag");
        this.state.load(nBTTagCompound2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        NBTTagCompound firmwareTag = new NBTTagCompound();
        firmwareTag.func_74778_a("name", this.firmware.getName());
        firmwareTag.func_74768_a("protocol", this.firmware.getProtocol());
        NBTTagCompound cpuTag = new NBTTagCompound();
        NBTTagList memoryTag = new NBTTagList();
        for (MemoryRegion region : this.cpu.getMemory().fork()) {
            NBTTagCompound regionTag = new NBTTagCompound();
            regionTag.func_74772_a("address", Integer.toUnsignedLong(region.getBegin()));
            regionTag.func_74768_a("size", region.getSize());
            regionTag.func_74768_a("flag", region.getFlag().ordinal());
            byte[] content = region.getBuffer$OpenPython();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Closeable closeable = new GZIPOutputStream(stream);
            Throwable throwable = null;
            try {
                GZIPOutputStream it = (GZIPOutputStream)closeable;
                it.write(content);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] compressed = stream.toByteArray();
            regionTag.func_74773_a("buffer", compressed);
            memoryTag.func_74742_a((NBTBase)regionTag);
        }
        cpuTag.func_74783_a("regs", this.cpu.getRegs().load());
        cpuTag.func_74782_a("memory", (NBTBase)memoryTag);
        NBTTagCompound stateTag = new NBTTagCompound();
        this.state.save(stateTag);
        NBTTagCompound rootTag = new NBTTagCompound();
        rootTag.func_74782_a("firmware", (NBTBase)firmwareTag);
        rootTag.func_74782_a("cpu", (NBTBase)cpuTag);
        rootTag.func_74782_a("state", (NBTBase)stateTag);
        MachineHost machineHost = this.machine.host();
        Intrinsics.checkExpressionValueIsNotNull((Object)machineHost, (String)"machine.host()");
        String string = this.machine.node().address();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"machine.node().address()");
        OpenComputersLikeSaveHandler.INSTANCE.scheduleSave(machineHost, tag, string, rootTag);
    }

    @NotNull
    public final Machine getMachine() {
        return this.machine;
    }

    public final int getMemorySize() {
        return this.memorySize;
    }

    @NotNull
    public final OpenPythonFirmware getFirmware() {
        return this.firmware;
    }

    public final void setFirmware(@NotNull OpenPythonFirmware openPythonFirmware) {
        Intrinsics.checkParameterIsNotNull((Object)openPythonFirmware, (String)"<set-?>");
        this.firmware = openPythonFirmware;
    }

    public OpenPythonVirtualMachine(@NotNull Machine machine, int memorySize, @NotNull OpenPythonFirmware firmware) {
        Memory memory;
        Intrinsics.checkParameterIsNotNull((Object)machine, (String)"machine");
        Intrinsics.checkParameterIsNotNull((Object)firmware, (String)"firmware");
        this.machine = machine;
        this.memorySize = memorySize;
        this.firmware = firmware;
        this.cpu = new CPU(null, null, 3, null);
        this.state = new OpenPythonVirtualMachineState();
        this.interruptHandler = new OpenPythonInterruptHandler(this);
        Memory $receiver = memory = this.cpu.getMemory();
        $receiver.flash(OpenPythonMemoryRegion.FLASH.getAddress(), OpenPythonMemoryRegion.FLASH.getSize(), this.firmware.loadFirmware());
        $receiver.map(OpenPythonMemoryRegion.SRAM.getAddress(), OpenPythonMemoryRegion.SRAM.getSize(), OpenPythonMemoryRegion.SRAM.getFlag());
        $receiver.map(OpenPythonMemoryRegion.RAM.getAddress(), this.memorySize, OpenPythonMemoryRegion.RAM.getFlag());
        $receiver.map(OpenPythonMemoryRegion.SYSCALL.getAddress(), OpenPythonMemoryRegion.SYSCALL.getSize(), OpenPythonMemoryRegion.SYSCALL.getFlag());
        Memory memory2 = memory;
        this.cpu.getRegs().set(15, memory2.readInt(OpenPythonMemoryRegion.FLASH.getAddress() + 4) & ~1);
    }
}

