/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

class DirectBufferAccess {
    static Method mGetAddress;
    static Method mCleaner;
    static Method mClean;
    static Constructor byteBufferConstructor;
    static Class<?> directByteBufferClass;
    static DirectBufferConstructorType directBufferConstructorType;
    static Method memoryBlockWrapFromJni;

    private DirectBufferAccess() {
    }

    static long getAddress(Object base) {
        try {
            return (Long)mGetAddress.invoke(base, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static void clean(Object base) {
        try {
            Object cleaner = mCleaner.invoke(base, new Object[0]);
            mClean.invoke(cleaner, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isDirectByteBufferInstance(Object s) {
        return directByteBufferClass.isInstance(s);
    }

    static ByteBuffer newByteBuffer(long address, int index, int length, ByteBuffer reference) {
        try {
            switch (directBufferConstructorType) {
                case ARGS_LONG_INT_REF: {
                    return (ByteBuffer)byteBufferConstructor.newInstance(address + (long)index, length, reference);
                }
                case ARGS_LONG_INT: {
                    return (ByteBuffer)byteBufferConstructor.newInstance(address + (long)index, length);
                }
                case ARGS_INT_INT: {
                    return (ByteBuffer)byteBufferConstructor.newInstance((int)address + index, length);
                }
                case ARGS_MB_INT_INT: {
                    return (ByteBuffer)byteBufferConstructor.newInstance(memoryBlockWrapFromJni.invoke(null, address + (long)index, length), length, 0);
                }
            }
            throw new IllegalStateException("Unexpected value");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            directByteBufferClass = ClassLoader.getSystemClassLoader().loadClass("java.nio.DirectByteBuffer");
            Constructor<?> directByteBufferConstructor = null;
            DirectBufferConstructorType constructorType = null;
            Method mbWrap = null;
            try {
                directByteBufferConstructor = directByteBufferClass.getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
                constructorType = DirectBufferConstructorType.ARGS_LONG_INT_REF;
            }
            catch (NoSuchMethodException e0) {
                try {
                    directByteBufferConstructor = directByteBufferClass.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                    constructorType = DirectBufferConstructorType.ARGS_LONG_INT;
                }
                catch (NoSuchMethodException e1) {
                    try {
                        directByteBufferConstructor = directByteBufferClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
                        constructorType = DirectBufferConstructorType.ARGS_INT_INT;
                    }
                    catch (NoSuchMethodException e2) {
                        Class<?> aClass = Class.forName("java.nio.MemoryBlock");
                        mbWrap = aClass.getDeclaredMethod("wrapFromJni", Integer.TYPE, Long.TYPE);
                        mbWrap.setAccessible(true);
                        directByteBufferConstructor = directByteBufferClass.getDeclaredConstructor(aClass, Integer.TYPE, Integer.TYPE);
                        constructorType = DirectBufferConstructorType.ARGS_MB_INT_INT;
                    }
                }
            }
            byteBufferConstructor = directByteBufferConstructor;
            directBufferConstructorType = constructorType;
            memoryBlockWrapFromJni = mbWrap;
            if (byteBufferConstructor == null) {
                throw new RuntimeException("Constructor of DirectByteBuffer is not found");
            }
            byteBufferConstructor.setAccessible(true);
            mGetAddress = directByteBufferClass.getDeclaredMethod("address", new Class[0]);
            mGetAddress.setAccessible(true);
            mCleaner = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
            mCleaner.setAccessible(true);
            mClean = mCleaner.getReturnType().getDeclaredMethod("clean", new Class[0]);
            mClean.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static enum DirectBufferConstructorType {
        ARGS_LONG_INT_REF,
        ARGS_LONG_INT,
        ARGS_INT_INT,
        ARGS_MB_INT_INT;

    }
}

