/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.thumbsf;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kr.pe.ecmaxp.thumbsf.DecoderKt;
import kr.pe.ecmaxp.thumbsf.Memory;
import kr.pe.ecmaxp.thumbsf.Registers;
import kr.pe.ecmaxp.thumbsf.exc.InvalidAddressArmException;
import kr.pe.ecmaxp.thumbsf.exc.InvalidMemoryException;
import kr.pe.ecmaxp.thumbsf.exc.UnexceptedLogicError;
import kr.pe.ecmaxp.thumbsf.exc.UnknownInstructionException;
import kr.pe.ecmaxp.thumbsf.signal.ControlPauseSignal;
import kr.pe.ecmaxp.thumbsf.signal.ControlStopSignal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JG\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u00142\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0000J\u0010\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005J1\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00142!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00120 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lkr/pe/ecmaxp/thumbsf/CPU;", "", "memory", "Lkr/pe/ecmaxp/thumbsf/Memory;", "regs", "Lkr/pe/ecmaxp/thumbsf/Registers;", "(Lkr/pe/ecmaxp/thumbsf/Memory;Lkr/pe/ecmaxp/thumbsf/Registers;)V", "getMemory", "()Lkr/pe/ecmaxp/thumbsf/Memory;", "getRegs", "()Lkr/pe/ecmaxp/thumbsf/Registers;", "totalInsnCount", "", "getTotalInsnCount", "()J", "setTotalInsnCount", "(J)V", "call", "", "address", "", "r0", "r1", "r2", "r3", "lr", "(IIIIILjava/lang/Integer;)V", "copy", "fork", "run", "insnCount", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "imm", "OpenPython"})
public final class CPU {
    private long totalInsnCount;
    @NotNull
    private final Memory memory;
    @NotNull
    private final Registers regs;

    public final long getTotalInsnCount() {
        return this.totalInsnCount;
    }

    public final void setTotalInsnCount(long l) {
        this.totalInsnCount = l;
    }

    @NotNull
    public final CPU copy() {
        return new CPU(this.memory.copy(), this.regs.copy());
    }

    @NotNull
    public final CPU fork(@NotNull Registers regs) {
        Intrinsics.checkParameterIsNotNull((Object)regs, (String)"regs");
        return new CPU(this.memory.fork(), regs);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CPU fork$default(CPU cPU, Registers registers, int n, Object object) {
        if ((n & 1) != 0) {
            registers = new Registers();
        }
        return cPU.fork(registers);
    }

    public final void call(int address, int r0, int r1, int r2, int r3, @Nullable Integer lr) {
        this.regs.set(15, address);
        this.regs.set(0, r0);
        this.regs.set(1, r1);
        this.regs.set(2, r2);
        this.regs.set(3, r3);
        if (lr != null) {
            this.regs.set(14, lr);
        }
    }

    public static /* bridge */ /* synthetic */ void call$default(CPU cPU, int n, int n2, int n3, int n4, int n5, Integer n6, int n7, Object object) {
        if ((n7 & 2) != 0) {
            n2 = 0;
        }
        if ((n7 & 4) != 0) {
            n3 = 0;
        }
        if ((n7 & 8) != 0) {
            n4 = 0;
        }
        if ((n7 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x20) != 0) {
            n6 = null;
        }
        cPU.call(n, n2, n3, n4, n5, n6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void run(int insnCount, @NotNull Function1<? super Integer, Unit> handler) throws InvalidMemoryException, UnknownInstructionException, InvalidAddressArmException {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        Memory memory = this.memory;
        int[] REGS = this.regs.fastLoad();
        int lr = this.regs.getLr();
        int sp = this.regs.getSp();
        int pc = this.regs.getPc();
        boolean v = this.regs.getV();
        boolean c = this.regs.getC();
        boolean z = this.regs.getZ();
        boolean n = this.regs.getN();
        boolean bl2 = bl = (pc & 1) == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Pair<int[], Integer> pair = memory.loadExecCache(pc &= ~1);
        int[] nArray = (int[])pair.component1();
        int base = ((Number)pair.component2()).intValue();
        int count = insnCount;
        try {
            block137: while (count-- > 0) {
                void buffer;
                void code = buffer[pc - base];
                switch (code & 0xFF) {
                    case 0: {
                        void newCode;
                        Pair<Integer, Integer> pair2 = DecoderKt.decode(memory, pc);
                        int n2 = ((Number)pair2.component1()).intValue();
                        int newImm32 = ((Number)pair2.component2()).intValue();
                        switch (newCode & 0xFF) {
                            case 0: {
                                throw (Throwable)((Object)new UnexceptedLogicError());
                            }
                        }
                        buffer[pc - base] = newCode;
                        buffer[pc - base + 1] = newImm32;
                        continue block137;
                    }
                    case 1: {
                        pc += 2;
                        continue block137;
                    }
                    case 83: {
                        throw (Throwable)new UnknownInstructionException();
                    }
                    case 2: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int left = REGS[Rs];
                        void right = imm16;
                        int value = left << right;
                        n = value < 0;
                        boolean bl3 = z = value == 0;
                        if (right > 0) {
                            c = (left << right - true & Integer.MIN_VALUE) != 0;
                        }
                        REGS[Rd] = value;
                        pc += 2;
                        continue block137;
                    }
                    case 3: {
                        int value;
                        int n3;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int left = REGS[Rs];
                        void right = imm16;
                        if (right == 32) {
                            c = (left & Integer.MIN_VALUE) != 0;
                            n3 = 0;
                        } else {
                            c = (left & 1 << right - true) != 0;
                            n3 = left >>> right;
                        }
                        REGS[Rd] = value = n3;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 4: {
                        int value;
                        int n4;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int left = REGS[Rs];
                        void right = imm16;
                        if (right == 32) {
                            boolean bl4 = c = (left & Integer.MIN_VALUE) != 0;
                            n4 = left > 0 ? 0 : -1;
                        } else {
                            c = (left & 1 << right - true) != 0;
                            n4 = left >> right;
                        }
                        REGS[Rd] = value = n4;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 5: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int left = REGS[Rs];
                        int right = REGS[Rn];
                        long Lleft = Integer.toUnsignedLong(left);
                        long Lright = Integer.toUnsignedLong(right);
                        long Lvalue = Lleft + Lright;
                        int value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ value) & (right ^ value)) < 0;
                        REGS[Rd] = value;
                        pc += 2;
                        continue block137;
                    }
                    case 6: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int left = REGS[Rs];
                        void right = imm16;
                        long Lleft = Integer.toUnsignedLong(left);
                        long Lright = Integer.toUnsignedLong((int)right);
                        long Lvalue = Lleft + Lright;
                        int value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ value) & (right ^ value)) < 0;
                        REGS[Rd] = value;
                        pc += 2;
                        continue block137;
                    }
                    case 7: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int left = REGS[Rs];
                        int right = REGS[Rn];
                        long Lleft = Integer.toUnsignedLong(left);
                        long LIright = Integer.toUnsignedLong(~right);
                        long Lvalue = Lleft + LIright + 1L;
                        int value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ right) & (left ^ value)) < 0;
                        REGS[Rd] = value;
                        pc += 2;
                        continue block137;
                    }
                    case 8: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int left = REGS[Rs];
                        void right = imm16;
                        long Lleft = Integer.toUnsignedLong(left);
                        long LIright = Integer.toUnsignedLong((int)(~right));
                        long Lvalue = Lleft + LIright + 1L;
                        int value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ right) & (left ^ value)) < 0;
                        REGS[Rd] = value;
                        pc += 2;
                        continue block137;
                    }
                    case 9: {
                        void imm16;
                        int Rd = code >> 8 & 0xF;
                        void value = imm16 = code >> 16;
                        REGS[Rd] = value;
                        n = value < 0;
                        z = value == false;
                        pc += 2;
                        continue block137;
                    }
                    case 10: {
                        int Rd = code >> 8 & 0xF;
                        void imm16 = code >> 16;
                        int left = REGS[Rd];
                        void right = imm16;
                        long Lvalue = Integer.toUnsignedLong(left) + Integer.toUnsignedLong((int)(~right)) + 1L;
                        int value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ right) & (left ^ value)) < 0;
                        pc += 2;
                        continue block137;
                    }
                    case 11: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        void imm16 = code >> 16;
                        int left = REGS[Rd];
                        void right = imm16;
                        long Lvalue = Integer.toUnsignedLong(left) + Integer.toUnsignedLong((int)right);
                        REGS[Rd] = value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ value) & (right ^ value)) < 0;
                        pc += 2;
                        continue block137;
                    }
                    case 12: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        void imm16 = code >> 16;
                        int left = REGS[Rd];
                        void right = imm16;
                        long Lvalue = Integer.toUnsignedLong(left) + Integer.toUnsignedLong((int)(~right)) + 1L;
                        REGS[Rd] = value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ right) & (left ^ value)) < 0;
                        pc += 2;
                        continue block137;
                    }
                    case 13: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        REGS[Rd] = value = left & right;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 14: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        REGS[Rd] = value = left ^ right;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 15: {
                        int value;
                        int n5;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        if (right >= 32) {
                            c = right == 32 && (left & 1) != 0;
                            n5 = 0;
                        } else if (right < 0) {
                            c = false;
                            n5 = 0;
                        } else if (right == 0) {
                            n5 = left;
                        } else {
                            c = (left << right - 1 & Integer.MIN_VALUE) != 0;
                            n5 = left << right;
                        }
                        REGS[Rd] = value = n5;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 16: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        if (right >= 32) {
                            value = 0;
                            c = right == 32 && (left & Integer.MIN_VALUE) != 0;
                        } else if (right < 0) {
                            value = 0;
                            c = false;
                        } else if (right == 0) {
                            value = left;
                        } else {
                            value = left >>> right;
                            c = (left >>> right - 1 & 1) != 0;
                        }
                        REGS[Rd] = value;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 17: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        if (right < 0 || right >= 32) {
                            value = left > 0 ? 0 : -1;
                            c = value < 0;
                        } else if (right == 0) {
                            value = left;
                        } else {
                            REGS[Rd] = value = left >> right;
                            c = (left & 1 << right - 1) != 0;
                        }
                        REGS[Rd] = value;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 18: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        long Lvalue = Integer.toUnsignedLong(left) + Integer.toUnsignedLong(right) + (c ? 1L : 0L);
                        REGS[Rd] = value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue != (long)value;
                        v = left > 0 && right > 0 && value < 0 || left < 0 && right < 0 && value > 0;
                        pc += 2;
                        continue block137;
                    }
                    case 19: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        long Lvalue = (long)left - (long)right - (c ? 0L : 1L);
                        REGS[Rd] = value = left - right - (c ? 0 : 1);
                        n = value < 0;
                        z = value == 0;
                        c = c || value < 0;
                        v = Lvalue != (long)value;
                        pc += 2;
                        continue block137;
                    }
                    case 20: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        REGS[Rd] = value = left >>> (right &= 0x1F) | left << 32 - right;
                        n = value < 0;
                        z = value == 0;
                        c = (left >>> right - 1 & 1) != 0;
                        pc += 2;
                        continue block137;
                    }
                    case 21: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        int value = left & right;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 22: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int right = REGS[Rs];
                        long Lvalue = Integer.toUnsignedLong(~right) + 1L;
                        REGS[Rd] = value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = (right & value) < 0;
                        pc += 2;
                        continue block137;
                    }
                    case 23: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        long Lvalue = Integer.toUnsignedLong(left) + Integer.toUnsignedLong(~right) + 1L;
                        int value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ right) & (left ^ value)) < 0;
                        pc += 2;
                        continue block137;
                    }
                    case 24: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        long Lvalue = Integer.toUnsignedLong(left) + Integer.toUnsignedLong(right);
                        int value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ value) & (right ^ value)) < 0;
                        pc += 2;
                        continue block137;
                    }
                    case 25: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        REGS[Rd] = value = left | right;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 26: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        long svalue = (long)left * (long)right;
                        REGS[Rd] = value = left * right;
                        n = value < 0;
                        z = value == 0;
                        c |= (long)value != svalue;
                        v = false;
                        pc += 2;
                        continue block137;
                    }
                    case 27: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        REGS[Rd] = value = left & ~right;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 28: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int right = REGS[Rs];
                        REGS[Rd] = value = ~right;
                        n = value < 0;
                        z = value == 0;
                        pc += 2;
                        continue block137;
                    }
                    case 29: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        REGS[Rd] = value = left + right;
                        pc += 2;
                        continue block137;
                    }
                    case 30: {
                        int n6;
                        int n7;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        switch (Rd) {
                            case 13: {
                                n7 = sp;
                                break;
                            }
                            case 14: {
                                n7 = lr;
                                break;
                            }
                            case 15: {
                                n7 = pc;
                                break;
                            }
                            default: {
                                n7 = REGS[Rd];
                            }
                        }
                        int left = n7;
                        switch (Rs) {
                            case 13: {
                                n6 = sp;
                                break;
                            }
                            case 14: {
                                n6 = lr;
                                break;
                            }
                            case 15: {
                                n6 = pc + 4;
                                break;
                            }
                            default: {
                                n6 = REGS[Rs];
                            }
                        }
                        int right = n6;
                        int value = left + right;
                        switch (Rd) {
                            case 13: {
                                sp = value;
                                pc += 2;
                                continue block137;
                            }
                            case 14: {
                                lr = value;
                                pc += 2;
                                continue block137;
                            }
                            case 15: {
                                pc = value;
                                pc += 2;
                                continue block137;
                            }
                        }
                        REGS[Rd] = value;
                        pc += 2;
                        continue block137;
                    }
                    case 31: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int left = REGS[Rd];
                        int right = REGS[Rs];
                        long Lvalue = Integer.toUnsignedLong(left) + Integer.toUnsignedLong(~right) + 1L;
                        int value = (int)Lvalue;
                        n = value < 0;
                        z = value == 0;
                        c = Lvalue > 0xFFFFFFFFL;
                        v = ((left ^ right) & (left ^ value)) < 0;
                        pc += 2;
                        continue block137;
                    }
                    case 32: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        REGS[Rd] = REGS[Rs];
                        pc += 2;
                        continue block137;
                    }
                    case 33: {
                        int n8;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        switch (Rs) {
                            case 13: {
                                n8 = sp;
                                break;
                            }
                            case 14: {
                                n8 = lr;
                                break;
                            }
                            case 15: {
                                n8 = pc;
                                break;
                            }
                            default: {
                                n8 = REGS[Rs];
                            }
                        }
                        int value = n8;
                        switch (Rd) {
                            case 13: {
                                sp = value;
                                pc += 2;
                                continue block137;
                            }
                            case 14: {
                                lr = value;
                                pc += 2;
                                continue block137;
                            }
                            case 15: {
                                pc = value;
                                continue block137;
                            }
                        }
                        REGS[Rd] = value;
                        pc += 2;
                        continue block137;
                    }
                    case 34: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        switch (Rs) {
                            case 13: {
                                int n9 = sp;
                                break;
                            }
                            case 14: {
                                int n9 = lr;
                                break;
                            }
                            case 15: {
                                int n9 = pc;
                                break;
                            }
                            default: {
                                int n9 = value = REGS[Rs];
                            }
                        }
                        if ((value & 1) != 1) {
                            throw (Throwable)new UnknownInstructionException();
                        }
                        if (Rd != 0) {
                            throw (Throwable)new UnknownInstructionException();
                        }
                        pc = value & ~1;
                        continue block137;
                    }
                    case 35: {
                        int value;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        switch (Rs) {
                            case 13: {
                                int n10 = sp;
                                break;
                            }
                            case 14: {
                                int n10 = lr;
                                break;
                            }
                            case 15: {
                                int n10 = pc;
                                break;
                            }
                            default: {
                                int n10 = value = REGS[Rs];
                            }
                        }
                        if ((value & 1) != 1) {
                            throw (Throwable)new UnknownInstructionException();
                        }
                        if (Rd != 0) {
                            throw (Throwable)new UnknownInstructionException();
                        }
                        lr = pc + 2 | 1;
                        pc = value & ~1;
                        continue block137;
                    }
                    case 36: {
                        int Rd = code >> 8 & 0xF;
                        void imm32 = buffer[pc - base + 1];
                        REGS[Rd] = imm32;
                        pc += 2;
                        continue block137;
                    }
                    case 37: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int addr = REGS[Rs] + REGS[Rn];
                        int value = REGS[Rd];
                        memory.writeInt(addr, value);
                        pc += 2;
                        continue block137;
                    }
                    case 38: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int addr = REGS[Rs] + REGS[Rn];
                        int value = REGS[Rd];
                        memory.writeByte(addr, (byte)value);
                        pc += 2;
                        continue block137;
                    }
                    case 39: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int addr = REGS[Rs] + REGS[Rn];
                        REGS[Rd] = memory.readInt(addr);
                        pc += 2;
                        continue block137;
                    }
                    case 40: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int addr = REGS[Rs] + REGS[Rn];
                        REGS[Rd] = memory.readByte(addr) & 0xFF;
                        pc += 2;
                        continue block137;
                    }
                    case 41: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int addr = REGS[Rs] + REGS[Rn];
                        memory.writeShort(addr, (short)REGS[Rd]);
                        pc += 2;
                        continue block137;
                    }
                    case 42: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int addr = REGS[Rs] + REGS[Rn];
                        REGS[Rd] = memory.readShort(addr) & 0xFFFF;
                        pc += 2;
                        continue block137;
                    }
                    case 43: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int addr = REGS[Rs] + REGS[Rn];
                        REGS[Rd] = memory.readByte(addr);
                        pc += 2;
                        continue block137;
                    }
                    case 44: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int Rn = code >> 16 & 0xF;
                        int addr = REGS[Rs] + REGS[Rn];
                        REGS[Rd] = memory.readShort(addr);
                        pc += 2;
                        continue block137;
                    }
                    case 45: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int addr = REGS[Rs] + imm16;
                        int value = REGS[Rd];
                        memory.writeInt(addr, value);
                        pc += 2;
                        continue block137;
                    }
                    case 46: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int addr = REGS[Rs] + imm16;
                        int value = REGS[Rd];
                        memory.writeByte(addr, (byte)value);
                        pc += 2;
                        continue block137;
                    }
                    case 47: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int addr = REGS[Rs] + imm16;
                        REGS[Rd] = memory.readInt(addr);
                        pc += 2;
                        continue block137;
                    }
                    case 48: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int addr = REGS[Rs] + imm16;
                        REGS[Rd] = memory.readByte(addr) & 0xFF;
                        pc += 2;
                        continue block137;
                    }
                    case 49: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int addr = REGS[Rs] + imm16;
                        memory.writeShort(addr, (short)REGS[Rd]);
                        pc += 2;
                        continue block137;
                    }
                    case 50: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm16 = code >> 16;
                        int addr = REGS[Rs] + imm16;
                        REGS[Rd] = memory.readShort(addr) & 0xFFFF;
                        pc += 2;
                        continue block137;
                    }
                    case 51: {
                        int Rd = code >> 8 & 0xF;
                        void imm16 = code >> 16;
                        int addr = sp + imm16;
                        int value = REGS[Rd];
                        memory.writeInt(addr, value);
                        pc += 2;
                        continue block137;
                    }
                    case 52: {
                        int Rd = code >> 8 & 0xF;
                        void imm16 = code >> 16;
                        int addr = sp + imm16;
                        REGS[Rd] = memory.readInt(addr);
                        pc += 2;
                        continue block137;
                    }
                    case 53: {
                        int n11;
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        void imm162 = code >> 16;
                        switch (Rs) {
                            case 13: {
                                n11 = sp;
                                break;
                            }
                            case 15: {
                                n11 = pc + 4 & ~2;
                                break;
                            }
                            default: {
                                throw (Throwable)new UnknownInstructionException();
                            }
                        }
                        int value = n11;
                        REGS[Rd] = value + imm162;
                        pc += 2;
                        continue block137;
                    }
                    case 54: {
                        void imm16 = code >> 16;
                        sp += imm16;
                        pc += 2;
                        continue block137;
                    }
                    case 55: {
                        int i;
                        void imm16 = code >> 16;
                        int Rs = 7;
                        boolean imm162 = false;
                        while (Rs >= 0) {
                            if ((imm16 & 1 << i) != 0) {
                                memory.writeInt(sp -= 4, REGS[i]);
                            }
                            --i;
                        }
                        pc += 2;
                        continue block137;
                    }
                    case 56: {
                        int i;
                        void imm16 = code >> 16;
                        memory.writeInt(sp -= 4, lr);
                        boolean imm162 = false;
                        for (i = 7; i >= 0; --i) {
                            if ((imm16 & 1 << i) == 0) continue;
                            memory.writeInt(sp -= 4, REGS[i]);
                        }
                        pc += 2;
                        continue block137;
                    }
                    case 57: {
                        int i;
                        void imm16 = code >> 16;
                        int imm162 = 7;
                        for (i = 0; i <= imm162; ++i) {
                            if ((imm16 & 1 << i) == 0) continue;
                            REGS[i] = memory.readInt(sp);
                            sp += 4;
                        }
                        pc += 2;
                        continue block137;
                    }
                    case 58: {
                        int i;
                        void imm16 = code >> 16;
                        int imm162 = 7;
                        for (i = 0; i <= imm162; ++i) {
                            if ((imm16 & 1 << i) == 0) continue;
                            REGS[i] = memory.readInt(sp);
                            sp += 4;
                        }
                        int value = memory.readInt(sp);
                        if ((value & 1) != 1) {
                            throw (Throwable)new InvalidAddressArmException();
                        }
                        pc = value & ~1;
                        sp += 4;
                        continue block137;
                    }
                    case 59: {
                        int Rd = code >> 8 & 0xF;
                        void imm16 = code >> 16;
                        int addr = REGS[Rd];
                        int value = 0;
                        int n12 = 7;
                        while (value <= n12) {
                            void i;
                            if ((imm16 & 1 << i) != 0) {
                                memory.writeInt(addr, REGS[i]);
                                addr += 4;
                            }
                            ++i;
                        }
                        REGS[Rd] = addr;
                        pc += 2;
                        continue block137;
                    }
                    case 60: {
                        int Rd = code >> 8 & 0xF;
                        void imm16 = code >> 16;
                        int addr = REGS[Rd];
                        int n13 = 7;
                        for (int i = 0; i <= n13; ++i) {
                            if ((imm16 & 1 << i) == 0) continue;
                            REGS[i] = memory.readInt(addr);
                            addr += 4;
                        }
                        REGS[Rd] = addr;
                        pc += 2;
                        continue block137;
                    }
                    case 61: {
                        pc += z ? code >> 16 : 2;
                        continue block137;
                    }
                    case 62: {
                        pc += !z ? code >> 16 : 2;
                        continue block137;
                    }
                    case 63: {
                        pc += c ? code >> 16 : 2;
                        continue block137;
                    }
                    case 64: {
                        pc += !c ? code >> 16 : 2;
                        continue block137;
                    }
                    case 65: {
                        pc += n ? code >> 16 : 2;
                        continue block137;
                    }
                    case 66: {
                        pc += !n ? code >> 16 : 2;
                        continue block137;
                    }
                    case 67: {
                        pc += v ? code >> 16 : 2;
                        continue block137;
                    }
                    case 68: {
                        pc += !v ? code >> 16 : 2;
                        continue block137;
                    }
                    case 69: {
                        pc += c && !z ? code >> 16 : 2;
                        continue block137;
                    }
                    case 70: {
                        pc += !c || z ? code >> 16 : 2;
                        continue block137;
                    }
                    case 71: {
                        pc += n == v ? code >> 16 : 2;
                        continue block137;
                    }
                    case 72: {
                        pc += n != v ? code >> 16 : 2;
                        continue block137;
                    }
                    case 73: {
                        pc += !z && n == v ? code >> 16 : 2;
                        continue block137;
                    }
                    case 74: {
                        pc += z || n != v ? code >> 16 : 2;
                        continue block137;
                    }
                    case 75: {
                        void imm16 = code >> 16;
                        this.regs.setCPSR(v, c, z, n);
                        this.regs.fastStore(REGS, sp, lr, pc);
                        this.totalInsnCount += (long)(insnCount - count);
                        try {
                            handler.invoke((Object)((int)imm16));
                        }
                        catch (ControlPauseSignal e) {
                            throw (Throwable)e;
                        }
                        catch (ControlStopSignal e) {
                            Registers registers = this.regs;
                            registers.set(15, registers.get(15) + 2);
                            throw (Throwable)e;
                        }
                        finally {
                            this.totalInsnCount -= (long)(insnCount - count);
                            sp = this.regs.getSp();
                            lr = this.regs.getLr();
                            pc = this.regs.getPc();
                            REGS = this.regs.fastLoad();
                            v = this.regs.getV();
                            c = this.regs.getC();
                            z = this.regs.getZ();
                            n = this.regs.getN();
                        }
                        pc += 2;
                        continue block137;
                    }
                    case 76: {
                        void imm16 = code >> 16;
                        pc += imm16;
                        continue block137;
                    }
                    case 77: {
                        void imm32 = buffer[pc - base + 1];
                        lr = pc + 3 + 2;
                        pc += imm32 + 2;
                        continue block137;
                    }
                    case 78: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        REGS[Rd] = (short)REGS[Rs];
                        pc += 2;
                        continue block137;
                    }
                    case 79: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        REGS[Rd] = (byte)REGS[Rs];
                        pc += 2;
                        continue block137;
                    }
                    case 80: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        REGS[Rd] = REGS[Rs] & 0xFFFF;
                        pc += 2;
                        continue block137;
                    }
                    case 81: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        REGS[Rd] = REGS[Rs] & 0xFF;
                        pc += 2;
                        continue block137;
                    }
                    case 82: {
                        int Rd = code >> 8 & 0xF;
                        int Rs = code >> 12 & 0xF;
                        int value = REGS[Rs];
                        REGS[Rd] = value >>> 24 & 0xFF | (value >>> 16 & 0xFF) << 8 | (value >>> 8 & 0xFF) << 16 | (value & 0xFF) << 24;
                        pc += 2;
                        continue block137;
                    }
                }
                new UnexceptedLogicError();
            }
        }
        finally {
            this.regs.setCPSR(v, c, z, n);
            this.regs.fastStore(REGS, sp, lr, pc);
            this.totalInsnCount += (long)(insnCount - count);
        }
    }

    @NotNull
    public final Memory getMemory() {
        return this.memory;
    }

    @NotNull
    public final Registers getRegs() {
        return this.regs;
    }

    public CPU(@NotNull Memory memory, @NotNull Registers regs) {
        Intrinsics.checkParameterIsNotNull((Object)memory, (String)"memory");
        Intrinsics.checkParameterIsNotNull((Object)regs, (String)"regs");
        this.memory = memory;
        this.regs = regs;
    }

    public /* synthetic */ CPU(Memory memory, Registers registers, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            memory = new Memory(null, 1, null);
        }
        if ((n & 2) != 0) {
            registers = new Registers();
        }
        this(memory, registers);
    }

    public CPU() {
        this(null, null, 3, null);
    }
}

