/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.blocks;

import javax.annotation.Nonnull;
import li.cil.oc.common.block.property.PropertyRotatable;
import li.cil.oc.common.block.property.PropertyTile;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pcl.openprinter.tileentity.IOrientable;

public interface IOrientableBlock {
    @Nonnull
    public static ExtendedBlockState createBlockState(Block block) {
        return new ExtendedBlockState(block, new IProperty[]{PropertyRotatable.Pitch(), PropertyRotatable.Yaw()}, new IUnlistedProperty[]{PropertyTile.Tile()});
    }

    @Nonnull
    public static IBlockState getStateForPlacement(IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, @Nonnull EntityLivingBase placer) {
        EnumFacing yaw = IOrientableBlock.getYawForPlacement(placer, pos, facing);
        EnumFacing pitch = IOrientableBlock.getPitchForPlacement(placer, pos, facing);
        state = state.func_177226_a((IProperty)PropertyRotatable.Pitch(), (Comparable)pitch);
        state = state.func_177226_a((IProperty)PropertyRotatable.Yaw(), (Comparable)yaw);
        return state;
    }

    public static int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)PropertyRotatable.Pitch())).ordinal() << 2 | ((EnumFacing)state.func_177229_b((IProperty)PropertyRotatable.Yaw())).func_176736_b();
    }

    @Deprecated
    @Nonnull
    public static IBlockState getStateFromMeta(IBlockState state, int meta) {
        return state.func_177226_a((IProperty)PropertyRotatable.Pitch(), (Comparable)EnumFacing.func_82600_a((int)(meta >> 2))).func_177226_a((IProperty)PropertyRotatable.Yaw(), (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    @Nonnull
    public static IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (state instanceof IExtendedBlockState && tile instanceof IOrientable) {
            IOrientable tileOrientable = (IOrientable)tile;
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)PropertyTile.Tile(), (Object)tile).func_177226_a((IProperty)PropertyRotatable.Pitch(), (Comparable)tileOrientable.pitch()).func_177226_a((IProperty)PropertyRotatable.Yaw(), (Comparable)tileOrientable.yaw());
        }
        return state;
    }

    public static EnumFacing getYawForPlacement(EntityLivingBase entity, BlockPos blockPos, EnumFacing faceHit) {
        EnumFacing yaw = EnumFacing.func_190914_a((BlockPos)blockPos, (EntityLivingBase)entity);
        if (!faceHit.func_176740_k().equals((Object)EnumFacing.Axis.Y)) {
            yaw = faceHit;
        }
        if (yaw.func_176740_k().equals((Object)EnumFacing.Axis.Y)) {
            yaw = EnumFacing.func_176733_a((double)entity.field_70177_z).func_176734_d();
        }
        return yaw;
    }

    public static EnumFacing getPitchForPlacement(EntityLivingBase entity, BlockPos blockPos, EnumFacing faceHit) {
        EnumFacing pitch = EnumFacing.func_190914_a((BlockPos)blockPos, (EntityLivingBase)entity);
        return pitch.func_176740_k().equals((Object)EnumFacing.Axis.Y) ? pitch : EnumFacing.NORTH;
    }
}

