/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import pcl.openprinter.gui.PaperGUI;
import pcl.openprinter.inventory.FolderInventory;

public class GuiFolderView
extends GuiScreen {
    private int pageCount = 0;
    private int currPage = 0;
    final int xSizeOfTexture = 200;
    final int ySizeOfTexture = 230;
    private String name = "Folder";
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    public static final ResourceLocation folderView = new ResourceLocation("openprinter", "textures/gui/folder_view.png");
    public static final ResourceLocation folderViewEmpty = new ResourceLocation("openprinter", "textures/gui/folder_view_empty.png");
    FolderInventory inventory;

    public boolean func_73868_f() {
        return false;
    }

    public GuiFolderView(World world, EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        this.inventory = new FolderInventory(stack);
        this.pageCount = 0;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            if (this.inventory.getStackInSlot(slot).func_190926_b()) continue;
            ++this.pageCount;
        }
        if (stack.func_82837_s()) {
            this.name = stack.func_82833_r();
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int posX = (this.field_146294_l - 200) / 2;
        int posY = (this.field_146295_m - 230) / 2;
        this.buttonNextPage = new NextPageButton(1, posX + 120, posY + 217, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, posX + 38, posY + 217, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void func_73863_a(int i, int j, float f) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.pageCount > 0 ? folderView : folderViewEmpty);
        int posX = (this.field_146294_l - 200) / 2;
        int posY = (this.field_146295_m - 230) / 2;
        this.func_73729_b(posX, posY, 0, 0, 200, 230);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.field_146294_l / 2 + 92), (double)(this.field_146295_m / 2 - 106), (double)0.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        this.field_146297_k.field_71466_p.func_78276_b(PaperGUI.limit(this.name, 14), 0, 0, 0);
        GL11.glPopMatrix();
        if (this.pageCount == 0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.field_146294_l / 2 + 12), (double)(this.field_146295_m / 2 - 114), (double)0.0);
        GL11.glScaled((double)0.9, (double)0.9, (double)0.0);
        this.field_146297_k.field_71466_p.func_78276_b("Page " + (this.currPage + 1) + " of " + this.pageCount, 0, 0, 0);
        GL11.glPopMatrix();
        this.updateButtons();
        if (this.inventory.getStackInSlot(this.currPage).func_77942_o()) {
            NBTTagCompound pageNBT = this.inventory.getStackInSlot(this.currPage).func_77978_p();
            PaperGUI.drawPrintedPage(pageNBT, this.field_146294_l, this.field_146295_m, posX + 16, posY + 16);
        }
        super.func_73863_a(i, j, f);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1 && this.currPage < this.pageCount) {
            ++this.currPage;
        }
        if (button.field_146127_k == 2 && this.currPage - 1 >= 0) {
            --this.currPage;
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currPage < this.pageCount - 1;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean show;
        private int x;
        private int y;

        public NextPageButton(int id, int x, int y, boolean enabled) {
            super(id, x, y, 23, 13, "");
            this.show = enabled;
            this.x = x;
            this.y = y;
        }

        public void func_191745_a(Minecraft mc, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(folderView);
                int k = 10;
                int l = 233;
                if (this.show) {
                    k += 20;
                }
                if (!this.show) {
                    l += 13;
                }
                this.func_73729_b(this.x, this.y, k, l, 23, 13);
            }
        }
    }
}

