/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjaroslav.reflectors.v4;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class Reflectors {
    public static boolean enabledLogs;
    public static boolean obfuscated;
    public static final BiMap<String, String> METHODS;

    public static byte[] reflectClass(byte[] data, @NotNull String target, @NotNull String reflectorClass) {
        Reflectors.log("Trying reflect target class \"" + target + "\" with \"" + reflectorClass + "\" reflector class...");
        try {
            ClassNode classNode = Reflectors.readClassFromBytes(data);
            ClassNode reflectorClassNode = Reflectors.readClass(reflectorClass);
            for (MethodNode method : reflectorClassNode.methods) {
                if ((method.access & 8) != 8 || (method.access & 1) != 1) continue;
                Reflectors.log("Found method \"" + method.name + method.desc + "\" trying to replace in target class...");
                Reflectors.reflectMethod(classNode, reflectorClassNode, method);
            }
            Reflectors.log("Reflection done!");
            return Reflectors.writeClassToBytes(classNode, 3);
        }
        catch (Exception e) {
            Reflectors.log("Error while class reflecting:");
            e.printStackTrace();
            return data;
        }
    }

    public static void log(@Nullable Object message) {
        if (enabledLogs) {
            System.out.println("[Reflectors] " + message);
        }
    }

    @NotNull
    public static ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    @NotNull
    public static ClassNode readClass(@NotNull String clazz) throws IOException {
        ClassNode classNode = new ClassNode();
        InputStream is = Objects.requireNonNull(Reflectors.class.getResourceAsStream("/" + clazz.replace('.', '/') + ".class"));
        ClassReader classReader = new ClassReader(is);
        is.close();
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    @NotNull
    public static ClassNode readClass(@NotNull String clazz, @NotNull ClassLoader loader) throws IOException {
        ClassNode classNode = new ClassNode();
        InputStream is = Objects.requireNonNull(loader.getResourceAsStream("" + clazz.replace('.', '/') + ".class"));
        ClassReader classReader = new ClassReader(is);
        is.close();
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static byte[] writeClassToBytes(@NotNull ClassNode classNode, int flags) {
        ClassWriter writer = new ClassWriter(flags);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    @Nullable
    public static MethodNode findMethodNode(@NotNull ClassNode classNode, @NotNull String methodName, @NotNull String methodDesc) {
        for (MethodNode method : classNode.methods) {
            for (String unmappedName : Reflectors.unmapMethodAll(methodName)) {
                if (!method.name.equals(methodName) && !method.name.equals(unmappedName) || !method.desc.equals(methodDesc)) continue;
                return method;
            }
        }
        return null;
    }

    @NotNull
    public static String getMethodDescWithoutFirstArgument(@NotNull MethodNode method) {
        Type[] reflectorParams = Type.getArgumentTypes((String)method.desc);
        if (reflectorParams.length == 0) {
            return method.desc;
        }
        StringBuilder result = new StringBuilder("(");
        for (Type param : reflectorParams = Arrays.copyOfRange(reflectorParams, 1, reflectorParams.length)) {
            result.append(param.getDescriptor());
        }
        return result.append(")").append(Type.getReturnType((String)method.desc).getDescriptor()).toString();
    }

    @Nullable
    public static MethodNode findMethodNodeByReflector(@NotNull ClassNode classNode, @NotNull MethodNode reflector) {
        Type[] reflectorParams = Type.getArgumentTypes((String)reflector.desc);
        boolean flag = reflectorParams.length > 0 && classNode.name.equals(reflectorParams[0].getDescriptor());
        MethodNode result = Reflectors.findMethodNode(classNode, reflector.name, reflector.desc);
        if (result != null && (result.access & 8) == 8 && !flag) {
            return result;
        }
        result = Reflectors.findMethodNode(classNode, reflector.name, Reflectors.getMethodDescWithoutFirstArgument(reflector));
        if (result != null && (result.access & 8) == 0) {
            return result;
        }
        return null;
    }

    public static @UnknownNullability AbstractInsnNode findFirstInstruction(MethodNode method) {
        for (AbstractInsnNode instruction = method.instructions.getFirst(); instruction != null; instruction = instruction.getNext()) {
            if (instruction.getType() == 8 || instruction.getType() == 15) continue;
            return instruction;
        }
        return null;
    }

    public static void reflectMethod(@NotNull ClassNode classNode, @NotNull ClassNode reflectorClassNode, @NotNull MethodNode reflectorMethod) {
        MethodNode method = Reflectors.findMethodNodeByReflector(classNode, reflectorMethod);
        if (method == null) {
            Reflectors.log("Can't find target method!");
            return;
        }
        InsnList replaceData = new InsnList();
        boolean isStatic = (method.access & 8) == 8;
        Reflectors.loadMethodArguments(replaceData, Type.getArgumentTypes((String)method.desc), isStatic);
        replaceData.add((AbstractInsnNode)new MethodInsnNode(184, reflectorClassNode.name, reflectorMethod.name, reflectorMethod.desc, false));
        replaceData.add((AbstractInsnNode)new InsnNode(Reflectors.getReturnOpcodeFromType(Type.getReturnType((String)method.desc))));
        method.instructions.insertBefore(Reflectors.findFirstInstruction(method), replaceData);
        Reflectors.log("Method replaced");
    }

    public static void loadMethodArguments(@NotNull InsnList insnList, Type[] arguments, boolean isStatic) {
        if (!isStatic) {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        for (int i = 0; i < arguments.length; ++i) {
            insnList.add((AbstractInsnNode)new VarInsnNode(Reflectors.getLoadOpcodeForType(arguments[i]), i + (isStatic ? 0 : 1)));
        }
    }

    public static int getLoadOpcodeForType(Type type) {
        switch (type.getDescriptor()) {
            case "I": 
            case "S": 
            case "B": 
            case "Z": 
            case "C": {
                return 21;
            }
            case "J": {
                return 22;
            }
            case "D": {
                return 24;
            }
            case "F": {
                return 23;
            }
        }
        return 25;
    }

    public static int getReturnOpcodeFromType(Type type) {
        switch (type.getDescriptor()) {
            case "I": 
            case "S": 
            case "B": 
            case "C": 
            case "Z": {
                return 172;
            }
            case "J": {
                return 173;
            }
            case "D": {
                return 175;
            }
            case "F": {
                return 174;
            }
            case "V": {
                return 177;
            }
        }
        return 176;
    }

    public static void loadMappings(@NotNull BiMap<String, String> target, @NotNull String resource) {
        try {
            InputStream stream = Reflectors.class.getResourceAsStream(resource);
            if (stream == null) {
                Reflectors.log("Can't load mappings from \"" + resource + "\". Resource not found");
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = reader.readLine();
            while (line != null) {
                String[] splitted = line.split(",");
                String mapped = splitted[0];
                String unmapped = splitted[1];
                while (METHODS.containsKey((Object)unmapped)) {
                    unmapped = unmapped + "*";
                }
                target.put((Object)unmapped, (Object)mapped);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public static String unmapMethod(@NotNull String name) {
        return Reflectors.unmapMethodAll(name).get(0);
    }

    @NotNull
    public static List<String> unmapMethodAll(@NotNull String name) {
        if (!obfuscated) {
            return Collections.singletonList(name);
        }
        ArrayList<String> result = new ArrayList<String>();
        while (METHODS.containsKey((Object)name)) {
            result.add((String)METHODS.get((Object)name));
            name = name + "*";
        }
        if (result.isEmpty()) {
            result.add(name);
        }
        return result;
    }

    @NotNull
    public static String mapMethod(@NotNull String name) {
        return obfuscated ? ((String)METHODS.inverse().getOrDefault((Object)name, (Object)name)).replace('*', ' ') : name;
    }

    private Reflectors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        METHODS = HashBiMap.create();
        Reflectors.loadMappings(METHODS, "/methods.csv");
        Reflectors.loadMappings(METHODS, "/methods.txt");
    }

    public static abstract class FMLLoadingPluginAdapter {
        public abstract String[] getASMTransformerClass();

        public String getModContainerClass() {
            return null;
        }

        public String getSetupClass() {
            return null;
        }

        public void injectData(Map<String, Object> data) {
            obfuscated = (Boolean)data.get("runtimeDeobfuscationEnabled");
            if (obfuscated) {
                Reflectors.log("Obfuscated environment");
            }
        }

        public String getAccessTransformerClass() {
            return null;
        }
    }
}

