/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch;

import igentuman.galacticresearch.GalacticResearch;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.config.Config;
import org.apache.logging.log4j.Level;

@Config(modid="galacticresearch")
public class ModConfig {
    public static ResearchSystemSettings researchSystem = new ResearchSystemSettings();
    public static Machines machines = new Machines();
    public static Tweaks tweaks = new Tweaks();
    public static Locator locator = new Locator();
    public static HashMap<String, Integer> sizes = new HashMap();

    public static class Machines {
        @Config.Name(value="satellite_rocket_schematic_id")
        public int satellite_rocket_schematic_id = 9261;
        @Config.Name(value="asteroid_spawn_delay")
        @Config.Comment(value={"Delay before asteroids will start appearing in sky (game days)"})
        public int asteroid_spawn_delay = 15;
        @Config.Name(value="satellite_mission_duration")
        @Config.Comment(value={"How long it takes to unlock planets (seconds)"})
        public int satellite_mission_duration = 300;
        @Config.Name(value="mining_rocket_schematic_id")
        public int mining_rocket_schematic_id = 9262;
        @Config.Name(value="mining_speed")
        @Config.Comment(value={"Ticks to mine one block on asteroid"})
        public int mining_speed = 15;
        @Config.Name(value="mining_mission_minimal_resources")
        @Config.Comment(value={"In stacks"})
        public int mining_mission_minimal_resources = 10;
        @Config.Name(value="mining_mission_maximal_resources")
        @Config.Comment(value={"In stacks (max 50)"})
        public int mining_mission_maximal_resources = 30;
        @Config.Name(value="announce_asteroids")
        @Config.Comment(value={"Will post messages in global chat about new asteroids"})
        public boolean announce_asteroids = true;
        @Config.Name(value="mining_asteroids_popularity")
        @Config.Comment(value={"Bigger value means more often appearance of asteroids on sky"})
        public int mining_asteroids_popularity = 20;
        @Config.Name(value="mining_missions_limit")
        @Config.Comment(value={"Limit for pending missions at the same time", "Means if new asteroid will appear and there already 5 asteroids waiting, it will delete the oldest one", "Currently mined asteroids won't be deleted"})
        public int mining_missions_limit = 5;
        @Config.Name(value="mining_mission_success_rate")
        @Config.Comment(value={"Value range 0-100 (%)"})
        public int mining_mission_success_rate = 90;
        @Config.Name(value="mineable_resources")
        @Config.Comment(value={"Define minable resource and priority", "Format: I:\"modname:blockname\"=123"})
        public HashMap<String, Integer> mineable_resources = new HashMap<String, Integer>(){
            {
                this.put("minecraft:diamond_ore", 30);
                this.put("minecraft:gold_ore", 10);
                this.put("galacticraftcore:meteoric_iron_raw", 20);
                this.put("minecraft:emerald_ore", 5);
                this.put("galacticraftplanets:asteroids_block:4", 30);
                this.put("galacticraftplanets:asteroids_block:3", 10);
                this.put("galacticraftplanets:asteroids_block:5", 10);
                this.put("galacticraftplanets:mars:2", 20);
                this.put("galacticraftcore:basic_block_moon:2", 20);
                this.put("galacticraftcore:basic_block_moon:1", 10);
                this.put("galacticraftcore:basic_block_moon", 10);
                this.put("galacticraftcore:basic_block_moon:6", 20);
                this.put("galacticraftplanets:venus:10", 10);
                this.put("galacticraftplanets:asteroids_block:2", 1);
                this.put("galacticraftplanets:dense_ice", 1);
            }
        };
    }

    public static class Locator {
        @Config.Name(value="location_duration")
        @Config.Comment(value={"How long it takes to locate objects (ticks)"})
        public int location_duration = 240;
        @Config.Name(value="radius")
        @Config.Comment(value={"Locator will search objects in defined radius around offset coordinates"})
        public int radius = 1000;
        @Config.Name(value="locatable_objects")
        @Config.Comment(value={"list of objects possible to locate", "You can define custom structure name here, And maybe it will work :)"})
        public String[] locatable_objects = new String[]{"village", "boss_dungeon", "mansion", "monument", "temple", "ae2_meteorite", "ie_deposit"};

        public String[] getLocatableObjects() {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String l : this.locatable_objects) {
                if (l.equals("ae2_meteorite") && !GalacticResearch.hooks.AE2Loaded || l.equals("ie_deposit") && !GalacticResearch.hooks.IELoaded) continue;
                tmp.add(l);
            }
            return (String[])tmp.stream().toArray(String[]::new);
        }
    }

    public static class Tweaks {
        @Config.Name(value="hard_boss_fight")
        @Config.Comment(value={"More challenge - more fun"})
        public boolean hard_boss_fight = true;
    }

    public static class ResearchSystemSettings {
        @Config.Name(value="body_size")
        @Config.Comment(value={"All bodies have size of 16 by default", "You can personailze body size here, just type body name key and the size", "This only affects telescope"})
        public String[] body_size = new String[]{"venus,      20", "moon,       32", "mars,       20", "jupiter,    32", "saturn,     28", "enceladus,  18"};
        @Config.Name(value="research_moons_with_parent_planet")
        @Config.Comment(value={"If true, moons will be automatically researched when you research the parent planet"})
        public boolean research_moons_with_parent_planet = false;
        @Config.Name(value="default_researched_objects")
        @Config.Comment(value={"List of objects what are researched by default. You can check object names by running command /research objects", "You need to keep at least one planet for solar system, and one solar system, so when you research solar system there will be at least one planet to fly"})
        public String[] default_researched_objects = new String[]{"galaxy.milky_way", "overworld", "sol", "proxima_b", "tauceti_f", "centauri_b", "barnarda_c", "kepler22b", "tatooine", "crait", "aqua", "kepler62b", "kepler62c", "kepler62d", "kepler62e", "kepler62f", "kepler69b", "kepler69c", "kepler47b", "kepler47c", "jetraruta", "ketherth", "moswion", "qustroithea", "xovis", "brajutov", "oarilia", "speshani16", "struronides", "trars9"};
        @Config.Name(value="required_observation_time")
        @Config.Comment(value={"How long (seconds) you need to track and observe body in telescope to collect data "})
        public int required_observation_time = 40;
        @Config.Name(value="extraplanets_intergration")
        @Config.Comment(value={"Disable in case of conflicts"})
        public boolean extraplanets_intergration = true;
        @Config.Name(value="galaxy_space_integration")
        @Config.Comment(value={"Disable in case of conflicts"})
        public boolean galaxy_space_integration = true;

        protected void parseBodyLine(String line) {
            if (line.isEmpty()) {
                return;
            }
            String[] parts = line.split(",");
            String name = parts[0].trim();
            int size = Integer.parseInt(parts[1].trim());
            sizes.put(name, size);
        }

        public HashMap<String, Integer> getSizes() {
            if (sizes.size() == 0) {
                for (String line : this.body_size) {
                    try {
                        this.parseBodyLine(line);
                    }
                    catch (ArrayIndexOutOfBoundsException | NullPointerException er) {
                        GalacticResearch.instance.logger.log(Level.ERROR, er.getLocalizedMessage());
                    }
                }
            }
            return sizes;
        }
    }
}

