/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.client.gui;

import asmodeuscore.AsmodeusCore;
import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.network.IMessage;
import asmodeuscore.api.space.ICelestialRegistry;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.astronomy.gui.screen.GuiCustomTeleporting;
import asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.network.packet.ACPacketSimple;
import asmodeuscore.core.proxy.ClientProxy;
import asmodeuscore.core.utils.Utils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.client.capability.PlayerClientSpaceData;
import igentuman.galacticresearch.client.capability.SpaceClientCapabilityHandler;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class GRGuiCelestialSelectionGalaxySpace
extends NewGuiCelestialSelection {
    protected NewGuiCelestialSelection.EnumView viewState = NewGuiCelestialSelection.EnumView.GS;
    private String galaxy = GalacticraftCore.planetOverworld.getParentSolarSystem().getUnlocalizedParentGalaxyName();
    private List<String> galaxylist = new ArrayList<String>();
    private List<SolarSystem> starlist = new ArrayList<SolarSystem>();
    private boolean showStarList = false;
    private boolean showGalaxyList = false;
    private boolean enableNewTierSystem = AsmodeusConfig.enableNewTierSystem;
    private double isometx = AsmodeusConfig.enable2DGalaxyMap ? 0.0 : 55.0;
    private double isometz = 45.0;
    private double mindistance = 900.0;
    private int currenttier = 0;
    private int tierneed = -1;
    private double timer;
    private double traveltime;
    private boolean enableTraveltime = false;
    private int coef;
    private boolean canTravel = true;
    private int small_page = 0;
    private SpaceData.Engine_Type engine = SpaceData.Engine_Type.FUEL_ENGINE;
    public SpaceData data;
    private int fuelSet = 0;
    private int fuelRocketLevel = 0;
    protected static final int LIGHTBLUE = ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255);
    protected static final int YELLOW = ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0);
    public static ResourceLocation guiMain2 = new ResourceLocation("asmodeuscore", "textures/gui/celestialselection2.png");
    public static ResourceLocation guiImg = new ResourceLocation("asmodeuscore", "textures/gui/galaxymap_1.png");
    public static ResourceLocation vortexTexture = new ResourceLocation("asmodeuscore", "textures/gui/celestialbodies/vortex.png");
    private double xImgOffset = 0.0;
    private double yImgOffset = 0.0;
    private int scroll = 0;
    private int max_scroll = 8;
    private Vec3d nebula_color = new Vec3d(1.0, 1.0, 1.0);
    private int nebula_img = 0;
    private boolean isSecondPassenger;

    public GRGuiCelestialSelectionGalaxySpace(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations) {
        super(mapMode, possibleBodies, canCreateStations, null);
        int tier;
        this.currenttier = tier = 0;
        this.coef = AsmodeusConfig.speedTimeTravel - 1 + tier;
        if (this.engine != null) {
            switch (this.engine) {
                default: {
                    break;
                }
                case ION_ENGINE: {
                    this.coef += 4;
                    break;
                }
                case PLASMA_ENGINE: {
                    this.coef += 8;
                    break;
                }
                case SUBLIGHT_ENGINE: {
                    this.coef += 100;
                    break;
                }
                case BLACKHOLE_ENGINE: {
                    this.coef += 1000;
                }
            }
        }
        Random rand = new Random();
        this.nebula_img = rand.nextInt(2);
        this.nebula_color = new Vec3d((double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
    }

    public void func_73866_w_() {
        GuiCelestialSelection.BORDER_SIZE = this.field_146294_l / 65;
        GuiCelestialSelection.BORDER_EDGE_SIZE = GuiCelestialSelection.BORDER_SIZE / 4;
        this.refreshBodies();
    }

    public void func_73876_c() {
        ++this.ticksSinceMenuOpen;
        ++this.ticksTotal;
        if (this.ticksSinceMenuOpen < 20) {
            Mouse.setGrabbed((boolean)false);
        }
        if (this.selectedBody != null) {
            ++this.ticksSinceSelection;
        }
        if (this.selectedBody == null && this.ticksSinceUnselection >= 0) {
            ++this.ticksSinceUnselection;
        }
        if (!(this.renamingSpaceStation || this.selectedBody != null && this.isZoomed())) {
            Vector2f var10000;
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.leftKey)) {
                var10000 = this.translation;
                var10000.x += -2.0f;
                var10000 = this.translation;
                var10000.y += -2.0f;
                if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                    this.xImgOffset += -1.0;
                }
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.rightKey)) {
                var10000 = this.translation;
                var10000.x += 2.0f;
                var10000 = this.translation;
                var10000.y += 2.0f;
                if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                    this.xImgOffset += 1.0;
                }
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.upKey)) {
                var10000 = this.translation;
                var10000.x += 2.0f;
                var10000 = this.translation;
                var10000.y += -2.0f;
                if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                    this.yImgOffset += -1.0;
                }
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.downKey)) {
                var10000 = this.translation;
                var10000.x += -2.0f;
                var10000 = this.translation;
                var10000.y += 2.0f;
                if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                    this.yImgOffset += 1.0;
                }
            }
        }
        if (this.xImgOffset > 20.0) {
            this.xImgOffset = 20.0;
        }
        if (this.xImgOffset < -150.0) {
            this.xImgOffset = -150.0;
        }
        if (this.yImgOffset > 20.0) {
            this.yImgOffset = 20.0;
        }
        if (this.yImgOffset < -80.0) {
            this.yImgOffset = -80.0;
        }
    }

    private boolean isUnlocked(String name, PlayerClientSpaceData stats) {
        return stats.getUnlockedMissions().contains(name.toLowerCase()) || Arrays.asList(ModConfig.researchSystem.default_researched_objects).contains(name.toLowerCase());
    }

    private void refreshBodies() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.bodiesToRender.clear();
        this.galaxylist.clear();
        this.starlist.clear();
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        PlayerClientSpaceData stats = null;
        if (player != null) {
            stats = (PlayerClientSpaceData)playerBaseClient.getCapability(SpaceClientCapabilityHandler.PLAYER_SPACE_CLIENT_DATA, null);
        }
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            if (!this.galaxylist.contains(solarSystem.getUnlocalizedParentGalaxyName())) {
                this.galaxylist.add(solarSystem.getUnlocalizedParentGalaxyName());
            }
            if (!solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy) || !this.isUnlocked(solarSystem.getName(), stats)) continue;
            if (solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) {
                this.starlist.add(solarSystem);
            }
            this.bodiesToRender.add(solarSystem.getMainStar());
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (!planet.getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy) || !this.isUnlocked(planet.getName(), stats) || !this.isUnlocked(planet.getParentSolarSystem().getName(), stats)) continue;
            this.bodiesToRender.add(planet);
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (!moon.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy) || !this.isUnlocked(moon.getName(), stats) || !this.isUnlocked(moon.getParentPlanet().getParentSolarSystem().getName(), stats)) continue;
            this.bodiesToRender.add(moon);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (!satellite.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            this.bodiesToRender.add(satellite);
        }
        for (Map bodies : BodiesRegistry.getBodies()) {
            for (CelestialBody body : bodies.values()) {
                if (!(body instanceof ICelestialRegistry)) continue;
                if (body instanceof IChildBody) {
                    if (!((IChildBody)body).getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy) || !((ICelestialRegistry)body).canRegistry()) continue;
                    this.bodiesToRender.add(body);
                    continue;
                }
                if (!((ICelestialRegistry)body).getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy) || !((ICelestialRegistry)body).canRegistry()) continue;
                this.bodiesToRender.add(body);
            }
        }
        Collections.sort(this.starlist, new Comparator<SolarSystem>(){

            @Override
            public int compare(SolarSystem lhs, SolarSystem rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
    }

    protected int drawChildren(List<CelestialBody> children, int xOffsetBase, int yOffsetPrior, boolean recursive) {
        xOffsetBase += GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        int yOffsetBase = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 50 + yOffsetPrior;
        int yOffset = 0;
        int size = children.size();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        PlayerClientSpaceData stats = null;
        if (player != null) {
            stats = (PlayerClientSpaceData)playerBaseClient.getCapability(SpaceClientCapabilityHandler.PLAYER_SPACE_CLIENT_DATA, null);
        }
        for (int i = 0; i < size; ++i) {
            List<CelestialBody> grandchildren;
            float brightness;
            CelestialBody child = children.get(i);
            int xOffset = xOffsetBase + (child.equals((Object)this.selectedBody) ? 5 : 0);
            int scale = (int)Math.min(95.0f, Math.max(0.0f, this.ticksSinceMenuOpenF * 25.0f - (float)(95 * i)));
            BodiesData data = BodiesRegistry.getData((CelestialBody)child);
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            float f = brightness = child.equals((Object)this.selectedBody) ? 0.2f : 0.0f;
            if (child.getReachable()) {
                if (child.equals((Object)this.selectedBody)) {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)((float)scale / 95.0f));
                } else {
                    GL11.glColor4f((float)0.0f, (float)(0.6f + brightness), (float)0.0f, (float)((float)scale / 95.0f));
                }
            } else {
                boolean checked = false;
                if (child instanceof Planet) {
                    for (Moon moon : GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)child))) {
                        if (!moon.getReachable()) continue;
                        checked = true;
                        break;
                    }
                }
                if (data != null && data.getType() == IAdvancedSpace.TypeBody.STAR) {
                    GL11.glColor4f((float)0.0f, (float)0.4f, (float)(0.6f + brightness), (float)((float)scale / 95.0f));
                } else if (child instanceof Planet && checked) {
                    GL11.glColor4f((float)(0.6f + brightness), (float)0.6f, (float)0.0f, (float)((float)scale / 95.0f));
                } else {
                    GL11.glColor4f((float)(0.6f + brightness), (float)0.0f, (float)0.0f, (float)((float)scale / 95.0f));
                }
            }
            this.drawTexturedModalRect(3 + xOffset, yOffsetBase + yOffset + 1, 86, 10, 0, 489, 86, 10, false, false);
            GL11.glColor4f((float)(3.0f * brightness), (float)(0.6f + 2.0f * brightness), (float)1.0f, (float)((float)scale / 95.0f));
            this.drawTexturedModalRect(2 + xOffset, yOffsetBase + yOffset, 93, 12, 95, 464, 93, 12, false, false);
            if (scale > 0) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int color = 0xE0E0E0;
                GlStateManager.func_179094_E();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(child.getBodyIcon());
                this.drawTexturedModalRect(xOffset + 7, yOffsetBase + yOffset + 2, 8.0f, 8.0f, 0.0f, 0.0f, 32.0f, 32.0f, false, false, 32.0f, 32.0f);
                GlStateManager.func_179121_F();
                this.field_146289_q.func_78276_b(child.getLocalizedName(), 17 + xOffset, yOffsetBase + yOffset + 2, color);
            }
            yOffset += 14;
            if (!recursive || !child.equals((Object)this.selectedBody) || (grandchildren = this.getChildren(child, 0, this.max_scroll)).size() <= 0) continue;
            if (this.animateGrandchildren == 14 * grandchildren.size()) {
                yOffset += this.drawChildren(grandchildren, 10, yOffset, false);
                continue;
            }
            if (this.animateGrandchildren >= 14) {
                LinkedList<CelestialBody> partial = new LinkedList<CelestialBody>();
                for (int j = 0; j < this.animateGrandchildren / 14; ++j) {
                    partial.add(grandchildren.get(j));
                }
                this.drawChildren(partial, 10, yOffset, false);
            }
            yOffset += this.animateGrandchildren;
            this.animateGrandchildren += 2;
        }
        if (ClientProxy.smallInfoOnMap && recursive) {
            boolean planetZoomedNotMoon;
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
            this.drawTexturedModalRect(BORDER_SIZE + 18, yOffsetBase + yOffset - 1, 62, 4, 280, 74, 62, 4, false, true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            boolean bl = planetZoomedNotMoon = this.isZoomed() && !(this.selectedParent instanceof Planet);
            if (this.scroll != 0) {
                this.drawTexturedModalRect(BORDER_SIZE + 47, yOffsetBase - 4, 7, 3, 344, 74, 7, 3, false, false);
            }
            if (this.scroll != this.getChildren(planetZoomedNotMoon ? this.selectedBody : this.selectedParent).size() - this.max_scroll) {
                this.drawTexturedModalRect(BORDER_SIZE + 47, yOffsetBase + yOffset, 7, 3, 344, 74, 7, 3, false, true);
            }
        }
        return yOffset;
    }

    protected List<CelestialBody> getChildren(Object object) {
        ArrayList bodyList = Lists.newArrayList();
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        PlayerClientSpaceData stats = null;
        if (player != null) {
            stats = (PlayerClientSpaceData)playerBaseClient.getCapability(SpaceClientCapabilityHandler.PLAYER_SPACE_CLIENT_DATA, null);
        }
        if (object instanceof Planet) {
            List moons = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
            for (Moon moon : moons) {
                if (!this.isUnlocked(moon.getName(), stats)) continue;
                bodyList.add(moon);
            }
        } else if (object instanceof SolarSystem) {
            List planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
            for (Planet planet : planets) {
                if (!this.isUnlocked(planet.getName(), stats)) continue;
                bodyList.add(planet);
            }
        }
        Collections.sort(bodyList);
        return bodyList;
    }

    public void func_73863_a(int mousePosX, int mousePosY, float partialTicks) {
        block16: {
            float wheel;
            this.ticksSinceMenuOpenF += partialTicks;
            this.ticksTotalF += partialTicks;
            if (this.selectedBody != null) {
                this.ticksSinceSelectionF += partialTicks;
            }
            if (this.selectedBody == null && this.ticksSinceUnselectionF >= 0.0f) {
                this.ticksSinceUnselectionF += partialTicks;
            }
            if (Mouse.hasWheel() && (wheel = (float)Mouse.getDWheel() / (this.selectedBody == null ? 500.0f : 250.0f)) != 0.0f) {
                if (mousePosX < 105 && ClientProxy.smallInfoOnMap) {
                    boolean planetZoomedNotMoon;
                    boolean bl = planetZoomedNotMoon = this.isZoomed() && !(this.selectedParent instanceof Planet);
                    if (wheel > 0.0f && this.scroll > 0) {
                        --this.scroll;
                    } else if (wheel < 0.0f && this.scroll < this.getChildren(planetZoomedNotMoon ? this.selectedBody : this.selectedParent).size() - this.max_scroll) {
                        ++this.scroll;
                    }
                } else if (this.selectedBody != null && this.isZoomed()) {
                    this.planetZoom = Math.min(Math.max(this.planetZoom + wheel, -4.9f), 5.0f);
                } else {
                    this.zoom = Math.min(Math.max(this.zoom + wheel * (this.zoom + 2.0f) / 10.0f, -1.095f), 3.0f);
                }
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            Matrix4f camMatrix = new Matrix4f();
            Matrix4f.translate((Vector3f)new Vector3f(0.0f, 0.0f, -9000.0f), (Matrix4f)camMatrix, (Matrix4f)camMatrix);
            Matrix4f viewMatrix = new Matrix4f();
            viewMatrix.m00 = 2.0f / (float)this.field_146294_l;
            viewMatrix.m11 = 2.0f / (float)(-this.field_146295_m);
            viewMatrix.m22 = -2.2222222E-4f;
            viewMatrix.m30 = -1.0f;
            viewMatrix.m31 = 1.0f;
            viewMatrix.m32 = -2.0f;
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
            fb.rewind();
            viewMatrix.store(fb);
            fb.flip();
            GL11.glMultMatrix((FloatBuffer)fb);
            fb.clear();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            fb.rewind();
            camMatrix.store(fb);
            fb.flip();
            fb.clear();
            GL11.glMultMatrix((FloatBuffer)fb);
            this.setBlackBackground();
            boolean drawGrid = true;
            if (AsmodeusConfig.enableImgOnGalaxyMap) {
                GL11.glPushMatrix();
                this.setImgBackground(guiImg);
                drawGrid = false;
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            Matrix4f worldMatrix = this.setIsometric(partialTicks);
            float gridSize = 14000.0f;
            if (drawGrid) {
                this.drawGrid(gridSize, (float)(this.field_146295_m / 3) / 3.5f);
            }
            if (this.selectedBody instanceof Star) {
                this.drawAgeCircle(worldMatrix);
            }
            this.drawCircles();
            this.drawVortex();
            GL11.glPopMatrix();
            HashMap<CelestialBody, Matrix4f> matrixMap = this.drawCelestialBodies(worldMatrix);
            this.planetPosMap.clear();
            for (Map.Entry<CelestialBody, Matrix4f> e : matrixMap.entrySet()) {
                Matrix4f planetMatrix = e.getValue();
                Matrix4f matrix0 = Matrix4f.mul((Matrix4f)viewMatrix, (Matrix4f)planetMatrix, (Matrix4f)planetMatrix);
                int x = (int)Math.floor(((double)matrix0.m30 * 0.5 + 0.5) * (double)Minecraft.func_71410_x().field_71443_c);
                int y = (int)Math.floor((double)Minecraft.func_71410_x().field_71440_d - ((double)matrix0.m31 * 0.5 + 0.5) * (double)Minecraft.func_71410_x().field_71440_d);
                Vector2f vec = new Vector2f((float)x, (float)y);
                Matrix4f scaleVec = new Matrix4f();
                scaleVec.m00 = matrix0.m00;
                scaleVec.m11 = matrix0.m11;
                scaleVec.m22 = matrix0.m22;
                Vector4f newVec = Matrix4f.transform((Matrix4f)scaleVec, (Vector4f)new Vector4f(2.0f, -2.0f, 0.0f, 0.0f), (Vector4f)null);
                float iconSize = newVec.y * ((float)Minecraft.func_71410_x().field_71440_d / 2.0f) * (float)(e.getKey() instanceof Star ? 2 : 1) * (e.getKey() == this.selectedBody ? 1.5f : 1.0f);
                this.planetPosMap.put(e.getKey(), new Vector3f(vec.x, vec.y, iconSize));
            }
            this.drawSelectionCursor(fb, worldMatrix);
            try {
                this.drawButtons(mousePosX, mousePosY);
            }
            catch (Exception var21) {
                if (this.errorLogged) break block16;
                this.errorLogged = true;
                GCLog.severe((String)"Problem identifying planet or dimension in an add on for Galacticraft!");
                GCLog.severe((String)"(The problem is likely caused by a dimension ID conflict.  Check configs for dimension clashes.  You can also try disabling Mars space station in configs.)");
                var21.printStackTrace();
            }
        }
        this.drawBorder();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    public void drawButtons(int mousePosX, int mousePosY) {
        super.drawButtons(mousePosX, mousePosY);
        int LHS = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        String str = EnumColor.DARK_RED + I18n.func_135052_a((String)"gui.celestial_selection.advise", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(str, LHS + 5, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE - 20, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
    }

    protected void drawSelectionCursor(FloatBuffer fb, Matrix4f worldMatrix) {
        GL11.glPushMatrix();
        switch (this.selectionState) {
            case SELECTED: {
                if (this.selectedBody == null) break;
                this.setupMatrix(this.selectedBody, worldMatrix, fb);
                fb.clear();
                GL11.glScalef((float)0.06666667f, (float)0.06666667f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                float div = this.getZoomAdvanced() < 4.9f ? (float)(Math.sin(this.ticksSinceSelectionF / 2.0f) * 0.5 + 0.5) : 1.0f;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)(1.0f * div));
                int width = (int)Math.floor((double)this.getWidthForCelestialBody(this.selectedBody) / 2.0 * (this.selectedBody instanceof IChildBody ? 9.0 : 30.0));
                this.drawTexturedModalRect(-width, -width, width * 2, width * 2, 266, 29, 100, 100, false, false);
                GL11.glPushMatrix();
                float colMod = this.selectedBody instanceof IChildBody ? 2.0f : 12.0f;
                GL11.glScalef((float)colMod, (float)colMod, (float)colMod);
                String name = this.selectedBody.getLocalizedName();
                int white = Utils.getIntColor((int)255, (int)255, (int)255, (int)255);
                int yellow = Utils.getIntColor((int)255, (int)255, (int)0, (int)255);
                this.func_73731_b(this.field_146289_q, name, 4 + this.getWidthForCelestialBody(this.selectedBody), -5, this.selectedBody instanceof Star ? yellow : white);
                GL11.glPopMatrix();
                break;
            }
            case ZOOMED: {
                if (this.selectedBody == null) break;
                this.setupMatrix(this.selectedBody, worldMatrix, fb);
                fb.clear();
                float div = this.zoom + 1.0f - this.planetZoom;
                float scale = Math.max(0.3f, 1.5f / (this.ticksSinceSelectionF / 5.0f)) * 2.0f / div;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                float colMod = this.getZoomAdvanced() < 4.9f ? (float)(Math.sin(this.ticksSinceSelectionF / 1.0f) * 0.5 + 0.5) : 1.0f;
                GL11.glColor4f((float)0.4f, (float)0.8f, (float)1.0f, (float)(1.0f * colMod));
                int width = this.getWidthForCelestialBody(this.selectedBody) * 13;
                this.drawTexturedModalRect(-width, -width, width * 2, width * 2, 266, 29, 100, 100, false, false);
            }
        }
        GL11.glPopMatrix();
    }

    public int getWidthForCelestialBody(CelestialBody celestialBody) {
        boolean zoomed = celestialBody == this.selectedBody && this.selectionState == GuiCelestialSelection.EnumSelection.SELECTED;
        float size = celestialBody.getRelativeSize();
        if ((double)size < 0.9 && celestialBody instanceof IChildBody) {
            size = 1.0f;
        }
        if (size > 5.0f) {
            size = 5.0f;
        }
        if (size < 0.3f) {
            size = 0.3f;
        }
        return (int)(celestialBody instanceof Star ? (zoomed ? 12.0f * size : 8.0f * size) : (celestialBody instanceof Planet ? (zoomed ? 6.0f * size : 4.0f * size) : (celestialBody instanceof IChildBody ? (zoomed ? 6.0f * size : 4.0f * size) : 2.0f)));
    }

    public HashMap<CelestialBody, Matrix4f> drawCelestialBodies(Matrix4f worldMatrix) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
        HashMap matrixMap = Maps.newHashMap();
        Iterator var4 = this.bodiesToRender.iterator();
        while (true) {
            int size;
            float alpha;
            boolean hasParent;
            CelestialBody body;
            if (!var4.hasNext()) {
                var4 = this.bodiesToRender.iterator();
                while (true) {
                    if (!var4.hasNext()) {
                        return matrixMap;
                    }
                    body = (CelestialBody)var4.next();
                    hasParent = body instanceof IChildBody;
                    alpha = this.getAlpha(body);
                    if (!(body instanceof Satellite && alpha > 0.0f) && (body instanceof Satellite || !(alpha >= 0.0f))) continue;
                    GlStateManager.func_179094_E();
                    this.setupMatrix(body, worldMatrix, fb, hasParent ? 0.25f : 1.0f);
                    if (this.selectionState == GuiCelestialSelection.EnumSelection.UNSELECTED && !hasParent || this.selectionState == GuiCelestialSelection.EnumSelection.ZOOMED && hasParent) {
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        String name = body.getLocalizedName();
                        size = Utils.getIntColor((int)255, (int)255, (int)255, (int)255);
                        int yellow = Utils.getIntColor((int)255, (int)255, (int)0, (int)255);
                        this.func_73731_b(this.field_146289_q, name, 4 + this.getWidthForCelestialBody(body), -5, body instanceof Star ? yellow : size);
                        if (ClientProxyCore.playerHead != null) {
                            if (this.selectionState == GuiCelestialSelection.EnumSelection.UNSELECTED && this.field_146297_k.field_71441_e.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody() instanceof IChildBody) {
                                if (body == ((IChildBody)((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody()).getParentPlanet()) {
                                    GlStateManager.func_179147_l();
                                    GlStateManager.func_179112_b((int)770, (int)771);
                                    GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                                    this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                                    this.func_73729_b(20 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                                }
                            } else if (this.field_146297_k.field_71441_e.field_73011_w instanceof IGalacticraftWorldProvider && body != GalacticraftCore.planetOverworld && ((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody() == body) {
                                GlStateManager.func_179147_l();
                                GlStateManager.func_179112_b((int)770, (int)771);
                                GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                                this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                                this.func_73729_b(20 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                            } else if (this.field_146297_k.field_71441_e.field_73011_w instanceof WorldProviderSurface && body == GalacticraftCore.planetOverworld) {
                                GlStateManager.func_179147_l();
                                GlStateManager.func_179112_b((int)770, (int)771);
                                GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                                this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                                this.func_73729_b(20 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                            }
                        }
                    }
                    GlStateManager.func_179121_F();
                }
            }
            body = (CelestialBody)var4.next();
            hasParent = body instanceof IChildBody;
            alpha = this.getAlpha(body);
            if (!(body instanceof Satellite && alpha > 0.0f) && (body instanceof Satellite || !(alpha >= 0.0f))) continue;
            GlStateManager.func_179094_E();
            Matrix4f worldMatrixLocal = this.setupMatrix(body, worldMatrix, fb, hasParent ? 0.25f : 1.0f);
            CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre(body, body.getBodyIcon(), 16);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (preEvent.celestialBodyTexture != null) {
                this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
            }
            if (!preEvent.isCanceled()) {
                size = this.getWidthForCelestialBody(body);
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                if (size % 2 != 0) {
                    xOffset = body.getRelativeSize() < 1.0f ? -0.5f : 0.0f;
                    yOffset = body.getRelativeSize() < 1.0f ? -0.5f : 0.0f;
                }
                BodiesData data = BodiesRegistry.getData((CelestialBody)body);
                if (body instanceof Star || data != null && data.getType() == IAdvancedSpace.TypeBody.STAR && data.getStarColor() != null) {
                    GL11.glPushMatrix();
                    GL11.glShadeModel((int)7425);
                    GL11.glDisable((int)3553);
                    GL11.glEnable((int)3008);
                    GL11.glAlphaFunc((int)516, (float)0.0f);
                    float r = 1.0f;
                    float g = 1.0f;
                    float b = 0.8f;
                    float a = 0.7f;
                    float f10 = size * 4;
                    if (data != null && data.getType() == IAdvancedSpace.TypeBody.STAR) {
                        if (data.getStarColor() != null) {
                            r = (float)data.getStarColor().getColor().func_177958_n() / 255.0f;
                            g = (float)data.getStarColor().getColor().func_177958_n() / 255.0f;
                            b = (float)data.getStarColor().getColor().func_177958_n() / 255.0f;
                            a = 0.7f;
                        }
                        if (data.getStarType() == IAdvancedSpace.StarType.BLACKHOLE) {
                            a = 0.0f;
                            b = 0.0f;
                            g = 0.0f;
                            r = 0.0f;
                        }
                    }
                    float xSize = 0.0f;
                    float ySize = 0.0f;
                    GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
                    GL11.glDisable((int)2884);
                    GL11.glBegin((int)6);
                    GL11.glVertex2d((double)(xSize /= 4.0f), (double)(ySize /= 4.0f));
                    for (int angle = 0; angle <= 360; angle += 60) {
                        if (angle % 120 == 0) {
                            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                        }
                        double x = (double)f10 * Math.cos((double)angle * Math.PI / 180.0);
                        double y = (double)f10 * Math.sin((double)angle * Math.PI / 180.0);
                        GL11.glVertex2d((double)(x + (double)xSize), (double)(y + (double)ySize));
                    }
                    GL11.glEnd();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3008);
                    GL11.glShadeModel((int)7424);
                    GL11.glPopMatrix();
                }
                this.drawTexturedModalRect(xOffset + (float)(-size / 2), yOffset + (float)(-size / 2), size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                matrixMap.put(body, worldMatrixLocal);
            }
            CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post(body);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
            GlStateManager.func_179121_F();
        }
    }

    protected Matrix4f setupMatrix(CelestialBody body, Matrix4f worldMatrix, FloatBuffer fb, float scaleXZ) {
        Matrix4f worldMatrix0 = new Matrix4f(worldMatrix);
        Matrix4f.translate((Vector3f)this.getCelestialBodyPosition(body), (Matrix4f)worldMatrix0, (Matrix4f)worldMatrix0);
        Matrix4f worldMatrix1 = new Matrix4f();
        Matrix4f.rotate((float)((float)Math.toRadians(this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        Matrix4f.rotate((float)((float)Math.toRadians(-this.isometx)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        if (scaleXZ != 1.0f) {
            Matrix4f.scale((Vector3f)new Vector3f(scaleXZ, scaleXZ, 1.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        }
        worldMatrix1 = Matrix4f.mul((Matrix4f)worldMatrix0, (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        fb.rewind();
        worldMatrix1.store(fb);
        fb.flip();
        GL11.glMultMatrix((FloatBuffer)fb);
        return worldMatrix1;
    }

    protected void func_146273_a(int x, int y, int lastButtonClicked, long timeSinceMouseClick) {
        if (this.mouseDragging && this.lastMovePosX != -1 && lastButtonClicked == 0) {
            int deltaX = x - this.lastMovePosX;
            int deltaY = y - this.lastMovePosY;
            float scollMultiplier = -Math.abs(this.zoom);
            if (this.zoom == -1.0f) {
                scollMultiplier = -10.5f;
            } else if (this.zoom >= -0.25f && this.zoom <= 0.15f) {
                scollMultiplier = -0.2f;
            }
            if (this.zoom >= 0.15f) {
                scollMultiplier = -0.25f;
            }
            Vector2f var10000 = this.translation;
            var10000.x = var10000.x + (float)(deltaX - deltaY) * scollMultiplier * (ConfigManagerCore.invertMapMouseScroll ? -1.0f : 1.0f) * ConfigManagerCore.mapMouseScrollSensitivity * 0.2f;
            var10000 = this.translation;
            var10000.y = var10000.y + (float)(deltaY + deltaX) * scollMultiplier * (ConfigManagerCore.invertMapMouseScroll ? -1.0f : 1.0f) * ConfigManagerCore.mapMouseScrollSensitivity * 0.2f;
            if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                this.xImgOffset += (double)((float)deltaX * (scollMultiplier / 4.0f));
                this.yImgOffset += (double)((float)deltaY * (scollMultiplier / 4.0f));
            }
        }
        this.lastMovePosX = x;
        this.lastMovePosY = y;
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.mouseDragging = false;
        this.lastMovePosX = -1;
        this.lastMovePosY = -1;
    }

    public void setImgBackground(ResourceLocation galaxy) {
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glTranslated((double)-40.0, (double)-40.0, (double)0.0);
        GL11.glTranslated((double)this.xImgOffset, (double)this.yImgOffset, (double)0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(galaxy);
        int width = Display.getWidth();
        int height = Display.getHeight();
        this.drawTexturedModalRect(0.0f, 0.0f, width, height, 0.0f, 0.0f, width * 2, height * 2, false, false, 1024.0f, 1024.0f);
        ResourceLocation guiImg_2 = new ResourceLocation("asmodeuscore", "textures/gui/galaxymap_nebula_" + this.nebula_img + ".png");
        this.field_146297_k.field_71446_o.func_110577_a(guiImg_2);
        GL11.glTranslated((double)(this.xImgOffset * 1.5), (double)(this.yImgOffset * 1.5), (double)0.0);
        GL11.glColor4f((float)0.5f, (float)0.4f, (float)((float)this.nebula_color.field_72449_c), (float)0.5f);
        this.drawTexturedModalRect(0.0f, 0.0f, width, height, 0.0f, 0.0f, 1024.0f, 1024.0f, false, false, 1024.0f, 1024.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public Matrix4f setIsometric(float partialTicks) {
        float zoomLocal;
        Matrix4f mat0 = new Matrix4f();
        Matrix4f.translate((Vector3f)new Vector3f((float)this.field_146294_l / 2.0f, (float)(this.field_146295_m / 2), 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        Matrix4f.rotate((float)((float)Math.toRadians(this.isometx)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        Matrix4f.rotate((float)((float)Math.toRadians(-this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        this.zoom = zoomLocal = this.getZoomAdvanced();
        Matrix4f.scale((Vector3f)new Vector3f(1.1f + zoomLocal, 1.1f + zoomLocal, 1.1f + zoomLocal), (Matrix4f)mat0, (Matrix4f)mat0);
        Vector2f cBodyPos = this.getTranslationAdvanced(partialTicks);
        this.position = this.getTranslationAdvanced(partialTicks);
        Matrix4f.translate((Vector3f)new Vector3f(-cBodyPos.x, -cBodyPos.y, 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)16);
        fb.rewind();
        mat0.store(fb);
        fb.flip();
        GL11.glMultMatrix((FloatBuffer)fb);
        return mat0;
    }

    public float getAlpha(CelestialBody body) {
        float alpha = 1.0f;
        if (body instanceof IChildBody) {
            boolean isPossible;
            boolean selected = body == this.selectedBody || ((IChildBody)body).getParentPlanet() == this.selectedBody && this.selectionState != GuiCelestialSelection.EnumSelection.SELECTED;
            boolean ready = this.lastSelectedBody != null || this.ticksSinceSelection > 35;
            boolean isSibling = this.getSiblings(this.selectedBody).contains(body);
            boolean bl = isPossible = !(body instanceof Satellite) || this.possibleBodies != null && this.possibleBodies.contains(body);
            if ((selected || isSibling) && isPossible) {
                if (!(!this.isZoomed() || selected && ready || isSibling)) {
                    alpha = Math.min(Math.max((float)(this.ticksSinceSelection - 30) / 15.0f, 0.0f), 1.0f);
                }
            } else {
                alpha = 0.0f;
            }
        } else {
            boolean isSibling;
            boolean selected = this.selectedBody == body;
            boolean ready = this.selectedBody instanceof IChildBody;
            boolean bl = isSibling = ready && ((IChildBody)this.selectedBody).getParentPlanet() == body;
            if (!selected && !isSibling && (this.isZoomed() || ready)) {
                alpha = this.lastSelectedBody == null && !(this.selectedBody instanceof IChildBody) ? 0.4f - Math.min((float)this.ticksSinceSelection / 25.0f, 0.4f) : 0.0f;
            }
        }
        return alpha;
    }

    public void drawCircles() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        int count = 0;
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        Iterator var5 = this.bodiesToRender.iterator();
        while (true) {
            if (!var5.hasNext()) {
                GL11.glLineWidth((float)1.0f);
                return;
            }
            CelestialBody body = (CelestialBody)var5.next();
            Vector3f systemOffset = new Vector3f(0.0f, 0.0f, 0.0f);
            if (body instanceof IChildBody) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((IChildBody)body).getParentPlanet());
            } else if (body instanceof Planet) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Planet)body).getParentSolarSystem().getMainStar());
            } else if (body instanceof Star) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
            } else if (body instanceof ICelestialRegistry && !(body instanceof IChildBody)) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((ICelestialRegistry)body).getParentSolarSystem().getMainStar());
            }
            float orbit_ext_x = body instanceof IExBody ? ((IExBody)body).getXOrbitEccentricity() : 1.0f;
            float orbit_ext_y = body instanceof IExBody ? ((IExBody)body).getYOrbitEccentricity() : 1.0f;
            float orbit_offset_x = body instanceof IExBody ? ((IExBody)body).getXOrbitOffset() : 0.0f;
            float orbit_offset_y = body instanceof IExBody ? ((IExBody)body).getYOrbitOffset() : 0.0f;
            float x = this.getScale(body);
            float y = 0.0f;
            float alpha = this.getAlpha(body);
            if (!(alpha > 0.0f)) continue;
            switch (count++ % 2) {
                case 0: {
                    GL11.glColor4f((float)0.0f, (float)0.2857143f, (float)0.64285713f, (float)(alpha / 1.4f));
                    break;
                }
                case 1: {
                    GL11.glColor4f((float)0.0f, (float)0.4f, (float)0.9f, (float)(alpha / 2.4f));
                }
            }
            if (body.equals((Object)this.selectedBody)) {
                GL11.glColor4f((float)0.0f, (float)0.4f, (float)0.9f, (float)1.0f);
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre(body, systemOffset);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            if (!preEvent.isCanceled()) {
                GL11.glTranslatef((float)systemOffset.x, (float)systemOffset.y, (float)systemOffset.z);
                GL11.glBegin((int)2);
                for (int i = 0; i < 90; ++i) {
                    GL11.glVertex2f((float)((x + orbit_offset_x) * (orbit_ext_x > 0.0f ? orbit_ext_x : 1.0f)), (float)((y + orbit_offset_y) * (orbit_ext_y > 0.0f ? orbit_ext_y : 1.0f)));
                    float temp = x;
                    x = cos * x - sin * y;
                    y = sin * temp + cos * y;
                }
                GL11.glEnd();
                GL11.glTranslatef((float)(-systemOffset.x), (float)(-systemOffset.y), (float)(-systemOffset.z));
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Post postEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post(body);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
        }
    }

    private void drawAgeCircle(Matrix4f worldMatrix) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        CelestialBody body = this.selectedBody;
        Vector3f systemOffset = new Vector3f(0.0f, 0.0f, 0.0f);
        if (body instanceof Star) {
            systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
        }
        float x = 1000.0f;
        float y = 0.0f;
        GL11.glTranslatef((float)systemOffset.x, (float)systemOffset.y, (float)systemOffset.z);
        for (int count_rings = 1; count_rings <= 8; ++count_rings) {
            x = 1000 * count_rings;
            GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.5f);
            GL11.glBegin((int)2);
            for (int i = 0; i < 90; ++i) {
                GL11.glVertex2f((float)(x * 1.0f), (float)(y * 1.0f));
                float temp = x;
                x = cos * x - sin * y;
                y = sin * temp + cos * y;
            }
            GL11.glEnd();
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b((int)(x / 1000.0f) * 5 + " l.y.", (int)x, (int)y, 0xFFFFFF);
            GL11.glDisable((int)3553);
            GlStateManager.func_179121_F();
        }
        GL11.glTranslatef((float)(-systemOffset.x), (float)(-systemOffset.y), (float)(-systemOffset.z));
        GL11.glLineWidth((float)1.0f);
    }

    private void drawVortex() {
        for (CelestialBody body : this.bodiesToRender) {
            GlStateManager.func_179094_E();
            new Vector3f(0.0f, 0.0f, 0.0f);
            BodiesData data = BodiesRegistry.getData((CelestialBody)body);
            if (body instanceof Star && data != null && data.getStarType() == IAdvancedSpace.StarType.BLACKHOLE) {
                Vector3f systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
                float size = (float)this.getWidthForCelestialBody(body) * 4.0f;
                float xOffset = systemOffset.x;
                float yOffset = systemOffset.y;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float n = size / 2.0f;
                GlStateManager.func_179109_b((float)(xOffset + -size / 2.0f + n), (float)(yOffset + -size / 2.0f + n), (float)0.0f);
                GlStateManager.func_179114_b((float)(this.ticksTotalF % 360.0f * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(-(xOffset + -size / 2.0f) - n), (float)(-(yOffset + -size / 2.0f) - n), (float)0.0f);
                this.field_146297_k.field_71446_o.func_110577_a(vortexTexture);
                this.drawTexturedModalRect(xOffset + -size / 2.0f, yOffset + -size / 2.0f, size, size, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
            }
            GlStateManager.func_179121_F();
        }
    }

    protected Vector3f getCelestialBodyPosition(CelestialBody cBody) {
        ICelestialRegistry body;
        if (cBody == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (cBody instanceof Star) {
            return cBody.getUnlocalizedName().equalsIgnoreCase("star.sol") ? new Vector3f() : ((Star)cBody).getParentSolarSystem().getMapPosition().toVector3f();
        }
        float timeScale = cBody instanceof Planet ? 200.0f : 2.0f;
        float orbit_ext_x = cBody instanceof IExBody ? ((IExBody)cBody).getXOrbitEccentricity() : 1.0f;
        float orbit_ext_y = cBody instanceof IExBody ? ((IExBody)cBody).getYOrbitEccentricity() : 1.0f;
        float orbit_offset_x = cBody instanceof IExBody ? ((IExBody)cBody).getXOrbitOffset() : 0.0f;
        float orbit_offset_y = cBody instanceof IExBody ? ((IExBody)cBody).getYOrbitOffset() : 0.0f;
        float distanceFromCenter = this.getScale(cBody);
        float x = (float)Math.sin(this.ticksTotalF / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter;
        float y = (float)Math.cos(this.ticksTotalF / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter;
        Vector3f cBodyPos = new Vector3f((x + orbit_offset_x) * (orbit_ext_x > 0.0f ? orbit_ext_x : 1.0f), (y + orbit_offset_y) * (orbit_ext_y > 0.0f ? orbit_ext_y : 1.0f), 0.0f);
        if (cBody instanceof Planet) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((Planet)cBody).getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, (Vector3f)null);
        }
        if (cBody instanceof IChildBody) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((IChildBody)cBody).getParentPlanet());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, (Vector3f)null);
        }
        if (cBody instanceof ICelestialRegistry && (body = (ICelestialRegistry)cBody).getParentSolarSystem() != null) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)body.getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, (Vector3f)null);
        }
        return cBodyPos;
    }

    protected float getScale(CelestialBody celestialBody) {
        float scale = 0.2f;
        if (celestialBody instanceof Planet) {
            scale = 25.0f;
        }
        if (celestialBody instanceof ICelestialRegistry && !((ICelestialRegistry)celestialBody instanceof IChildBody)) {
            scale = 25.0f;
        }
        return 3.0f * celestialBody.getRelativeDistanceFromCenter().unScaledDistance * scale;
    }

    protected void func_73869_a(char keyChar, int keyID) throws IOException {
        if (this.mapMode) {
            super.func_73869_a(keyChar, keyID);
        }
        if (keyID == 1 && !this.enableTraveltime && this.selectedBody != null) {
            this.unselectCelestialBody();
        }
        if (this.renamingSpaceStation) {
            if (keyID == 14) {
                if (this.renamingString != null && this.renamingString.length() > 0) {
                    String pastestring = this.renamingString.substring(0, this.renamingString.length() - 1);
                    this.renamingString = this.isValid(pastestring) ? pastestring : "";
                }
            } else if (keyChar == '\u0016') {
                String pastestring = GuiScreen.func_146277_j();
                if (pastestring == null) {
                    pastestring = "";
                }
                if (this.isValid(this.renamingString + pastestring)) {
                    this.renamingString = this.renamingString + pastestring;
                    this.renamingString = this.renamingString.substring(0, Math.min(String.valueOf(this.renamingString).length(), 32));
                }
            } else if (this.isValid(this.renamingString + keyChar)) {
                this.renamingString = this.renamingString + keyChar;
                this.renamingString = this.renamingString.substring(0, Math.min(this.renamingString.length(), 32));
            }
        } else if (keyID == 28 && !this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && this.currenttier >= this.tierneed && this.enableNewTierSystem) {
            if (this.canTravel) {
                this.enableTraveltime = true;
            } else {
                this.teleportToSelectedBody();
            }
        }
    }

    protected void teleportToSelectedBody() {
        if (this.selectedBody != null && this.selectedBody.getReachable()) {
            if (this.enableNewTierSystem ? this.currenttier < this.tierneed : this.possibleBodies == null || !this.possibleBodies.contains(this.selectedBody)) {
                return;
            }
            try {
                String dimension;
                int dimensionID;
                if (this.selectedBody instanceof Satellite) {
                    if (this.spaceStationMap == null) {
                        GCLog.severe((String)"Please report as a BUG: spaceStationIDs was null.");
                        return;
                    }
                    Satellite selectedSatellite = (Satellite)this.selectedBody;
                    Integer mapping = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(this.selectedStationOwner)).getStationDimensionID();
                    if (mapping == null) {
                        GCLog.severe((String)("Problem matching player name in space station check: " + this.selectedStationOwner));
                        return;
                    }
                    dimensionID = mapping;
                    WorldProvider spacestation = WorldUtil.getProviderForDimensionClient((int)dimensionID);
                    if (spacestation == null) {
                        GCLog.severe((String)("Failed to find a spacestation with dimension " + dimensionID));
                        return;
                    }
                    dimension = "Space Station " + mapping;
                } else {
                    dimensionID = this.selectedBody.getDimensionID();
                    dimension = WorldUtil.getDimensionName((WorldProvider)WorldUtil.getProviderForDimensionClient((int)dimensionID));
                }
                if (dimension.contains("$")) {
                    this.field_146297_k.field_71474_y.field_74320_O = 0;
                }
                AsmodeusCore.packetPipeline.sendToServer((IMessage)new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.S_TELEPORT_ENTITY, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{dimensionID, this.fuelSet}));
                this.field_146297_k.func_147108_a((GuiScreen)new GuiCustomTeleporting(dimensionID));
            }
            catch (Exception var6) {
                var6.printStackTrace();
            }
        }
    }

    protected void drawTransitBar(int length) {
        String str;
        int menuTopLeft = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 113, menuTopLeft + 15, 225, 67, 0, 0, 225, 67, false, false);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 50, menuTopLeft + 57, 0 + length, 10, 269, 0, 138, 10, false, false);
        if (!(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSurface) && this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            CelestialBody body = ((IGalacticraftWorldProvider)this.field_146297_k.field_71439_g.field_70170_p.field_73011_w).getCelestialBody();
            this.drawBodyOnGUI(body, this.field_146294_l / 2 - 76, menuTopLeft + 54, 16, 16);
            str = GCCoreUtil.translate((String)body.getUnlocalizedName());
        } else {
            this.drawBodyOnGUI((CelestialBody)GalacticraftCore.planetOverworld, this.field_146294_l / 2 - 76, menuTopLeft + 54, 16, 16);
            str = GCCoreUtil.translate((String)GalacticraftCore.planetOverworld.getUnlocalizedName());
        }
        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - 105, GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 35, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        this.drawBodyOnGUI(this.selectedBody, this.field_146294_l / 2 + 59, menuTopLeft + 54, 16, 16);
        str = GCCoreUtil.translate((String)this.selectedBody.getUnlocalizedName());
        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 + 50, GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 35, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        str = "Boost: x" + this.coef;
        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - (this.field_146289_q.func_78256_a(str) - 25), GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 48, ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255));
        double time = this.traveltime - this.timer;
        str = (int)(time / 100.0) + "h " + (int)(time % 59.0) + "m";
        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - (this.field_146289_q.func_78256_a(str) - 25), GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 59, ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255));
        if (this.timer >= this.traveltime) {
            this.teleportToSelectedBody();
            this.enableTraveltime = false;
        }
    }

    protected int getScaledTravelTime(int barLength) {
        double relative = this.timer / this.traveltime;
        return (int)(relative * (double)barLength);
    }

    protected void drawBodyOnGUI(CelestialBody body, int x, int y, int w, int h) {
        if (body != null) {
            this.field_146297_k.field_71446_o.func_110577_a(body.getBodyIcon());
            this.drawFullSizedTexturedRect(x, y, w, h);
        }
    }

    public void drawFullSizedTexturedRect(int x, int y, int width, int height) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    protected boolean canCreateSpaceStation(CelestialBody atBody) {
        if (!this.mapMode && !ConfigManagerCore.disableSpaceStationCreation && this.canCreateStations) {
            if (this.enableNewTierSystem ? this.currenttier < this.tierneed : this.possibleBodies != null && !this.possibleBodies.contains(atBody)) {
                return false;
            }
            boolean foundRecipe = false;
            for (SpaceStationType type : GalacticraftRegistry.getSpaceStationData()) {
                if (type.getWorldToOrbitID() != atBody.getDimensionID()) continue;
                foundRecipe = true;
            }
            if (!foundRecipe) {
                return false;
            }
            if (!ClientProxyCore.clientSpaceStationID.containsKey(atBody.getDimensionID())) {
                return true;
            }
            int resultID = (Integer)ClientProxyCore.clientSpaceStationID.get(atBody.getDimensionID());
            return resultID == 0 || resultID == -1;
        }
        return false;
    }

    protected List<CelestialBody> getChildren(Object object, int start, int size) {
        List bodies;
        List planets;
        ArrayList bodyList = Lists.newArrayList();
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        PlayerClientSpaceData stats = null;
        if (player != null) {
            stats = (PlayerClientSpaceData)playerBaseClient.getCapability(SpaceClientCapabilityHandler.PLAYER_SPACE_CLIENT_DATA, null);
        }
        SpaceData.refreshGalaxies();
        if (object instanceof Planet) {
            planets = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
            for (Moon moon : planets) {
                if (!this.isUnlocked(moon.getName(), stats)) continue;
                bodyList.add(moon);
            }
            bodies = SpaceData.getMoonsForPlanet((Planet)((Planet)object));
            for (CelestialBody body : bodies) {
                if (!(body instanceof ICelestialRegistry) || !(body instanceof IChildBody)) continue;
                bodyList.add(body);
            }
        } else if (object instanceof SolarSystem) {
            planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
            for (Planet planet : planets) {
                if (!this.isUnlocked(planet.getName(), stats)) continue;
                bodyList.add(planet);
            }
            bodies = SpaceData.getBodiesForSolarSystem((SolarSystem)((SolarSystem)object));
            for (CelestialBody body : bodies) {
                if (!(body instanceof ICelestialRegistry) || body instanceof IChildBody) continue;
                bodyList.add(body);
            }
        }
        Collections.sort(bodyList);
        if (!ClientProxy.smallInfoOnMap) {
            return bodyList;
        }
        ArrayList doneList = Lists.newArrayList();
        int startPos = start;
        int getSize = size;
        if (start >= bodyList.size()) {
            startPos = 0;
        }
        if (size >= bodyList.size()) {
            getSize = bodyList.size();
        }
        for (int i = 0; i < getSize; ++i) {
            doneList.add(i, bodyList.get(i + startPos));
        }
        return doneList;
    }

    protected static enum EnumView {
        PREVIEW,
        PROFILE,
        GS;

    }
}

