/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.client.gui.MCS;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.common.container.ContainerMissionControlStation;
import igentuman.galacticresearch.common.tile.TileMissionControlStation;
import igentuman.galacticresearch.network.GRPacketSimple;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiMissionControlStation
extends GuiContainerGC {
    private static final ResourceLocation guiTexture = new ResourceLocation("galacticresearch", "textures/gui/container/mission_control_station.png");
    private final TileMissionControlStation tile;
    private GuiButtonImage btnUp;
    private GuiButtonImage btnDown;
    private GuiButtonImage btnHelp;
    private GuiButtonImage btnLocator;
    private GuiButtonImage btnMissions;
    private GuiButton activateBtn;
    private GuiButton analyzeDataBtn;
    private GuiElementInfoRegion electricInfoRegion;
    private GuiElementInfoRegion helpRegion;

    public GuiMissionControlStation(InventoryPlayer par1InventoryPlayer, TileMissionControlStation tile) {
        super((Container)new ContainerMissionControlStation(par1InventoryPlayer, tile));
        this.electricInfoRegion = new GuiElementInfoRegion(this.field_147003_i + 30, this.field_147009_r + 167, 64, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.helpRegion = new GuiElementInfoRegion(this.field_147003_i + 154, this.field_147009_r + 164, 12, 12, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.tile = tile;
        this.field_147000_g = 201;
    }

    private void tickButtons() {
        if (this.field_146290_a != null && this.field_146290_a.func_146115_a()) {
            this.btnClick(this.field_146290_a);
            this.field_146290_a = null;
        }
        this.activateBtn.field_146124_l = this.tile.rocketState == 1 && !this.tile.currentMission.isEmpty();
    }

    protected void btnClick(GuiButton btn) {
        switch (btn.field_146127_k) {
            case 0: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.PREV_MISSION_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 1: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.NEXT_MISSION_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 3: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.ACTIVATE_MISSION_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 4: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.ANALYZE_DATA_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 5: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.OPEN_GUI_LOCATOR, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
        }
    }

    public void initButtons() {
        int xpos = this.field_147003_i + 7;
        int ypos = this.field_147009_r + 24;
        int size = 12;
        this.btnUp = new GuiButtonImage(0, xpos, ypos, size, size, 176, 83, 12, guiTexture);
        this.field_146292_n.add(this.btnUp);
        this.btnDown = new GuiButtonImage(1, xpos, ypos + 26, size, size, 176, 59, 12, guiTexture);
        this.field_146292_n.add(this.btnDown);
        this.btnHelp = new GuiButtonImage(2, xpos + 149, this.field_147009_r + 164, 13, 14, 176, 109, 0, guiTexture);
        this.field_146292_n.add(this.btnHelp);
        this.activateBtn = new GuiButton(3, (this.field_146294_l - this.field_146999_f) / 2 + 7, this.field_147009_r + 141, 90, 20, GCCoreUtil.translate((String)"gui.mission_control_station.activate"));
        this.field_146292_n.add(this.activateBtn);
        this.analyzeDataBtn = new GuiButton(4, (this.field_146294_l - this.field_146999_f) / 2 + 7, this.field_147009_r + 87, 161, 20, GCCoreUtil.translate((String)"gui.mission_control_station.analyze"));
        this.field_146292_n.add(this.analyzeDataBtn);
        this.btnLocator = new GuiButtonImage(5, this.field_147003_i + 74, this.field_147009_r - 7, 70, 16, 176, 124, 0, guiTexture);
        this.field_146292_n.add(this.btnLocator);
        this.btnMissions = new GuiButtonImage(6, this.field_147003_i + 4, this.field_147009_r - 7, 70, 16, 176, 140, 0, guiTexture);
        this.field_146292_n.add(this.btnMissions);
    }

    private void addHelpRegion() {
        ArrayList<String> help = new ArrayList<String>();
        help.add(GCCoreUtil.translate((String)"gui.help.mcs.desc.0"));
        help.add(GCCoreUtil.translate((String)"gui.help.mcs.desc.1"));
        help.add(GCCoreUtil.translate((String)"gui.help.mcs.desc.2"));
        if (GalaxyRegistry.getRegisteredSolarSystems().size() > 1) {
            help.add(GCCoreUtil.translate((String)"gui.help.mcs.desc.3"));
            help.add(GCCoreUtil.translate((String)"gui.help.mcs.desc.4"));
        }
        this.helpRegion.tooltipStrings = help;
        this.helpRegion.xPosition = this.field_147003_i + 156;
        this.helpRegion.yPosition = this.field_147009_r + 164;
        this.helpRegion.parentWidth = this.field_146294_l;
        this.helpRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.helpRegion);
    }

    private void addElectricInfoRegion() {
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.tile.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tile.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 32;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 165;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 9, (this.field_146295_m - this.field_147000_g) / 2 + 165, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElectricInfoRegion();
        this.addHelpRegion();
        this.initButtons();
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.mission_control_station"), 10, 10, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.mission_control_station.tab.missions"), 10, -3, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.mission_control_station.tab.locator"), 80, -3, 0x404040);
        String curMission = this.tile.currentMission;
        if (curMission.isEmpty()) {
            curMission = "none";
        }
        String status = this.tile.getMissionStatusKey(this.tile.currentMission);
        int info = this.tile.getMissionInfo(this.tile.currentMission);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.mission", (Object[])new Object[0]), 22, 25, 0x404040);
        String planet = I18n.func_135052_a((String)("planet." + curMission), (Object[])new Object[0]);
        if (planet.equals("planet." + curMission)) {
            planet = I18n.func_135052_a((String)("moon." + curMission), (Object[])new Object[0]);
        }
        if (planet.equals("moon." + curMission)) {
            planet = I18n.func_135052_a((String)("solarsystem." + curMission), (Object[])new Object[0]);
        }
        if (curMission.toUpperCase().contains("ASTEROID-")) {
            planet = curMission;
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)planet, (Object[])new Object[0]), 22, 39, 0x404040);
        String st = I18n.func_135052_a((String)status, (Object[])new Object[0]);
        if (this.tile.currentMission.isEmpty()) {
            st = "";
            info = -1;
        }
        if (info < ModConfig.machines.satellite_mission_duration * 20 && info > -1) {
            st = st + " " + this.tile.getMissonPercent(this.tile.currentMission) + "%";
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.mission_status", (Object[])new Object[]{st}), 22, 53, 0x404040);
        if (this.tile.getTelescope() == null) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.no_telescope", (Object[])new Object[0]), 7, 120, ColorUtil.to32BitColor((int)255, (int)255, (int)0, (int)0));
        }
        if (this.tile.rocketState == -1) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.no_rocket", (Object[])new Object[0]), 7, 130, 0x404040);
        } else if (this.tile.rocketState == 0) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.rocket_not_ready", (Object[])new Object[0]), 7, 130, ColorUtil.to32BitColor((int)255, (int)255, (int)0, (int)0));
        } else if (this.tile.rocketState == -2) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.wrong_rocket", (Object[])new Object[0]), 7, 130, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.rocket_ready", (Object[])new Object[0]), 7, 130, 0x404040);
        }
        this.tickButtons();
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6 + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(this.field_147003_i + 29, this.field_147009_r + 165, 176, 0, 11, 10);
        }
        this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 167, 187, 0, Math.min(this.tile.getScaledElecticalLevel(54), 54), 7);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
    }
}

