/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.client.gui.MCS;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.common.container.ContainerMissionControlStation;
import igentuman.galacticresearch.common.tile.TileMissionControlStation;
import igentuman.galacticresearch.network.GRPacketSimple;
import java.io.IOException;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementDropdown;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiMissionControlStationLocator
extends GuiContainerGC
implements GuiElementDropdown.IDropboxCallback,
GuiElementTextBox.ITextBoxCallback {
    private static final ResourceLocation guiTexture = new ResourceLocation("galacticresearch", "textures/gui/container/mission_control_station_locator.png");
    private final TileMissionControlStation tile;
    private GuiButtonImage btnHelp;
    private GuiButton locateBtn;
    private GuiElementTextBox xCord;
    private GuiElementTextBox yCord;
    private GuiButtonImage btnLocator;
    private GuiButtonImage btnMissions;
    private GuiElementDropdown locatableDropdown;
    private GuiElementDropdown stationsDropdown;
    private GuiElementDropdown locatorDataDropdown;
    private GuiElementInfoRegion electricInfoRegion;
    private GuiElementInfoRegion helpRegion;

    public GuiMissionControlStationLocator(InventoryPlayer par1InventoryPlayer, TileMissionControlStation tile) {
        super((Container)new ContainerMissionControlStation(par1InventoryPlayer, tile));
        this.electricInfoRegion = new GuiElementInfoRegion(this.field_147003_i + 30, this.field_147009_r + 167, 64, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.helpRegion = new GuiElementInfoRegion(this.field_147003_i + 154, this.field_147009_r + 164, 12, 12, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.tile = tile;
        this.field_147000_g = 201;
    }

    private int scale(double value, double maxValue) {
        return (int)(maxValue / 100.0 * value);
    }

    private void renderProgressBar() {
        int progress = this.tile.getLocatorProgress();
        this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 104, 0, 202, Math.min(this.scale(progress, 163.0), 163), 7);
    }

    private void tickButtons() {
        if (this.field_146290_a != null && this.field_146290_a.func_146115_a()) {
            this.btnClick(this.field_146290_a);
            this.field_146290_a = null;
        }
        this.locateBtn.field_146124_l = this.tile.locationCounter < 1;
    }

    protected void btnClick(GuiButton btn) {
        switch (btn.field_146127_k) {
            case 3: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.MCS_LOCATE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 6: {
                this.locatorDataDropdown.field_146124_l = false;
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.OPEN_GUI_MISSIONS, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
            }
        }
    }

    public void initButtons() {
        int xpos = this.field_147003_i + 7;
        String[] dropboxStrings = new String[this.tile.getObjectsToLocate().length];
        for (int i = 0; i < this.tile.getObjectsToLocate().length; ++i) {
            dropboxStrings[i] = GCCoreUtil.translate((String)("gui.dropdown." + this.tile.getObjectsToLocate()[i]));
        }
        String[] stations = new String[this.tile.getStations().length];
        for (int i = 0; i < this.tile.getStations().length; ++i) {
            stations[i] = GCCoreUtil.translate((String)this.tile.getStationName(this.tile.getStations()[i]));
        }
        this.xCord = new GuiElementTextBox(0, (GuiElementTextBox.ITextBoxCallback)this, this.field_147003_i + 8, this.field_147009_r + 80, 34, 15, "", false, 5, true);
        this.field_146292_n.add(this.xCord);
        this.yCord = new GuiElementTextBox(1, (GuiElementTextBox.ITextBoxCallback)this, this.field_147003_i + 43, this.field_147009_r + 80, 34, 15, "", false, 5, true);
        this.field_146292_n.add(this.yCord);
        this.btnHelp = new GuiButtonImage(2, xpos + 149, this.field_147009_r + 164, 13, 14, 176, 109, 0, guiTexture);
        this.field_146292_n.add(this.btnHelp);
        this.locateBtn = new GuiButton(3, this.field_147003_i + 79, this.field_147009_r + 77, 90, 20, GCCoreUtil.translate((String)"gui.mission_control_station.locate"));
        this.field_146292_n.add(this.locateBtn);
        this.locatorDataDropdown = new GuiElementDropdown(4, (GuiElementDropdown.IDropboxCallback)this, this.field_147003_i + 8, this.field_147009_r + 125, this.getLocatorDataItems());
        this.field_146292_n.add(this.locatorDataDropdown);
        this.locatableDropdown = new GuiElementDropdown(5, (GuiElementDropdown.IDropboxCallback)this, this.field_147003_i + 8, this.field_147009_r + 51, dropboxStrings);
        this.field_146292_n.add(this.locatableDropdown);
        this.btnMissions = new GuiButtonImage(6, this.field_147003_i + 4, this.field_147009_r - 7, 70, 16, 176, 140, 0, guiTexture);
        this.field_146292_n.add(this.btnMissions);
        this.btnLocator = new GuiButtonImage(7, this.field_147003_i + 74, this.field_147009_r - 7, 70, 16, 176, 124, 0, guiTexture);
        this.field_146292_n.add(this.btnLocator);
        this.stationsDropdown = new GuiElementDropdown(8, (GuiElementDropdown.IDropboxCallback)this, this.field_147003_i + 8, this.field_147009_r + 25, stations);
        this.field_146292_n.add(this.stationsDropdown);
    }

    public String[] getLocatorDataItems() {
        ArrayList<String> items = new ArrayList<String>();
        for (String line : this.tile.locatorData.split(";")) {
            String[] pairs = line.split(",");
            if (pairs[0].isEmpty()) continue;
            items.add("X: " + Float.valueOf(pairs[0]).intValue() + ", Z: " + Float.valueOf(pairs[1]).intValue());
        }
        if (items.size() == 0) {
            items.add(" ");
        }
        return (String[])items.stream().toArray(String[]::new);
    }

    private void addHelpRegion() {
        ArrayList<String> help = new ArrayList<String>();
        help.add(GCCoreUtil.translate((String)"gui.help.mcs.locator.desc.0"));
        help.add(GCCoreUtil.translate((String)"gui.help.mcs.locator.desc.1"));
        help.add(GCCoreUtil.translate((String)"gui.help.mcs.locator.desc.2"));
        this.helpRegion.tooltipStrings = help;
        this.helpRegion.xPosition = this.field_147003_i + 156;
        this.helpRegion.yPosition = this.field_147009_r + 164;
        this.helpRegion.parentWidth = this.field_146294_l;
        this.helpRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.helpRegion);
    }

    private void addElectricInfoRegion() {
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.tile.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tile.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 32;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 165;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 9, (this.field_146295_m - this.field_147000_g) / 2 + 165, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElectricInfoRegion();
        this.addHelpRegion();
        this.initButtons();
    }

    protected void func_73869_a(char keyChar, int keyID) throws IOException {
        if (keyID != 1) {
            if (this.xCord.keyTyped(keyChar, keyID)) {
                return;
            }
            if (this.yCord.keyTyped(keyChar, keyID)) {
                return;
            }
        }
        super.func_73869_a(keyChar, keyID);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.mission_control_station.tab.missions"), 10, -3, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.mission_control_station.tab.locator"), 80, -3, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.station", (Object[])new Object[0]), 8, 15, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.locatable", (Object[])new Object[0]), 8, 43, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.coordinates", (Object[])new Object[0]), 8, 70, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.mission_control_station.locator_data", (Object[])new Object[0]), 8, 115, 0x404040);
        this.updateLocatorData();
        this.tickButtons();
    }

    public void updateLocatorData() {
        if (this.tile.locationCounter > 0) {
            return;
        }
        this.locatorDataDropdown.optionStrings = this.getLocatorDataItems();
        int largestString = Integer.MIN_VALUE;
        String[] var8 = this.locatorDataDropdown.optionStrings;
        int var9 = this.locatorDataDropdown.optionStrings.length;
        for (int var10 = 0; var10 < var9; ++var10) {
            String element = var8[var10];
            largestString = Math.max(largestString, this.field_146289_q.func_78256_a(element));
        }
        this.locatorDataDropdown.field_146124_l = true;
        this.locatorDataDropdown.field_146120_f = largestString + 8 + 15;
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6 + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(this.field_147003_i + 29, this.field_147009_r + 165, 176, 0, 11, 10);
        }
        this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 167, 187, 0, Math.min(this.tile.getScaledElecticalLevel(54), 54), 7);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.renderProgressBar();
    }

    public boolean canBeClickedBy(GuiElementDropdown guiElementDropdown, EntityPlayer entityPlayer) {
        return true;
    }

    public void onSelectionChanged(GuiElementDropdown guiElementDropdown, int i) {
        if (guiElementDropdown.field_146127_k == this.locatableDropdown.field_146127_k) {
            GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.MCS_SELECT_LOCATABLE, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), i}));
        }
        if (guiElementDropdown.field_146127_k == this.stationsDropdown.field_146127_k) {
            GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.MCS_SELECT_STATION, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), i}));
        }
    }

    public int getInitialSelection(GuiElementDropdown guiElementDropdown) {
        if (guiElementDropdown.field_146127_k == this.locatableDropdown.field_146127_k) {
            return this.tile.getLocatableObjectId();
        }
        if (guiElementDropdown.field_146127_k == this.stationsDropdown.field_146127_k) {
            return this.tile.getCurStationId();
        }
        return 0;
    }

    public void onIntruderInteraction() {
    }

    public boolean canPlayerEdit(GuiElementTextBox guiElementTextBox, EntityPlayer entityPlayer) {
        return true;
    }

    public void onTextChanged(GuiElementTextBox guiElementTextBox, String s) {
        try {
            GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.EDIT_LOCATOR_CORDS, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), Integer.valueOf(this.xCord.text), Integer.valueOf(this.yCord.text)}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getInitialText(GuiElementTextBox guiElementTextBox) {
        if (guiElementTextBox.field_146127_k == this.xCord.field_146127_k) {
            return String.valueOf(this.tile.getLocatorXCord());
        }
        if (guiElementTextBox.field_146127_k == this.yCord.field_146127_k) {
            return String.valueOf(this.tile.getLocatorZCord());
        }
        return "";
    }

    public int getTextColor(GuiElementTextBox textBox) {
        return ColorUtil.to32BitColor((int)255, (int)200, (int)200, (int)200);
    }

    public void onIntruderInteraction(GuiElementTextBox guiElementTextBox) {
    }
}

