/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.client.screen;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.common.entity.EntityMiningRocket;
import igentuman.galacticresearch.common.entity.EntitySatelliteRocket;
import igentuman.galacticresearch.common.tile.TileMissionControlStation;
import java.lang.reflect.Method;
import java.nio.DoubleBuffer;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerGC;
import micdoodle8.mods.galacticraft.core.client.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GameScreenMission
implements IGameScreen {
    private float frameA;
    private float frameBx;
    private float frameBy;
    private int yPos;
    private DoubleBuffer planes;
    private Method renderModelMethod;
    private Method renderLayersMethod;
    private String status;

    public GameScreenMission() {
        if (GCCoreUtil.getEffectiveSide().isClient()) {
            this.planes = BufferUtils.createDoubleBuffer((int)256);
            try {
                Class<RenderLivingBase> clazz = RenderLivingBase.class;
                boolean count = false;
                for (Method m : clazz.getDeclaredMethods()) {
                    String s = m.getName();
                    if (s.equals(GCCoreUtil.isDeobfuscated() ? "renderModel" : "func_77036_a")) {
                        m.setAccessible(true);
                        this.renderModelMethod = m;
                        if (!count) {
                            count = true;
                            continue;
                        }
                    } else {
                        if (!s.equals(GCCoreUtil.isDeobfuscated() ? "renderLayers" : "func_177093_a")) continue;
                        m.setAccessible(true);
                        this.renderLayersMethod = m;
                        if (!count) {
                            count = true;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setFrameSize(float frameSize) {
        this.frameA = frameSize;
    }

    public TileMissionControlStation getMissionControlCenter(TileEntityTelemetry telemeter) {
        for (int i = 0; i < 6; ++i) {
            TileEntity te = telemeter.func_145831_w().func_175625_s(telemeter.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)i)));
            if (!(te instanceof TileMissionControlStation)) continue;
            return (TileMissionControlStation)te;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(int type, float ticks, float sizeX, float sizeY, IScreenManager scr) {
        DrawGameScreen screen = (DrawGameScreen)scr;
        this.frameBx = sizeX - this.frameA;
        this.frameBy = sizeY - this.frameA;
        this.drawBlackBackground(0.0f);
        this.planeEquation(this.frameA, this.frameA, 0.0f, this.frameA, this.frameBy, 0.0f, this.frameA, this.frameBy, 1.0f);
        GL11.glClipPlane((int)12288, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12288);
        this.planeEquation(this.frameBx, this.frameBy, 0.0f, this.frameBx, this.frameA, 0.0f, this.frameBx, this.frameA, 1.0f);
        GL11.glClipPlane((int)12289, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12289);
        this.planeEquation(this.frameA, this.frameBy, 0.0f, this.frameBx, this.frameBy, 0.0f, this.frameBx, this.frameBy, 1.0f);
        GL11.glClipPlane((int)12290, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12290);
        this.planeEquation(this.frameBx, this.frameA, 0.0f, this.frameA, this.frameA, 0.0f, this.frameA, this.frameA, 1.0f);
        GL11.glClipPlane((int)12291, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12291);
        this.yPos = 0;
        TileEntityTelemetry telemeter = TileEntityTelemetry.getNearest((TileEntity)screen.driver);
        String strName = "";
        String[] str = new String[]{GCCoreUtil.translate((String)"gui.display.nolink"), "", "", "", ""};
        Render renderEntity = null;
        Object entity = null;
        float Xmargin = 0.0f;
        if (telemeter != null) {
            TileMissionControlStation mcs = this.getMissionControlCenter(telemeter);
            if (mcs != null) {
                if (mcs.getRocket() == null) {
                    if (mcs.currentMission.toUpperCase().contains("ASTEROID-")) {
                        entity = new EntityMiningRocket(telemeter.func_145831_w());
                    } else if (!mcs.currentMission.isEmpty()) {
                        entity = new EntitySatelliteRocket(telemeter.func_145831_w());
                    }
                } else {
                    entity = (EntityAutoRocket)mcs.getRocket();
                }
                if (entity != null) {
                    renderEntity = FMLClientHandler.instance().getClient().func_175598_ae().func_78713_a((Entity)entity);
                }
                if (!(strName = mcs.currentMission).isEmpty()) {
                    this.status = mcs.getMissionStatusKey(mcs.currentMission);
                    if (!strName.toUpperCase().contains("ASTEROID-")) {
                        String tmp = I18n.func_135052_a((String)("planet." + strName), (Object[])new Object[0]);
                        if (tmp.equals(strName)) {
                            tmp = I18n.func_135052_a((String)("moon." + strName), (Object[])new Object[0]);
                        }
                        strName = tmp;
                    }
                    str[0] = GCCoreUtil.translate((String)this.status);
                    int state = mcs.getMissionInfo(mcs.currentMission);
                    int percent = 0;
                    if (state > 0) {
                        int mined;
                        percent = mcs.getMissonPercent(mcs.currentMission);
                        if (strName.toUpperCase().contains("ASTEROID-") && (mined = GalacticResearch.spaceMineProvider.getOreCnt(strName) / 100 * percent) > 0) {
                            str[2] = I18n.func_135052_a((String)"screen.mined_blocks", (Object[])new Object[]{mined});
                        }
                    }
                    if (percent > 0 && percent < 100) {
                        str[1] = percent + GCCoreUtil.translate((String)"screen.progress_done");
                    }
                }
            } else {
                str[2] = "No MCS found";
            }
        }
        int textWidthPixels = 155;
        int textHeightPixels = 60;
        if (str[3].isEmpty()) {
            textHeightPixels -= 10;
        }
        if (str[4].isEmpty()) {
            textHeightPixels -= 10;
        }
        float borders = this.frameA * 2.0f + 0.05f * Math.min(sizeX, sizeY);
        float scaleXTest = (sizeX - borders) / (float)textWidthPixels;
        float scaleYTest = (sizeY - borders) / (float)textHeightPixels;
        float scale = sizeX;
        if (scaleYTest < scaleXTest) {
            scale = sizeY;
        }
        borders = this.frameA * 2.0f + 0.05f * scale;
        scaleXTest = (sizeX - borders) / (float)textWidthPixels;
        scaleYTest = (sizeY - borders) / (float)textHeightPixels;
        scale = sizeX;
        float scaleText = scaleXTest;
        if (scaleYTest < scaleXTest) {
            scale = sizeY;
            scaleText = scaleYTest;
        }
        float border = this.frameA + 0.025f * scale;
        if (entity != null && renderEntity != null) {
            Xmargin = (sizeX - borders) / 2.0f;
        }
        float Xoffset = (sizeX - borders - (float)textWidthPixels * scaleText) / 2.0f + Xmargin;
        float Yoffset = (sizeY - borders - (float)textHeightPixels * scaleText) / 2.0f + scaleText;
        int whiteColour = ColorUtil.to32BitColor((int)255, (int)240, (int)216, (int)255);
        String title = "";
        title = strName.toUpperCase().contains("ASTEROID-") ? I18n.func_135052_a((String)"screen.title.mining", (Object[])new Object[0]) : I18n.func_135052_a((String)"screen.title.research", (Object[])new Object[0]);
        int tlength = Minecraft.func_71410_x().field_71466_p.func_78256_a(title);
        GL11.glTranslatef((float)(border + (float)tlength * scaleText / 4.0f), (float)border, (float)0.0f);
        GL11.glScalef((float)scaleText, (float)scaleText, (float)1.0f);
        this.drawTitle(title, whiteColour);
        GL11.glScalef((float)(1.0f / scaleText), (float)(1.0f / scaleText), (float)1.0f);
        GL11.glTranslatef((float)(-border - (float)tlength * scaleText / 4.0f), (float)(-border), (float)0.0f);
        GL11.glTranslatef((float)(border + Xoffset), (float)(border + Yoffset), (float)0.0f);
        GL11.glScalef((float)scaleText, (float)scaleText, (float)1.0f);
        this.drawText(strName, whiteColour);
        this.drawText(str[0], whiteColour);
        this.drawText(str[1], whiteColour);
        this.drawText(str[2], whiteColour);
        this.drawText(str[3], whiteColour);
        this.drawText(str[4], whiteColour);
        if (renderEntity != null && entity != null) {
            GL11.glTranslatef((float)(-Xmargin / 2.0f / scaleText), (float)((float)(textHeightPixels / 2) + (-Yoffset + (sizeY - borders) / 2.0f) / scaleText), (float)-5.0E-4f);
            float scalefactor = 38.0f / (float)Math.pow(Math.max(entity.field_70131_O, entity.field_70130_N), 0.65);
            GL11.glScalef((float)scalefactor, (float)scalefactor, (float)0.0015f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderPlayerGC.flagThermalOverride = true;
            renderEntity.func_76986_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            RenderPlayerGC.flagThermalOverride = false;
        }
        GL11.glDisable((int)12291);
        GL11.glDisable((int)12290);
        GL11.glDisable((int)12289);
        GL11.glDisable((int)12288);
    }

    private void drawTitle(String str, int colour) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a(str, 0.0f, 0.0f, colour, false);
        this.yPos += 10;
    }

    private void drawText(String str, int colour) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a(str, 0.0f, (float)this.yPos, colour, false);
        this.yPos += 10;
    }

    private void drawBlackBackground(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameA, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameA, (double)0.005f).func_181675_d();
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void planeEquation(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        double[] result = new double[]{y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2), z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2), x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2), -(x1 * (y2 * z3 - y3 * z2) + x2 * (y3 * z1 - y1 * z3) + x3 * (y1 * z2 - y2 * z1))};
        this.planes.put(result, 0, 4);
        this.planes.position(0);
    }
}

