/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.block;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.common.tile.TileMissionControlStation;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class BlockMissionControlStation
extends BlockHorizontal {
    public BlockMissionControlStation() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(17.5f);
        this.func_149663_c("mission_control_station");
        this.setRegistryName("galacticresearch", "mission_control_station");
        this.func_149647_a((CreativeTabs)GalacticraftCore.galacticraftBlocksTab);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.3, 1.0);
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    @NotNull
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@NotNull World world, @NotNull IBlockState state) {
        return new TileMissionControlStation();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        if (player.func_184812_l_()) {
            world.func_175698_g(pos);
            return true;
        }
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound fmData;
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileMissionControlStation)) {
            return true;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack held = playerIn.field_71071_by.func_70448_g();
        if (!held.func_190926_b() && held.func_77973_b() == GCItems.basicItem && held.func_77952_i() == 19 && (fmData = held.func_77978_p()) != null && fmData.func_74764_b("teledishPos")) {
            ((TileMissionControlStation)te).bindTeleDish(fmData.func_74759_k("teledishPos"));
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.teledish_set", new Object[0]));
            return true;
        }
        playerIn.openGui((Object)GalacticResearch.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable World world, List<String> currentTooltip, ITooltipFlag flag) {
        String[] parts;
        super.func_190948_a(itemStack, world, currentTooltip, flag);
        for (String line : parts = I18n.func_135052_a((String)"description.mission_control_station", (Object[])new Object[]{123}).split("\\\\n")) {
            currentTooltip.add(TextFormatting.AQUA + line);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TileMissionControlStation) {
            ItemStack item = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound compound = new NBTTagCompound();
            if (!((TileMissionControlStation)tile).missionsData.isEmpty()) {
                compound.func_74778_a("missionsData", ((TileMissionControlStation)tile).missionsData);
            }
            if (!((TileMissionControlStation)tile).stations.isEmpty()) {
                compound.func_74778_a("stations", ((TileMissionControlStation)tile).stations);
            }
            item.func_77982_d(compound);
            BlockMissionControlStation.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            worldIn.func_175713_t(pos);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemStack.field_190927_a.func_77973_b();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && stack != null && tile != null && stack.func_77942_o() && tile instanceof TileMissionControlStation) {
            if (stack.func_77978_p().func_74764_b("missionsData")) {
                String missionsData;
                ((TileMissionControlStation)tile).missionsData = missionsData = stack.func_77978_p().func_74779_i("missionsData");
                ((TileMissionControlStation)tile).unserializeMissionData();
            }
            if (stack.func_77978_p().func_74764_b("stations")) {
                String stations;
                ((TileMissionControlStation)tile).stations = stations = stack.func_77978_p().func_74779_i("stations");
            }
        }
    }
}

