/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.data;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.common.data.WorldSaveDataGR;
import igentuman.galacticresearch.network.GRPacketSimple;
import igentuman.galacticresearch.util.StackUtil;
import igentuman.galacticresearch.util.Util;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class SpaceMineProvider {
    private static SpaceMineProvider instance;
    private HashMap<String, Integer> missions = new HashMap();
    public HashMap<ItemStack, Integer> ores = new HashMap();
    public int generateCounter;
    private WorldSaveDataGR dataHolder = null;
    private boolean hasChanges = false;

    public boolean isMissionInProgress(String mission) {
        if (this.missions.containsKey(mission)) {
            int left = this.missions.get(mission);
            return this.getOreCnt(mission) != left;
        }
        return false;
    }

    private SpaceMineProvider() {
    }

    public void removeMissions() {
        GalacticResearch.skyModel.removeAsteroids();
        this.missions.clear();
        this.saveData();
    }

    public void deleteMissions() {
        HashMap<String, Integer> tmp = new HashMap<String, Integer>();
        String toDelete = "";
        for (String m : this.missions.keySet()) {
            if (toDelete.isEmpty() && !this.isMissionInProgress(m)) {
                toDelete = m;
            }
            if (this.missions.get(m) > 0) {
                tmp.put(m, this.missions.get(m));
                continue;
            }
            GalacticResearch.skyModel.removeAsteroid(m);
            this.hasChanges = true;
        }
        if (!toDelete.isEmpty() && tmp.size() > ModConfig.machines.mining_missions_limit) {
            tmp.remove(toDelete);
            GalacticResearch.skyModel.removeAsteroid(toDelete);
            this.hasChanges = true;
        }
        this.missions = tmp;
    }

    public HashMap<String, Integer> getMissions() {
        return this.missions;
    }

    public void setMissions(HashMap<String, Integer> m) {
        this.missions = m;
        GalacticResearch.skyModel.removeAsteroids();
        for (String name : this.missions.keySet()) {
            GalacticResearch.skyModel.addAsteroid(name);
        }
    }

    private WorldSaveDataGR dataHolder() {
        try {
            if (this.dataHolder == null) {
                this.dataHolder = WorldSaveDataGR.get(GalacticResearch.server.func_130014_f_());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.dataHolder;
    }

    public void saveData() {
        if (GalacticResearch.server != null) {
            this.dataHolder().save(GalacticResearch.server.func_130014_f_());
        }
    }

    public void updateMissions() {
        if (GalacticResearch.server == null) {
            return;
        }
        int days = (int)(GalacticResearch.server.func_130014_f_().func_82737_E() / 1728000L);
        if (days < ModConfig.machines.asteroid_spawn_delay) {
            return;
        }
        this.dataHolder();
        --this.generateCounter;
        if (this.generateCounter <= 0) {
            this.deleteMissions();
            this.generateMission();
            this.generateCounter = 5000000 / ModConfig.machines.mining_asteroids_popularity;
            this.saveData();
        }
        this.syncToAll();
    }

    public static SpaceMineProvider get() {
        if (instance == null) {
            instance = new SpaceMineProvider();
            SpaceMineProvider.instance.generateCounter = 5000000 / ModConfig.machines.mining_asteroids_popularity;
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Map.Entry<String, Integer> entry : ModConfig.machines.mineable_resources.entrySet()) {
                list.add(entry.getValue());
            }
            Collections.sort(list);
            Iterator<Map.Entry<String, Integer>> iterator = list.iterator();
            while (iterator.hasNext()) {
                int num = (Integer)((Object)iterator.next());
                for (Map.Entry<String, Integer> entry : ModConfig.machines.mineable_resources.entrySet()) {
                    ItemStack st;
                    if (!entry.getValue().equals(num) || (st = StackUtil.stackFromRegistry(entry.getKey())) == null || st.equals(ItemStack.field_190927_a)) continue;
                    SpaceMineProvider.instance.ores.put(st, num);
                }
            }
        }
        return instance;
    }

    protected ItemStack randomOre(String mission) {
        Random r = new Random(mission.hashCode() + this.missions.get(mission));
        int pos = r.nextInt(this.ores.size()) - 1;
        if (pos < this.ores.size() / 2) {
            pos = r.nextInt(this.ores.size()) - 1;
        }
        int i = 0;
        for (ItemStack st : this.ores.keySet()) {
            if (i == pos) {
                st.func_190920_e(1);
                return st;
            }
            ++i;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack mineBlock(String mission) {
        int left;
        if (this.missions.containsKey(mission) && (left = this.missions.get(mission).intValue()) > 0) {
            this.missions.replace(mission, --left);
            this.hasChanges = true;
            return this.randomOre(mission);
        }
        return ItemStack.field_190927_a;
    }

    private String randomString(int n) {
        byte[] array = new byte[256];
        new Random().nextBytes(array);
        String randomString = new String(array, Charset.forName("UTF-8"));
        StringBuilder r = new StringBuilder();
        for (int k = 0; k < randomString.length(); ++k) {
            char ch = randomString.charAt(k);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (ch < '0' || ch > '9') || n <= 0) continue;
            r.append(ch);
            --n;
        }
        return r.toString().toUpperCase();
    }

    public int getOreCnt(String name) {
        return Math.max(new Random(name.hashCode()).nextInt(ModConfig.machines.mining_mission_maximal_resources), ModConfig.machines.mining_mission_minimal_resources) * 64;
    }

    public String generateMission(boolean saveFlag) {
        String result = this.generateMission();
        if (saveFlag) {
            this.saveData();
        }
        return result;
    }

    public String generateMission() {
        String name = "ASTEROID-" + this.randomString(4);
        int cnt = this.getOreCnt(name);
        this.missions.put(name, cnt);
        GalacticResearch.skyModel.addAsteroid(name);
        if (ModConfig.machines.announce_asteroids) {
            GalacticResearch.server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString("Asteroid detected on sky"));
        }
        this.hasChanges = true;
        return name + " (" + cnt + ")";
    }

    public void syncToPlayer(EntityPlayerMP player) {
        GalacticResearch.packetPipeline.sendTo((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.SYNC_ASTEROIDS, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[]{Util.serializeMap(this.getMissions())}), player);
    }

    public void syncToAll() {
        if (this.hasChanges) {
            this.hasChanges = false;
            GalacticResearch.packetPipeline.sendToAll((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.SYNC_ASTEROIDS, 0, new Object[]{Util.serializeMap(this.getMissions())}));
        }
    }
}

