/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.entity;

import com.mjr.extraplanets.tileEntities.blocks.TileEntityTier2LandingPad;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.RegistryHandler;
import igentuman.galacticresearch.common.entity.IGRAutoRocket;
import igentuman.galacticresearch.common.tile.TileMissionControlStation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.advancement.GCTriggers;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.logging.log4j.Level;

public class EntityMiningRocket
extends EntityCargoRocket
implements IGRAutoRocket {
    public BlockPos mcsPos = new BlockPos(0, 0, 0);
    public BlockPos padPos = new BlockPos(0, 0, 0);
    public String mission = "";
    private boolean isMining = false;
    private int mineDelay = 10;
    private boolean miningDone = false;
    public IRocketType.EnumRocketType rocketType = IRocketType.EnumRocketType.INVENTORY54;
    public boolean willFail = false;
    public boolean inTransit = false;
    public int transitCounter = 500;
    private boolean rocketSoundToStop;
    private boolean addToTelemetry;
    private ArrayList<BlockVec3Dim> telemetryList = new ArrayList();

    public EntityMiningRocket(World par1World) {
        super(par1World);
        ((EntityCargoRocket)this).rocketType = this.rocketType = IRocketType.EnumRocketType.INVENTORY54;
        this.func_70105_a(0.98f, 2.0f);
    }

    public EntityMiningRocket(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6, IRocketType.EnumRocketType.INVENTORY54);
        ((EntityCargoRocket)this).rocketType = this.rocketType = IRocketType.EnumRocketType.INVENTORY54;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.func_70105_a(0.98f, 2.0f);
    }

    public int getFuelTankCapacity() {
        return 5000;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(RegistryHandler.MINING_ROCKET, 1, 0);
    }

    public void updateMCSPos() {
        TileEntityLandingPad pad;
        IFuelDock dock = this.getLandingPad();
        if (dock instanceof TileEntityLandingPad) {
            pad = (TileEntityLandingPad)dock;
            for (ILandingPadAttachable te : pad.getConnectedTiles()) {
                if (!(te instanceof TileMissionControlStation)) continue;
                this.mcsPos = ((TileMissionControlStation)te).func_174877_v();
                return;
            }
        }
        if (EntityMiningRocket.isGSPadTile((TileEntity)dock)) {
            pad = (TileEntityAdvLandingPad)dock;
            for (ILandingPadAttachable te : pad.getConnectedTiles()) {
                if (!(te instanceof TileMissionControlStation)) continue;
                this.mcsPos = ((TileMissionControlStation)te).func_174877_v();
                return;
            }
        }
        if (EntityMiningRocket.isEPPadTile((TileEntity)dock)) {
            pad = (TileEntityTier2LandingPad)dock;
            for (ILandingPadAttachable te : pad.getConnectedTiles()) {
                if (!(te instanceof TileMissionControlStation)) continue;
                this.mcsPos = ((TileMissionControlStation)te).func_174877_v();
                return;
            }
        }
    }

    public void mineResources() {
        --this.mineDelay;
        if (this.mineDelay <= 0 && !this.miningDone) {
            if (this.willFail && this.field_70146_Z.nextInt(400) < 10) {
                TileMissionControlStation te = this.getMCS();
                te.setMissionInfo(this.mission, -3);
                this.isMining = false;
                this.func_70106_y();
                return;
            }
            ItemStack st = GalacticResearch.spaceMineProvider.mineBlock(this.mission);
            if (st.equals(ItemStack.field_190927_a) && GalacticResearch.spaceMineProvider.getMissions().get(this.mission) <= 0) {
                this.transitCounter = 500;
                this.inTransit = true;
                this.miningDone = true;
                return;
            }
            this.addCargo(st, true);
            this.mineDelay = ModConfig.machines.mining_speed;
            this.addFuel(new FluidStack(Objects.requireNonNull(this.fuelTank.getFluid()), this.mineDelay - 1), true);
        }
    }

    public void updateTransit() {
        if (this.inTransit) {
            if (this.transitCounter > 0) {
                --this.transitCounter;
                this.field_70181_x = !this.isMining ? (this.field_70181_x += 5.0) : (this.field_70181_x -= 10.0);
            } else {
                this.inTransit = false;
                if (!this.isMining) {
                    this.isMining = true;
                }
            }
        }
    }

    public boolean checkLaunchValidity() {
        this.statusMessageCooldown = 40;
        if (this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal() && !this.field_70170_p.field_72995_K) {
                if (this.mission.isEmpty()) {
                    this.statusMessage = I18n.func_74838_a((String)"gui.message.mission_empty");
                    this.statusColour = "\u00a7c";
                    return false;
                }
                this.statusMessage = I18n.func_74838_a((String)"gui.message.success.name");
                this.statusColour = "\u00a7a";
                return true;
            }
            return false;
        }
        this.destinationFrequency = -1;
        this.statusMessage = I18n.func_74838_a((String)"gui.message.not_enough.name") + "#" + I18n.func_74838_a((String)"gui.message.fuel.name");
        this.statusColour = "\u00a7c";
        return false;
    }

    @Override
    public void setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase phase) {
        if (phase.equals((Object)EntitySpaceshipBase.EnumLaunchPhase.IGNITED)) {
            this.miningDone = false;
            this.isMining = false;
            if (this.mission.isEmpty()) {
                return;
            }
        }
        super.setLaunchPhase(phase);
    }

    private static boolean isGSPadTile(TileEntity tile) {
        boolean result = false;
        if (GalacticResearch.hooks.GalaxySpaceLoaded) {
            result = tile instanceof TileEntityAdvLandingPad;
        }
        return result;
    }

    private static boolean isEPPadTile(TileEntity tile) {
        boolean result = false;
        if (GalacticResearch.hooks.ExtraPlanetsLoaded) {
            result = tile instanceof TileEntityTier2LandingPad;
        }
        return result;
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityLandingPad || EntityMiningRocket.isGSPadTile((TileEntity)dock) || EntityMiningRocket.isEPPadTile((TileEntity)dock);
    }

    @Override
    public void setAutolaunchSetting(EntityAutoRocket.EnumAutoLaunch setting) {
        this.autoLaunchSetting = setting;
    }

    protected void parentUpdate() {
        AxisAlignedBB box;
        List var15;
        if (this.field_70170_p.field_72995_K && this.field_70175_ag && !CompatibilityManager.isCubicChunksLoaded) {
            Chunk chunk = this.field_70170_p.func_72964_e(this.field_70176_ah, this.field_70164_aj);
            int cx = MathHelper.func_76128_c((double)this.field_70165_t) >> 4;
            int cz = MathHelper.func_76128_c((double)this.field_70161_v) >> 4;
            if (chunk.func_177410_o() && this.field_70176_ah == cx && this.field_70164_aj == cz) {
                boolean thisfound = false;
                ClassInheritanceMultiMap mapEntities = chunk.func_177429_s()[this.field_70162_ai];
                for (Entity ent : mapEntities) {
                    if (ent != this) continue;
                    thisfound = true;
                    break;
                }
                if (!thisfound) {
                    chunk.func_76612_a((Entity)this);
                }
            }
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.hasValidFuel() && this.targetVec != null) {
            double yDiff = this.field_70163_u - this.getOnPadYOffset() - (double)this.targetVec.func_177956_o();
            this.field_70181_x = Math.max(-2.0, (yDiff - 0.04) / -55.0);
            double diff = this.field_70165_t - (double)this.targetVec.func_177958_n() - 0.5;
            double motX = diff > 0.0 ? Math.max(-0.1, diff / -100.0) : (diff < 0.0 ? Math.min(0.1, diff / -100.0) : 0.0);
            diff = this.field_70161_v - (double)this.targetVec.func_177952_p() - 0.5;
            double motZ = diff > 0.0 ? Math.max(-0.1, diff / -100.0) : (diff < 0.0 ? Math.min(0.1, diff / -100.0) : 0.0);
            if (motZ == 0.0 && motX == 0.0) {
                this.field_70125_A = 0.0f;
            } else {
                double angleYaw = Math.atan(motZ / motX);
                double signed = motX < 0.0 ? 50.0 : -50.0;
                double anglePitch = Math.atan(Math.sqrt(motZ * motZ + motX * motX) / signed) * 100.0;
                this.field_70177_z = (float)angleYaw * 57.295776f;
                this.field_70125_A = (float)anglePitch * 57.295776f;
            }
            if (yDiff > 1.0 && yDiff < 4.0) {
                for (Object o : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72317_d(0.0, -3.0, 0.0), EntitySpaceshipBase.rocketSelector)) {
                    if (!(o instanceof EntitySpaceshipBase)) continue;
                    ((EntitySpaceshipBase)o).dropShipAsItem();
                    ((EntitySpaceshipBase)o).func_70106_y();
                }
            }
            if (yDiff < 0.4) {
                int yMin = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72338_b - this.getOnPadYOffset() - 0.45)) - 2;
                int yMax = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72337_e) + 1;
                int zMin = MathHelper.func_76128_c((double)this.field_70161_v) - 1;
                int zMax = MathHelper.func_76128_c((double)this.field_70161_v) + 1;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = yMin; y <= yMax; ++y) {
                            if (!(this.field_70170_p.func_175625_s(new BlockPos(x, y, z)) instanceof IFuelDock)) continue;
                            this.field_70125_A = 0.0f;
                            this.failRocket();
                        }
                    }
                }
            }
        }
        ++this.ticks;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.addToTelemetry) {
            this.addToTelemetry = false;
            for (BlockVec3Dim vec : new ArrayList<BlockVec3Dim>(this.telemetryList)) {
                TileEntity t1 = vec.getTileEntityNoLoad();
                if (!(t1 instanceof TileEntityTelemetry) || t1.func_145837_r() || ((TileEntityTelemetry)t1).linkedEntity != this) continue;
                ((TileEntityTelemetry)t1).addTrackedEntity((Entity)this);
            }
        }
        for (Entity e : this.func_184188_bt()) {
            e.field_70143_R = 0.0f;
        }
        double d = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
        if (this.field_70163_u > d && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal()) {
            this.onReachAtmosphere();
        }
        if (this.rollAmplitude > 0.0f) {
            this.rollAmplitude -= 1.0f;
        }
        if (this.shipDamage > 0.0f) {
            this.shipDamage -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70163_u < 0.0) {
                this.func_70106_y();
            } else {
                double d2 = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                int n = this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() ? 355 : 100;
                if (this.field_70163_u > d2 + (double)n) {
                    for (Entity e : this.func_184188_bt()) {
                        if (e instanceof EntityPlayerMP) {
                            GCPlayerStats stats = GCPlayerStats.get((Entity)e);
                            if (!stats.isUsingPlanetSelectionGui()) continue;
                            this.func_70106_y();
                            continue;
                        }
                        this.func_70106_y();
                    }
                }
            }
            if (this.timeSinceLaunch > 50.0f && this.field_70122_E) {
                this.failRocket();
            }
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal()) {
            this.timeUntilLaunch = this.getPreLaunchWait();
        }
        this.timeSinceLaunch = this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() ? (this.timeSinceLaunch += 1.0f) : 0.0f;
        if (this.timeUntilLaunch > 0 && this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            --this.timeUntilLaunch;
        }
        if ((var15 = this.field_70170_p.func_72839_b((Entity)this, box = this.func_174813_aQ().func_186662_g(0.2))) != null && !var15.isEmpty()) {
            for (Object o : var15) {
                Entity var17 = (Entity)o;
                if (!this.func_184188_bt().contains(var17)) continue;
                var17.func_70108_f((Entity)this);
            }
        }
        if (this.timeUntilLaunch == 0 && this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED);
            this.onLaunch();
        }
        if (this.field_70125_A > 90.0f) {
            this.field_70125_A = 90.0f;
        }
        if (this.field_70125_A < -90.0f) {
            this.field_70125_A = -90.0f;
        }
        this.field_70159_w = -(50.0 * Math.cos((double)this.field_70177_z / 57.29577951308232) * Math.sin((double)this.field_70125_A * 0.01 / 57.29577951308232));
        this.field_70179_y = -(50.0 * Math.sin((double)this.field_70177_z / 57.29577951308232) * Math.sin((double)this.field_70125_A * 0.01 / 57.29577951308232));
        if (this.launchPhase < EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.shouldMoveClientSide()) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        } else {
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K && this.ticks % 3L == 0L) {
            GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketDynamic((Entity)this), this.field_70170_p.field_73011_w.getDimension());
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.func_184188_bt().size() >= 1 && this.func_184188_bt().get(0) instanceof EntityPlayerMP) {
            GCTriggers.LAUNCH_ROCKET.trigger((EntityPlayerMP)this.func_184188_bt().get(0));
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.statusMessageCooldown > 0) {
                --this.statusMessageCooldown;
            }
            this.lastStatusMessageCooldown = this.statusMessageCooldown;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            if (this.rocketSoundUpdater != null) {
                this.rocketSoundUpdater.func_73660_a();
                this.rocketSoundToStop = true;
            }
        } else if (this.rocketSoundToStop) {
            this.stopRocketSound();
            if (this.rocketSoundUpdater != null) {
                FMLClientHandler.instance().getClient().func_147118_V().func_147683_b((ISound)this.rocketSoundUpdater);
            }
            this.rocketSoundUpdater = null;
        }
    }

    public void func_70071_h_() {
        if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal()) {
            this.updateMCSPos();
            this.targetVec = this.padPos = this.func_180425_c();
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            double motionScalar = this.timeSinceLaunch / 250.0f;
            motionScalar = Math.min(motionScalar, 1.0);
            if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && (motionScalar *= 5.0) != 0.0) {
                this.field_70181_x = -motionScalar * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(3.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updateTransit();
        }
        if (this.isMining) {
            if (this.miningDone) {
                if (this.padPos.equals((Object)new BlockPos(0, 0, 0))) {
                    this.func_70106_y();
                    return;
                }
                if (!this.inTransit && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal()) {
                    this.launchPhase = EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal();
                    this.func_70107_b((float)this.padPos.func_177958_n() + 0.5f, this.padPos.func_177956_o() + 800, (float)this.padPos.func_177952_p() + 0.5f);
                    this.field_70181_x = -5.0;
                }
            } else if (!this.field_70170_p.field_72995_K && !this.inTransit) {
                try {
                    this.mineResources();
                }
                catch (NullPointerException ignored) {
                    this.isMining = true;
                    this.miningDone = true;
                }
                return;
            }
        }
        try {
            this.parentUpdate();
        }
        catch (NullPointerException e) {
            GalacticResearch.instance.logger.log(Level.FATAL, e.getMessage());
            this.func_70106_y();
            return;
        }
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        }
        if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
    }

    public void onReachAtmosphere() {
        if (this.field_70170_p.field_72995_K) {
            this.stopRocketSound();
            return;
        }
        TileMissionControlStation te = this.getMCS();
        if (te != null && !this.inTransit && !this.isMining) {
            if (this.field_70170_p.field_73012_v.nextInt(100) > ModConfig.machines.mining_mission_success_rate) {
                this.willFail = true;
            }
            te.setMissionInfo(this.mission, 1);
            this.inTransit = true;
        }
    }

    @Override
    public void setMission(String name) {
        this.mission = name;
    }

    public TileMissionControlStation getMCS() {
        TileEntityLandingPad pad = (TileEntityLandingPad)this.getLandingPad();
        if (pad == null) {
            return (TileMissionControlStation)this.field_70170_p.func_175625_s(this.mcsPos);
        }
        for (ILandingPadAttachable te : pad.getConnectedTiles()) {
            if (!(te instanceof TileMissionControlStation)) continue;
            return (TileMissionControlStation)te;
        }
        return null;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (!this.field_70170_p.field_72995_K) {
            nbt.func_74768_a("Type", this.rocketType.getIndex());
            nbt.func_74778_a("mission", this.mission);
            nbt.func_74757_a("isMining", this.isMining);
            nbt.func_74757_a("inTransit", this.inTransit);
            nbt.func_74783_a("padPos", new int[]{this.padPos.func_177958_n(), this.mcsPos.func_177956_o(), this.mcsPos.func_177952_p()});
            nbt.func_74783_a("mcsPos", new int[]{this.mcsPos.func_177958_n(), this.mcsPos.func_177956_o(), this.mcsPos.func_177952_p()});
            super.func_70014_b(nbt);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        this.mission = nbt.func_74779_i("mission");
        this.isMining = nbt.func_74767_n("isMining");
        this.inTransit = nbt.func_74767_n("inTransit");
        int[] raw = nbt.func_74759_k("mcsPos");
        try {
            this.mcsPos = new BlockPos(raw[0], raw[1], raw[2]);
            raw = nbt.func_74759_k("padPos");
            this.targetVec = this.padPos = new BlockPos(raw[0], raw[1], raw[2]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        super.func_70037_a(nbt);
    }

    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        return this.rocketType == null ? 0 : this.rocketType.getInventorySpace();
    }

    public void onWorldTransferred(World world) {
    }

    public int getRocketTier() {
        return 2047483647;
    }

    public int getPreLaunchWait() {
        return 5;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItemList) {
        super.getItemsDropped(droppedItemList);
        ArrayList<ItemStack> tmp = new ArrayList<ItemStack>();
        for (ItemStack item : droppedItemList) {
            if (item.func_77973_b().equals(MarsItems.rocketMars)) continue;
            tmp.add(item);
        }
        droppedItemList = tmp;
        ItemStack rocket = new ItemStack(RegistryHandler.MINING_ROCKET, 1, 0);
        rocket.func_77982_d(new NBTTagCompound());
        assert (rocket.func_77978_p() != null);
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItemList.add(rocket);
        return droppedItemList;
    }
}

