/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.entity;

import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.RegistryHandler;
import igentuman.galacticresearch.common.entity.IGRAutoRocket;
import igentuman.galacticresearch.common.tile.TileMissionControlStation;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntitySatelliteRocket
extends EntityAutoRocket
implements IRocketType,
IInventory,
IWorldTransferCallback,
IGRAutoRocket {
    public IRocketType.EnumRocketType rocketType;
    public float rumble;
    public BlockPos mcsPos = new BlockPos(0, 0, 0);
    public String mission;
    public int researchCounter;
    public boolean isResearching;

    public EntitySatelliteRocket(World par1World) {
        super(par1World);
        this.researchCounter = ModConfig.machines.satellite_mission_duration * 20 + 10;
        this.isResearching = false;
        this.func_70105_a(0.98f, 2.0f);
    }

    public EntitySatelliteRocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.researchCounter = ModConfig.machines.satellite_mission_duration * 20 + 10;
        this.isResearching = false;
        this.rocketType = rocketType;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.func_70105_a(0.98f, 2.0f);
    }

    public int getFuelTankCapacity() {
        return 2000;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(RegistryHandler.SATELLITE_ROCKET, 1, 0);
    }

    public void updateMCSPos() {
        TileEntityLandingPad pad = (TileEntityLandingPad)this.getLandingPad();
        if (pad == null) {
            return;
        }
        for (ILandingPadAttachable te : pad.getConnectedTiles()) {
            if (!(te instanceof TileMissionControlStation)) continue;
            this.mcsPos = ((TileMissionControlStation)te).func_174877_v();
        }
    }

    @Override
    public void setAutolaunchSetting(EntityAutoRocket.EnumAutoLaunch setting) {
        this.autoLaunchSetting = setting;
    }

    public void func_70071_h_() {
        if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.updateMCSPos();
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            double motionScalar = this.timeSinceLaunch / 250.0f;
            motionScalar = Math.min(motionScalar, 1.0);
            if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && (motionScalar *= 5.0) != 0.0) {
                this.field_70181_x = -motionScalar * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(3.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
        if (this.isResearching) {
            if (this.researchCounter > 0) {
                --this.researchCounter;
            } else {
                this.func_70106_y();
                return;
            }
            if (this.fuelTank.getFluidAmount() < 100) {
                this.func_70106_y();
                return;
            }
        }
        super.func_70071_h_();
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        }
        if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
    }

    protected boolean shouldMoveClientSide() {
        return true;
    }

    protected void spawnParticles(boolean launched) {
        double y;
        double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
        double x1 = 2.0 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
        double z1 = 2.0 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
        double y1 = 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
            y = this.field_70163_u - (double)this.targetVec.func_177956_o();
            y = Math.max(y, 1.0);
            x1 *= y / 60.0;
            y1 *= y / 60.0;
            z1 *= y / 60.0;
        }
        y = this.field_70167_r + (this.field_70163_u - this.field_70167_r) - 0.4;
        if (!this.field_70128_L) {
            EntityLivingBase riddenByEntity = !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityLivingBase ? (EntityLivingBase)this.func_184188_bt().get(0) : null;
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v + 0.2 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v - 0.2 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
        }
    }

    public void decodePacketdata(ByteBuf buffer) {
        this.rocketType = IRocketType.EnumRocketType.values()[buffer.readInt()];
        super.decodePacketdata(buffer);
        this.field_70165_t = buffer.readDouble() / 8000.0;
        this.field_70163_u = buffer.readDouble() / 8000.0;
        this.field_70161_v = buffer.readDouble() / 8000.0;
    }

    public void getNetworkedData(ArrayList<Object> list) {
        if (!this.field_70170_p.field_72995_K) {
            list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
            super.getNetworkedData(list);
            list.add(this.field_70165_t * 8000.0);
            list.add(this.field_70163_u * 8000.0);
            list.add(this.field_70161_v * 8000.0);
        }
    }

    public void onReachAtmosphere() {
        if (this.field_70170_p.field_72995_K) {
            this.stopRocketSound();
            return;
        }
        TileMissionControlStation te = this.getMCS();
        if (te != null && !this.isResearching) {
            if (te.getMissionInfo(this.mission) < 1) {
                te.setMissionInfo(this.mission, 1);
            }
            this.isResearching = true;
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    @Override
    public void setMission(String name) {
        this.mission = name;
    }

    public TileMissionControlStation getMCS() {
        TileEntityLandingPad pad = (TileEntityLandingPad)this.getLandingPad();
        if (pad == null) {
            return (TileMissionControlStation)this.field_70170_p.func_175625_s(this.mcsPos);
        }
        for (ILandingPadAttachable te : pad.getConnectedTiles()) {
            if (!(te instanceof TileMissionControlStation)) continue;
            return (TileMissionControlStation)te;
        }
        return null;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (!this.field_70170_p.field_72995_K) {
            nbt.func_74768_a("Type", this.rocketType.getIndex());
            nbt.func_74783_a("mcsPos", new int[]{this.mcsPos.func_177958_n(), this.mcsPos.func_177956_o(), this.mcsPos.func_177952_p()});
            super.func_70014_b(nbt);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        int[] raw = nbt.func_74759_k("mcsPos");
        this.mcsPos = new BlockPos(raw[0], raw[1], raw[2]);
        super.func_70037_a(nbt);
    }

    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        return this.rocketType == null ? 0 : this.rocketType.getInventorySpace();
    }

    public void onWorldTransferred(World world) {
        this.func_70106_y();
    }

    public int getRocketTier() {
        return 1147483647;
    }

    public int getPreLaunchWait() {
        return 5;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItemList) {
        super.getItemsDropped(droppedItemList);
        ItemStack rocket = new ItemStack(RegistryHandler.SATELLITE_ROCKET, 1, 0);
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItemList.add(rocket);
        return droppedItemList;
    }

    public boolean isPlayerRocket() {
        return false;
    }

    public double getOnPadYOffset() {
        return -0.05;
    }

    public float getRenderOffsetY() {
        return -0.1f;
    }
}

