/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryWrapper
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    private final InventoryBasic inventory = new InventoryBasic("fh", false, 1);

    public int getSlots() {
        return this.inventory.func_70302_i_();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
                this.onSlotItemChanged(slot);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    protected void onContentsChanged(int slot) {
    }

    protected void onSlotItemChanged(int slot) {
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (simulate) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)Math.min(stack.func_190916_E(), amount));
        }
        return this.inventory.func_70298_a(slot, amount);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
        this.onContentsChanged(slot);
        this.onSlotItemChanged(slot);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            this.getStackInSlot(i).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory.func_174888_l();
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.getSlots()) continue;
            this.setStackInSlot(slot, new ItemStack(itemTags));
        }
        this.onLoad();
    }

    protected void onLoad() {
    }
}

