/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.tile;

import com.mjr.extraplanets.tileEntities.blocks.TileEntityTier2LandingPad;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.util.GrFakePlayer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileLaunchpadTower
extends TileBaseElectricBlockWithInventory
implements ILandingPadAttachable,
IMultiBlock,
IDisableableMachine,
IInventoryDefaults,
ISidedInventory,
IConnector {
    private boolean initialised = false;
    private AxisAlignedBB renderAABB;
    private Object attachedDock;
    public float cPos = -0.5f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean autoMount = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private String padCords = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean hasRocket = false;
    private int mountCountdown = 10;
    protected int refreshCountdown = 40;

    public TileLaunchpadTower() {
        super("tile.launchpad_tower.name");
        this.storage.setMaxExtract(100.0f);
        this.setTierGC(1);
        this.inventory = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
    }

    public void handleAutomount() {
        if (!this.autoMount) {
            return;
        }
        if (this.getEnergyStoredGC() > 300.0f) {
            if (this.mountCountdown > 40) {
                this.mount();
                this.mountCountdown = 0;
            }
            ++this.mountCountdown;
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.refreshCountdown > 0) {
            --this.refreshCountdown;
        } else {
            this.refreshCountdown = 40;
            this.updatePadConnection();
        }
        if (!this.initialised) {
            this.initialised = this.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b);
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean bl = this.hasRocket = this.getRocket() != null;
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            this.handleAutomount();
        } else {
            this.updateCpos();
        }
    }

    protected boolean initialiseMultiTiles(BlockPos pos, World world) {
        if (world.field_72995_K) {
            this.onCreate(world, pos);
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(pos, positions);
        boolean result = true;
        for (BlockPos vecToAdd : positions) {
            TileEntity tile = world.func_175625_s(vecToAdd);
            if (tile instanceof TileEntityMulti) {
                ((TileEntityMulti)tile).mainBlockPosition = pos;
                continue;
            }
            result = false;
        }
        return result;
    }

    private void updateCpos() {
        if (this.hasRocket && this.cPos > -0.25f) {
            this.cPos = (float)((double)this.cPos - 0.05);
        }
        if (!this.hasRocket && this.cPos < 0.1f) {
            this.cPos = (float)((double)this.cPos + 0.05);
        }
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        return false;
    }

    public void onCreate(World world, BlockPos placedPosition) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(placedPosition, positions);
        for (BlockPos position : positions) {
            ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(world, position, this.func_174877_v(), 0);
        }
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.CRYO_CHAMBER;
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int buildHeight = this.field_145850_b.func_72800_K() - 2;
        int y = placedPosition.func_177956_o();
        if (++y > buildHeight) {
            return;
        }
        positions.add(new BlockPos(placedPosition.func_177958_n(), y, placedPosition.func_177952_p()));
        positions.add(new BlockPos(placedPosition.func_177958_n(), y + 1, placedPosition.func_177952_p()));
        positions.add(new BlockPos(placedPosition.func_177958_n(), y + 2, placedPosition.func_177952_p()));
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (!stateAt.func_177230_c().equals(GCBlocks.fakeBlock) || (BlockMulti.EnumBlockMultiType)stateAt.func_177229_b((IProperty)BlockMulti.MULTI_TYPE) != BlockMulti.EnumBlockMultiType.SOLAR_PANEL_0) continue;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.05) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175698_g(pos);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("maxEnergy"));
        this.padCords = nbt.func_74779_i("padCords");
        this.setDisabled(0, nbt.func_74767_n("disabled"));
        this.disableCooldown = nbt.func_74762_e("disabledCooldown");
        this.autoMount = nbt.func_74767_n("autoMount");
        this.initialised = false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("maxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74778_a("padCords", this.padCords);
        nbt.func_74757_a("autoMount", this.autoMount);
        nbt.func_74768_a("disabledCooldown", this.disableCooldown);
        nbt.func_74757_a("disabled", this.getDisabled(0));
        return nbt;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.range(EnumFacing.DOWN, EnumFacing.EAST);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c.func_177982_a(-3, 0, -3), this.field_174879_c.func_177982_a(3, 8, 3));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    public EnumFacing getFront() {
        return EnumFacing.SOUTH;
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID != 0 && side.equals((Object)EnumFacing.WEST) && itemstack.func_77973_b().func_77658_a().contains("rocket") && slotID < 8 || side.equals((Object)EnumFacing.SOUTH) && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return side.equals((Object)EnumFacing.DOWN) || side.equals((Object)EnumFacing.EAST);
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b()) || slotID < 8 && itemstack.func_77973_b().func_77658_a().contains("rocket");
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case WEST: {
                return new int[]{1, 2, 3, 4, 5, 6, 7};
            }
            case EAST: {
                return new int[]{8, 9, 10, 11, 12, 13, 14};
            }
            case DOWN: {
                return new int[]{8, 9, 10, 11, 12, 13, 14};
            }
            case SOUTH: {
                return new int[]{0};
            }
        }
        return new int[]{0};
    }

    public void setAttachedPad(IFuelDock pad) {
        this.attachedDock = pad;
        BlockPos bp = ((TileEntity)this.attachedDock).func_174877_v();
        this.padCords = bp.func_177958_n() + "," + bp.func_177956_o() + "," + bp.func_177952_p();
    }

    public BlockPos getPadCords() {
        if (this.padCords.isEmpty()) {
            return new BlockPos(0, 0, 0);
        }
        String[] cords = this.padCords.split(",");
        return new BlockPos(Integer.parseInt(cords[0]), Integer.parseInt(cords[1]), Integer.parseInt(cords[2]));
    }

    private static boolean isGSPadTile(TileEntity tile) {
        boolean result = false;
        if (GalacticResearch.hooks.GalaxySpaceLoaded) {
            result = tile instanceof TileEntityAdvLandingPad;
        }
        return result;
    }

    private static boolean isEPPadTile(TileEntity tile) {
        boolean result = false;
        if (GalacticResearch.hooks.ExtraPlanetsLoaded) {
            result = tile instanceof TileEntityTier2LandingPad;
        }
        return result;
    }

    public boolean connectToPad(TileEntityMulti te) {
        TileEntity main = this.field_145850_b.func_175625_s(te.mainBlockPosition);
        if (main instanceof TileEntityLandingPad) {
            ((TileEntityLandingPad)main).getConnectedTiles();
            if (this.attachedDock == null) {
                this.setAttachedPad((IFuelDock)main);
            }
            return true;
        }
        if (GalacticResearch.hooks.GalaxySpaceLoaded && main instanceof TileEntityAdvLandingPad) {
            ((TileEntityAdvLandingPad)main).getConnectedTiles();
            if (this.attachedDock == null) {
                this.setAttachedPad((IFuelDock)main);
            }
            return true;
        }
        if (GalacticResearch.hooks.ExtraPlanetsLoaded && main instanceof TileEntityTier2LandingPad) {
            ((TileEntityTier2LandingPad)main).getConnectedTiles();
            if (this.attachedDock == null) {
                this.setAttachedPad((IFuelDock)main);
            }
            return true;
        }
        return false;
    }

    public void updatePadConnection() {
        boolean tmpConnection;
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177964_d(1));
        if (te instanceof TileEntityMulti && (tmpConnection = this.connectToPad((TileEntityMulti)te))) {
            return;
        }
        te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177970_e(1));
        if (te instanceof TileEntityMulti && (tmpConnection = this.connectToPad((TileEntityMulti)te))) {
            return;
        }
        te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177985_f(1));
        if (te instanceof TileEntityMulti && (tmpConnection = this.connectToPad((TileEntityMulti)te))) {
            return;
        }
        te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177965_g(1));
        if (te instanceof TileEntityMulti && (tmpConnection = this.connectToPad((TileEntityMulti)te))) {
            return;
        }
        this.attachedDock = null;
    }

    public EntitySpaceshipBase getRocket() {
        TileEntity dock;
        if (this.attachedDock instanceof TileEntityLandingPad) {
            TileEntityLandingPad pad = (TileEntityLandingPad)this.attachedDock;
            IDockable rocket = pad.getDockedEntity();
            if (rocket instanceof EntitySpaceshipBase) {
                return (EntitySpaceshipBase)rocket;
            }
        } else if (TileLaunchpadTower.isGSPadTile((TileEntity)this.attachedDock)) {
            TileEntityAdvLandingPad pad = (TileEntityAdvLandingPad)this.attachedDock;
            IDockable rocket = pad.getDockedEntity();
            if (rocket instanceof EntitySpaceshipBase) {
                return (EntitySpaceshipBase)rocket;
            }
        } else if (TileLaunchpadTower.isEPPadTile((TileEntity)this.attachedDock)) {
            TileEntityTier2LandingPad pad = (TileEntityTier2LandingPad)this.attachedDock;
            IDockable rocket = pad.getDockedEntity();
            if (rocket instanceof EntitySpaceshipBase) {
                return (EntitySpaceshipBase)rocket;
            }
        } else if (!this.padCords.isEmpty() && (dock = this.field_145850_b.func_175625_s(this.getPadCords())) instanceof TileEntityLandingPad) {
            this.setAttachedPad((IFuelDock)dock);
            return this.getRocket();
        }
        return null;
    }

    public boolean canAttachToLandingPad(IBlockAccess iBlockAccess, BlockPos blockPos) {
        boolean flag;
        TileEntity tile = this.field_145850_b.func_175625_s(blockPos);
        boolean bl = flag = tile instanceof TileEntityLandingPad || TileLaunchpadTower.isGSPadTile(tile) || TileLaunchpadTower.isEPPadTile(tile);
        if (flag) {
            this.setAttachedPad((IFuelDock)tile);
        }
        return flag;
    }

    public void toggleAutomount() {
        this.autoMount = !this.autoMount;
        this.func_70296_d();
    }

    public void mount() {
        boolean hasRocket = false;
        int ts = 0;
        for (int i = 1; i < this.inventory.size() / 2 + 1; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            hasRocket = true;
            ts = i;
            break;
        }
        if (!hasRocket) {
            return;
        }
        if (this.attachedDock == null) {
            return;
        }
        EntitySpaceshipBase rocket = this.getRocket();
        if (rocket != null) {
            return;
        }
        ItemStack toPlace = (ItemStack)this.inventory.get(ts);
        IFuelDock dock = (IFuelDock)this.attachedDock;
        FakePlayer fplayer = new FakePlayer((WorldServer)this.field_145850_b, GrFakePlayer.getProfile());
        fplayer.func_184611_a(EnumHand.MAIN_HAND, toPlace);
        BlockPos padPos = ((TileEntity)this.attachedDock).func_174877_v();
        EnumActionResult result = fplayer.field_71134_c.func_187251_a((EntityPlayer)fplayer, this.field_145850_b, toPlace, EnumHand.MAIN_HAND, padPos, EnumFacing.DOWN, (float)padPos.func_177958_n(), (float)padPos.func_177956_o(), (float)padPos.func_177952_p());
        if (result.equals((Object)EnumActionResult.SUCCESS)) {
            this.inventory.set(ts, (Object)ItemStack.field_190927_a);
        }
    }

    public void unmount() {
        boolean hasSpace = false;
        int ts = 0;
        for (int i = this.inventory.size() / 2 + 1; i < this.inventory.size(); ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            hasSpace = true;
            ts = i;
            break;
        }
        if (!hasSpace) {
            return;
        }
        if (this.attachedDock == null) {
            return;
        }
        EntitySpaceshipBase rocket = this.getRocket();
        if (rocket == null) {
            return;
        }
        ArrayList tmp = new ArrayList();
        List drops = rocket.getItemsDropped(tmp);
        for (ItemStack st : drops) {
            if (!st.func_77973_b().func_77658_a().contains("rocket")) continue;
            this.inventory.set(ts, (Object)st);
            rocket.func_70106_y();
            return;
        }
    }
}

