/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.tile;

import igentuman.galacticresearch.common.CommonProxy;
import igentuman.galacticresearch.common.block.BlockTelescope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine2;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;

public class TileRocketAssembler
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IMachineSides {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private IMachineSides.MachineSidePack[] machineSides;
    private List<INasaWorkbenchRecipe> knownRecipes = new ArrayList<INasaWorkbenchRecipe>();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int currentRecipe = 0;

    public TileRocketAssembler() {
        super("tile.rocket_assembler.name");
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 40.0f : 20.0f);
        this.setTierGC(1);
        this.inventory = NonNullList.func_191197_a((int)30, (Object)ItemStack.field_190927_a);
    }

    public List<INasaWorkbenchRecipe> getAllRecipes() {
        if (this.knownRecipes.isEmpty()) {
            List t1 = GalacticraftRegistry.getRocketT1Recipes();
            List t2 = GalacticraftRegistry.getRocketT2Recipes();
            List t3 = GalacticraftRegistry.getRocketT3Recipes();
            List cargo = GalacticraftRegistry.getCargoRocketRecipes();
            List<INasaWorkbenchRecipe> mining = CommonProxy.getMiningRocketRecipes();
            List<INasaWorkbenchRecipe> satellite = CommonProxy.getSatelliteRocketRecipes();
            this.knownRecipes = new ArrayList<INasaWorkbenchRecipe>();
            this.knownRecipes.addAll(t1);
            this.knownRecipes.addAll(t2);
            this.knownRecipes.addAll(t3);
            this.knownRecipes.addAll(cargo);
            this.knownRecipes.addAll(mining);
            this.knownRecipes.addAll(satellite);
        }
        return this.knownRecipes;
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.getEnergyStoredGC() < 100.0f) {
                return;
            }
            if (this.canProcess()) {
                if (this.processTicks == 0) {
                    this.processTicks = 100;
                } else if (this.processTicks > 0) {
                    --this.processTicks;
                    if (this.processTicks == 0) {
                        this.doProcess();
                    }
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void doProcess() {
        this.inventory.set(1, (Object)this.getRecipe().getRecipeOutput());
        block0: for (ItemStack input : this.getRecipe().getRecipeInput().values()) {
            int toShrink = input.func_190916_E();
            for (int i = 2; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_77969_a(input)) continue;
                int avail = ((ItemStack)this.inventory.get(i)).func_190916_E();
                ((ItemStack)this.inventory.get(i)).func_190918_g(toShrink);
                if (avail >= toShrink) continue block0;
                toShrink -= avail;
            }
        }
    }

    private boolean canProcess() {
        if (!this.func_70301_a(1).func_190926_b()) {
            return false;
        }
        return this.recipeMatches();
    }

    public boolean recipeMatches() {
        HashMap<ItemStack, Integer> nestedInputs = new HashMap<ItemStack, Integer>();
        for (ItemStack input : this.getRecipe().getRecipeInput().values()) {
            boolean isNew = true;
            for (ItemStack nested : nestedInputs.keySet()) {
                if (!nested.func_77969_a(input)) continue;
                nestedInputs.put(nested, (Integer)nestedInputs.get(nested) + 1);
                isNew = false;
                break;
            }
            if (!isNew) continue;
            nestedInputs.put(input, 1);
        }
        for (ItemStack input : nestedInputs.keySet()) {
            ItemStack inv;
            int left = (Integer)nestedInputs.get(input);
            Iterator iterator = this.inventory.iterator();
            while (iterator.hasNext() && (!(inv = (ItemStack)iterator.next()).func_77969_a(input) || (left -= inv.func_190916_E()) >= 1)) {
            }
            if (left <= 0) continue;
            return false;
        }
        return true;
    }

    private INasaWorkbenchRecipe getRecipe() {
        return this.getAllRecipes().get(this.currentRecipe);
    }

    public void nextRecipe() {
        ++this.currentRecipe;
        this.currentRecipe = Math.min(this.currentRecipe, this.getAllRecipes().size() - 1);
    }

    public void prevRecipe() {
        --this.currentRecipe;
        this.currentRecipe = Math.max(this.currentRecipe, 0);
    }

    public IMachineSidesProperties getConfigurationType() {
        return BlockMachine2.MACHINESIDES_RENDERTYPE;
    }

    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT, IMachineSides.Face.RIGHT, IMachineSides.Face.BOTTOM};
    }

    public synchronized IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public EnumFacing getFront() {
        return this.byIndex();
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        if (side == this.getFront().func_176746_e() || side == this.getFront().func_176735_f() || side == EnumFacing.UP) {
            return new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
        }
        return new int[]{0};
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction != null && type == NetworkType.POWER) {
            return ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTelescope.field_185512_D)).func_176746_e() == direction || ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTelescope.field_185512_D)).func_176735_f() == direction;
        }
        return false;
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (side == EnumFacing.UP && slotID == 0) {
            return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
        }
        return side == this.getFront().func_176746_e() || side == this.getFront().func_176735_f() || side == EnumFacing.UP;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return side.equals((Object)EnumFacing.DOWN);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("maxEnergy"));
        this.currentRecipe = nbt.func_74762_e("currentRecipe");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("maxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74768_a("currentRecipe", this.currentRecipe);
        return nbt;
    }

    public void switchRecipe(Integer val) {
        if (val > 0) {
            this.nextRecipe();
        } else {
            this.prevRecipe();
        }
        this.func_70296_d();
    }

    public ItemStack getResultItem() {
        INasaWorkbenchRecipe recipe = this.getAllRecipes().get(this.currentRecipe);
        return recipe.getRecipeOutput();
    }
}

