/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.tile;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.common.block.BlockTelescope;
import igentuman.galacticresearch.integration.computer.IComputerIntegration;
import igentuman.galacticresearch.sky.SkyModel;
import igentuman.galacticresearch.sky.body.Researchable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import micdoodle8.mods.galacticraft.annotations.ForRemoval;
import micdoodle8.mods.galacticraft.annotations.ReplaceWith;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;

public class TileTelescope
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IComputerIntegration {
    public static int viewportSize = 112;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float xAngle = viewportSize;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float yAngle = viewportSize;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int dimension;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int movementAmplifier = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int observationTime = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String curObserveBody = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float curBodyRelativeY = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float curBodyRelativeX = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String researchedBodies = "";
    public int operationCooldown = 10;
    private float deltaX;
    private float deltaY;
    public List<Integer> multipliers = Arrays.asList(1, 2, 5, 10);
    private int looseCounter = 100;

    @Override
    public String[] getMethods() {
        return new String[]{"getComponentName", "getObservationStatus", "getResearchedBodies", "rotateTelescope"};
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.getComponentName()};
            }
            case 1: {
                return this.getObservationStatus();
            }
            case 2: {
                return new Object[]{this.getResearchedBodies().split(",")};
            }
            case 3: {
                return this.rotateTelescope(args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public String getComponentName() {
        return "telescope";
    }

    public Object[] getObservationStatus() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("object", this.curObserveBody);
        data.put("relative_x", Float.valueOf(this.curBodyRelativeX));
        data.put("relative_y", Float.valueOf(this.curBodyRelativeY));
        data.put("progress", this.getObservationProgress());
        return new Object[]{data};
    }

    public Object[] rotateTelescope(Object[] args) {
        this.deltaX = new Double(args[0].toString()).intValue();
        this.deltaY = new Double(args[1].toString()).intValue();
        return new Object[]{true};
    }

    public TileTelescope() {
        super("container.telescope.name");
        this.storage.setMaxExtract(45.0f);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void rotateX(int x) {
        this.deltaX = x * 10 * this.movementAmplifier;
    }

    public void rotateY(int y) {
        this.deltaY = y * 10 * this.movementAmplifier;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public void changeMultiplier() {
        int i = this.multipliers.indexOf(this.movementAmplifier);
        if (++i > this.multipliers.size() - 1) {
            i = 0;
        }
        this.movementAmplifier = this.multipliers.get(i);
    }

    public void doMovement() {
        if (this.operationCooldown > 0) {
            --this.operationCooldown;
            return;
        }
        if (this.deltaX != 0.0f) {
            if (this.deltaX > 0.0f) {
                this.xAngle += (float)this.movementAmplifier;
                this.deltaX -= (float)this.movementAmplifier;
            } else {
                this.xAngle -= (float)this.movementAmplifier;
                this.deltaX += (float)this.movementAmplifier;
            }
            this.xAngle = (int)Math.min((double)SkyModel.width - (double)viewportSize * 1.5, (double)Math.max((float)(viewportSize / 2), this.xAngle));
        }
        if (this.deltaY != 0.0f) {
            if (this.deltaY > 0.0f) {
                this.yAngle += (float)this.movementAmplifier;
                this.deltaY -= (float)this.movementAmplifier;
            } else {
                this.yAngle -= (float)this.movementAmplifier;
                this.deltaY += (float)this.movementAmplifier;
            }
            this.yAngle = (int)Math.min((double)SkyModel.height - (double)viewportSize * 1.5, (double)Math.max((float)(viewportSize / 2), this.yAngle));
        }
        if (this.deltaX == 0.0f & this.deltaY == 0.0f) {
            this.operationCooldown = 10;
        }
    }

    public boolean isBodyResearched(String name) {
        return Arrays.stream(this.researchedBodies.split(",")).anyMatch(val -> val.equals(name));
    }

    public boolean looseCounterEnd() {
        --this.observationTime;
        --this.looseCounter;
        return this.looseCounter < 1;
    }

    public boolean isBodyVisible(Researchable res, float viewPortX, float viewPortY) {
        return (float)res.getX() + res.getSize() > this.xAngle && (float)res.getY() + res.getSize() > this.yAngle && (float)res.getY() < this.yAngle + viewPortY && (float)res.getX() < this.xAngle + viewPortX;
    }

    public void observe() {
        List<Researchable> bodies = SkyModel.get().getCurrentSystemBodies(this.dimension);
        if (bodies == null) {
            return;
        }
        for (Researchable b : bodies) {
            if (Arrays.stream(ModConfig.researchSystem.default_researched_objects).anyMatch(s -> s.equals(b.getName()))) continue;
            float x = b.getX();
            float y = b.getY();
            int padding = 25;
            if (!(x + b.getSize() / 2.0f > this.xAngle + (float)padding) || !(x < this.xAngle + (float)viewportSize - (float)padding - b.getSize()) || !(y + b.getSize() / 2.0f > this.yAngle + (float)padding) || !(y < this.yAngle + (float)viewportSize - (float)padding - b.getSize()) || this.isBodyResearched(b.getName())) continue;
            if (!this.curObserveBody.equals(b.getName())) {
                this.observationTime = 0;
                this.curObserveBody = b.getName();
                this.looseCounter = 100;
            }
            this.curBodyRelativeY = y - (this.yAngle + (float)(viewportSize / 2) - b.getSize() / 2.0f);
            this.curBodyRelativeX = x - (this.xAngle + (float)(viewportSize / 2) - b.getSize() / 2.0f);
            ++this.observationTime;
            if (this.observationTime / 20 >= ModConfig.researchSystem.required_observation_time) {
                this.researchedBodies = this.researchedBodies.length() < 1 ? this.researchedBodies + this.curObserveBody : this.researchedBodies + "," + this.curObserveBody;
                this.observationTime = 0;
                this.curObserveBody = "";
                this.curBodyRelativeY = 0.0f;
                this.curBodyRelativeX = 0.0f;
                this.func_70296_d();
            }
            return;
        }
        if (this.looseCounterEnd()) {
            this.observationTime = 0;
            this.curObserveBody = "";
            this.curBodyRelativeY = 0.0f;
            this.curBodyRelativeX = 0.0f;
        }
    }

    public int getObservationProgress() {
        if (this.curObserveBody.isEmpty()) {
            this.observationTime = 0;
            return 0;
        }
        return (int)(100.0f / (float)ModConfig.researchSystem.required_observation_time * ((float)this.observationTime / 20.0f));
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.getEnergyStoredGC() < 100.0f) {
                return;
            }
            this.doMovement();
            if (!(this.func_145831_w().func_72896_J() && this.func_145831_w().func_180494_b(this.func_174877_v()).func_76738_d() || !this.field_145850_b.func_175678_i(this.func_174877_v()))) {
                this.observe();
            }
            IBlockState st = this.field_145850_b.func_180495_p(this.func_174877_v());
            BlockTelescope be = (BlockTelescope)st.func_177230_c();
            be.updateCmp(this.field_145850_b, this.field_174879_c, st);
            this.clearAsteroids();
        }
    }

    public void deleteResearch(String name) {
        StringBuilder tmp = new StringBuilder();
        for (String r : this.getResearchedBodiesArray()) {
            if (r.equals(name)) continue;
            tmp.append(r).append(",");
        }
        this.researchedBodies = tmp.toString();
        this.func_70296_d();
    }

    public void clearAsteroids() {
        for (String m : this.getResearchedBodiesArray()) {
            if (!m.toUpperCase().contains("ASTEROID-") || GalacticResearch.spaceMineProvider.getMissions().containsKey(m)) continue;
            this.deleteResearch(m);
        }
    }

    public String[] getResearchedBodiesArray() {
        return (String[])Arrays.stream(this.researchedBodies.split(",")).filter(val -> !val.isEmpty()).toArray(String[]::new);
    }

    public String getResearchedBodies() {
        return this.researchedBodies;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction != null && type == NetworkType.POWER) {
            return this.getElectricalInputDirections().contains(direction);
        }
        return false;
    }

    public EnumFacing getElectricInputDirection() {
        return ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTelescope.field_185512_D)).func_176734_d();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.dimension = nbt.func_74762_e("dimension");
        this.xAngle = nbt.func_74760_g("xAngle");
        this.yAngle = nbt.func_74760_g("yAngle");
        this.movementAmplifier = nbt.func_74762_e("movementAmplifier");
        this.operationCooldown = nbt.func_74762_e("operationCooldown");
        this.observationTime = nbt.func_74762_e("observationTime");
        this.researchedBodies = nbt.func_74779_i("researchedBodies");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("dimension", this.dimension);
        nbt.func_74776_a("xAngle", this.xAngle);
        nbt.func_74776_a("yAngle", this.yAngle);
        nbt.func_74768_a("movementAmplifier", this.movementAmplifier);
        nbt.func_74768_a("operationCooldown", this.operationCooldown);
        nbt.func_74768_a("observationTime", this.observationTime);
        nbt.func_74778_a("researchedBodies", this.researchedBodies);
        return nbt;
    }

    @Deprecated
    @ForRemoval(deadline="4.1.0")
    @ReplaceWith(value="byIndex()")
    public EnumFacing getFront() {
        return this.byIndex();
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        EnumFacing facing = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockTelescope.field_185512_D);
        return EnumSet.of(facing.func_176746_e(), facing.func_176735_f());
    }
}

