/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.handler;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.ai.task.EntityAIPlayerNoFly;
import igentuman.galacticresearch.ai.task.EntityAIPyrokinetic;
import igentuman.galacticresearch.ai.task.EntityAISpawnMinions;
import igentuman.galacticresearch.ai.task.EntityAISpawnWeb;
import igentuman.galacticresearch.client.capability.SpaceClientCapabilityHandler;
import igentuman.galacticresearch.client.capability.SpaceClientDataProvider;
import igentuman.galacticresearch.client.gui.GRGuiCelestialSelection;
import igentuman.galacticresearch.client.gui.GuiTelescope;
import igentuman.galacticresearch.common.capability.PlayerSpaceData;
import igentuman.galacticresearch.common.capability.SpaceCapabilityHandler;
import igentuman.galacticresearch.common.capability.SpaceDataProvider;
import igentuman.galacticresearch.common.tile.TileMissionControlStation;
import igentuman.galacticresearch.network.GRPacketSimple;
import igentuman.galacticresearch.util.Util;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.entities.EntityBossBase;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.items.ItemBasic;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCreeperBoss;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntitySpiderQueen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GREventHandler {
    public long tickSent = 0L;

    @SubscribeEvent
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving instanceof EntityPlayerMP) {
            GalacticResearch.pHandler.onPlayerUpdate((EntityPlayerMP)entityLiving);
        }
    }

    @SubscribeEvent
    public void onLandingPadRemoved(EventLandingPadRemoval event) {
        TileEntity tile = event.world.func_175625_s(event.pos);
        if (tile instanceof IFuelDock) {
            IFuelDock dock = (IFuelDock)tile;
            for (ILandingPadAttachable connectedTile : dock.getConnectedTiles()) {
                if (!(connectedTile instanceof TileMissionControlStation)) continue;
                event.allow = false;
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (ModConfig.tweaks.hard_boss_fight) {
            if (entity instanceof EntityBossBase) {
                ((EntityBossBase)entity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPlayerNoFly((EntityLiving)entity, EntityPlayer.class, 8.0f));
                ((EntityBossBase)entity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISpawnMinions((EntityLiving)entity, EntityPlayer.class, 12.0f));
            }
            if (entity instanceof EntityCreeperBoss) {
                ((EntityBossBase)entity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPyrokinetic((EntityLiving)entity, EntityPlayer.class, 12.0f));
            }
            if (entity instanceof EntitySpiderQueen) {
                ((EntityBossBase)entity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISpawnWeb((EntityLiving)entity, EntityPlayer.class, 12.0f));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        try {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            GuiTelescope.lastTickWTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            GuiTelescope.lastXangle = 0.0f;
            GuiTelescope.lastYangle = 0.0f;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(GuiScreenEvent.DrawScreenEvent event) {
        GuiTelescope.ticks = event.getRenderPartialTicks();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() == null || event.getGui().getClass().getName().equals("com.mjr.extraplanets.client.gui.screen.CustomCelestialSelection") || event.getGui().getClass().getName().equals("asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection") || event.getGui().getClass().getName().equals("igentuman.galacticresearch.client.gui.GRGuiCelestialSelectionExtraPlanets") || event.getGui().getClass().getName().equals("igentuman.galacticresearch.client.gui.GRGuiCelestialSelectionGalaxySpace")) {
            return;
        }
        if (event.getGui() instanceof GuiCelestialSelection) {
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.galaxyMap)) {
                event.setGui((GuiScreen)new GRGuiCelestialSelection(true, ((GuiCelestialSelection)event.getGui()).possibleBodies, ((GuiCelestialSelection)event.getGui()).canCreateStations));
            } else {
                event.setGui((GuiScreen)new GRGuiCelestialSelection(false, ((GuiCelestialSelection)event.getGui()).possibleBodies, ((GuiCelestialSelection)event.getGui()).canCreateStations));
            }
        }
    }

    @SubscribeEvent
    public void attachSpaceDataCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(SpaceCapabilityHandler.PLAYER_SPACE_DATA_NAME, (ICapabilityProvider)new SpaceDataProvider((EntityPlayerMP)event.getObject()));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void attachSpaceDataCapabilityClient(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerSP) {
            event.addCapability(SpaceClientCapabilityHandler.PLAYER_SPACE_DATA_CLIENT_NAME, (ICapabilityProvider)new SpaceClientDataProvider((EntityPlayerSP)event.getObject()));
        }
    }

    @SubscribeEvent
    public void playerRbmBlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity te;
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ItemBasic && stack.func_77952_i() == 19 && (te = event.getEntityPlayer().field_70170_p.func_175625_s(event.getPos())) instanceof TileEntityDish) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74783_a("teledishPos", new int[]{event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p()});
            if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"message.teledish_assigned")));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        GalacticResearch.packetPipeline.sendTo((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.SKY_SEED, GCCoreUtil.getDimensionID((World)event.player.field_70170_p), new Object[]{GalacticResearch.skyModel.seed}), (EntityPlayerMP)event.player);
        GalacticResearch.instance.logger.error("Sky seed: " + GalacticResearch.skyModel.seed);
        GalacticResearch.spaceMineProvider.syncToPlayer((EntityPlayerMP)event.player);
        GalacticResearch.instance.logger.error("Asteoids: " + Util.serializeMap(GalacticResearch.spaceMineProvider.getMissions()));
        PlayerSpaceData stats = (PlayerSpaceData)event.player.getCapability(SpaceCapabilityHandler.PLAYER_SPACE_DATA, null);
        for (String m : ModConfig.researchSystem.default_researched_objects) {
            assert (stats != null);
            stats.addMission(m);
        }
        assert (stats != null);
        GalacticResearch.packetPipeline.sendTo((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.SYNC_PLAYER_SPACE_DATA, GCCoreUtil.getDimensionID((World)event.player.field_70170_p), new Object[]{stats.unlocked_missions}), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            int tick = player.field_70173_aa - 1;
            if (tick % 30 == 0) {
                PlayerSpaceData stats = (PlayerSpaceData)player.getCapability(SpaceCapabilityHandler.PLAYER_SPACE_DATA, null);
                for (String m : ModConfig.researchSystem.default_researched_objects) {
                    assert (stats != null);
                    stats.addMission(m);
                }
                assert (stats != null);
                GalacticResearch.packetPipeline.sendTo((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.SYNC_PLAYER_SPACE_DATA, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[]{stats.unlocked_missions}), player);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        GalacticResearch.spaceMineProvider.updateMissions();
        if (GalacticResearch.server != null) {
            if (this.tickSent == GalacticResearch.server.func_130014_f_().func_82737_E()) {
                return;
            }
            this.tickSent = GalacticResearch.server.func_130014_f_().func_82737_E();
            GalacticResearch.packetPipeline.sendToAll((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.WORLD_TIME, 0, new Object[]{this.tickSent}));
        }
    }
}

