/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.reflection.screen;

import igentuman.galacticresearch.util.PlayerUtil;
import java.nio.DoubleBuffer;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.render.RenderPlanet;
import micdoodle8.mods.galacticraft.core.client.screen.GameScreenCelestial;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class GameScreenCelestialReflector {
    private static float centreX;
    private static float scale;
    private static float frameBx;
    private static float centreY;
    private static float frameA;
    private static float frameBy;
    private static DoubleBuffer planes;
    private static final float cos;
    private static final float sin;

    public static void drawCelestialBodiesQ(CelestialBody body, float ticks) {
        String mainSolarSystem;
        Star star = null;
        SolarSystem solarSystem = null;
        if (body instanceof Planet) {
            solarSystem = ((Planet)body).getParentSolarSystem();
        } else if (body instanceof Moon) {
            solarSystem = ((Moon)body).getParentPlanet().getParentSolarSystem();
        } else if (body instanceof Satellite) {
            solarSystem = ((Satellite)body).getParentPlanet().getParentSolarSystem();
        }
        if (solarSystem == null) {
            solarSystem = GalacticraftCore.solarSystemSol;
        }
        if ((star = solarSystem.getMainStar()) != null && star.getBodyIcon() != null) {
            GameScreenCelestialReflector.drawCelestialBodyQ((CelestialBody)star, 0.0f, 0.0f, ticks, 6.0f);
        }
        try {
            mainSolarSystem = solarSystem.getTranslationKey();
        }
        catch (NoSuchMethodError ignore) {
            mainSolarSystem = solarSystem.getUnlocalizedName();
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            String pkey;
            if (!PlayerUtil.isUnlocked(planet.getName())) continue;
            try {
                pkey = planet.getParentSolarSystem().getTranslationKey();
            }
            catch (NoSuchMethodError ignore) {
                pkey = planet.getParentSolarSystem().getUnlocalizedName();
            }
            if (planet.getParentSolarSystem() == null || planet.getBodyIcon() == null || !pkey.equalsIgnoreCase(mainSolarSystem)) continue;
            Vector3f pos = GameScreenCelestialReflector.getCelestialBodyPositionQ((CelestialBody)planet, ticks);
            GameScreenCelestialReflector.drawCircleQ((CelestialBody)planet);
            GameScreenCelestialReflector.drawCelestialBodyQ((CelestialBody)planet, pos.x, pos.y, ticks, planet.getRelativeDistanceFromCenter().unScaledDistance < 1.5f ? 2.0f : 2.8f);
        }
    }

    public static void drawCelestialBodyQ(CelestialBody planet, float xPos, float yPos, float ticks, float relSize) {
        if (!(xPos + centreX > frameBx || xPos + centreX < frameA || yPos + centreY > frameBy || yPos + centreY < frameA)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(xPos + centreX), (float)(yPos + centreY), (float)0.0f);
            float alpha = 1.0f;
            CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre(planet, planet.getBodyIcon(), 12);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (preEvent.celestialBodyTexture != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
            }
            if (!preEvent.isCanceled()) {
                float size = relSize / 70.0f * scale;
                GameScreenCelestialReflector.drawTexturedRectCBodyQ(-size / 2.0f, -size / 2.0f, size, size);
            }
            CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post(planet);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
            GL11.glPopMatrix();
        }
    }

    private static void drawTexturedRectCBodyQ(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void drawBlackBackgroundQ(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)frameA, (double)frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)frameBx, (double)frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)frameBx, (double)frameA, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)frameA, (double)frameA, (double)0.005f).func_181675_d();
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void render(GameScreenCelestial inst, int type, float ticks, float scaleX, float scaleY, IScreenManager scr) {
        centreX = scaleX / 2.0f;
        centreY = scaleY / 2.0f;
        frameBx = scaleX - frameA;
        frameBy = scaleY - frameA;
        scale = Math.max(scaleX, scaleY) - 0.2f;
        GameScreenCelestialReflector.drawBlackBackgroundQ(0.0f);
        GameScreenCelestialReflector.planeEquationQ(frameA, frameA, 0.0f, frameA, frameBy, 0.0f, frameA, frameBy, 1.0f);
        GL11.glClipPlane((int)12288, (DoubleBuffer)planes);
        GL11.glEnable((int)12288);
        GameScreenCelestialReflector.planeEquationQ(frameBx, frameBy, 0.0f, frameBx, frameA, 0.0f, frameBx, frameA, 1.0f);
        GL11.glClipPlane((int)12289, (DoubleBuffer)planes);
        GL11.glEnable((int)12289);
        GameScreenCelestialReflector.planeEquationQ(frameA, frameBy, 0.0f, frameBx, frameBy, 0.0f, frameBx, frameBy, 1.0f);
        GL11.glClipPlane((int)12290, (DoubleBuffer)planes);
        GL11.glEnable((int)12290);
        GameScreenCelestialReflector.planeEquationQ(frameBx, frameA, 0.0f, frameA, frameA, 0.0f, frameA, frameA, 1.0f);
        GL11.glClipPlane((int)12291, (DoubleBuffer)planes);
        GL11.glEnable((int)12291);
        switch (type) {
            case 2: {
                WorldProvider wp = scr.getWorldProvider();
                CelestialBody body = null;
                if (wp instanceof IGalacticraftWorldProvider) {
                    body = ((IGalacticraftWorldProvider)wp).getCelestialBody();
                }
                if (body == null) {
                    body = GalacticraftCore.planetOverworld;
                }
                GameScreenCelestialReflector.drawCelestialBodiesQ(body, ticks);
                break;
            }
            case 3: {
                GameScreenCelestialReflector.drawCelestialBodiesZQ((CelestialBody)GalacticraftCore.planetOverworld, ticks);
                break;
            }
            case 4: {
                GameScreenCelestialReflector.drawPlanetsTestQ(ticks);
            }
        }
        GL11.glDisable((int)12291);
        GL11.glDisable((int)12290);
        GL11.glDisable((int)12289);
        GL11.glDisable((int)12288);
    }

    private static void drawCelestialBodiesZQ(CelestialBody planet, float ticks) {
        Vector3f pos;
        GameScreenCelestialReflector.drawCelestialBodyQ(planet, 0.0f, 0.0f, ticks, 11.0f);
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (moon.getParentPlanet() != planet || moon.getBodyIcon() == null) continue;
            pos = GameScreenCelestialReflector.getCelestialBodyPositionQ((CelestialBody)moon, ticks);
            GameScreenCelestialReflector.drawCircleQ((CelestialBody)moon);
            GameScreenCelestialReflector.drawCelestialBodyQ((CelestialBody)moon, pos.x, pos.y, ticks, 4.0f);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (satellite.getParentPlanet() != planet) continue;
            pos = GameScreenCelestialReflector.getCelestialBodyPositionQ((CelestialBody)satellite, ticks);
            GameScreenCelestialReflector.drawCircleQ((CelestialBody)satellite);
            GameScreenCelestialReflector.drawCelestialBodyQ((CelestialBody)satellite, pos.x, pos.y, ticks, 3.0f);
        }
    }

    private static Vector3f getCelestialBodyPositionQ(CelestialBody cBody, float ticks) {
        float timeScale = cBody instanceof Planet ? 200.0f : 2.0f;
        float distanceFromCenter = GameScreenCelestialReflector.getScaleQ(cBody) * scale;
        return new Vector3f((float)Math.sin(ticks / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter, (float)Math.cos(ticks / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter, 0.0f);
    }

    private static void planeEquationQ(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        double[] result = new double[]{y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2), z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2), x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2), -(x1 * (y2 * z3 - y3 * z2) + x2 * (y3 * z1 - y1 * z3) + x3 * (y1 * z2 - y2 * z1))};
        planes.put(result, 0, 4);
        planes.position(0);
    }

    private static void drawPlanetsTestQ(float ticks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centreX, (float)centreY, (float)0.0f);
        int id = (int)(ticks / 600.0f) % 5;
        RenderPlanet.renderID((int)id, (float)scale, (float)ticks);
        GL11.glPopMatrix();
    }

    private static void drawTexturedRectUVQ(float x, float y, float width, float height, float ticks) {
        for (int ysect = 0; ysect < 6; ++ysect) {
            float angle = 7.5f + 15.0f * (float)ysect;
            GameScreenCelestialReflector.drawTexturedRectUVSixthQ(x, y, width, height, ticks / (900.0f - 80.0f * MathHelper.func_76134_b((float)angle)) % 1.0f, (float)ysect / 6.0f);
        }
    }

    private static void drawTexturedRectUVSixthQ(float x, float y, float width, float height, float prog, float y0) {
        prog = 1.0f - prog;
        float y1 = (y0 /= 2.0f) + 0.083333336f;
        float y2 = 1.0f - y1;
        float y3 = 1.0f - y0;
        float yaa = y + height * y0;
        float yab = y + height * y1;
        float yba = y + height * y2;
        float ybb = y + height * y3;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        if (prog <= 0.75f) {
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)yab, 0.0).func_187315_a((double)prog, (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yab, 0.0).func_187315_a((double)(prog + 0.25f), (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yaa, 0.0).func_187315_a((double)(prog + 0.25f), (double)y0).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yaa, 0.0).func_187315_a((double)prog, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)ybb, 0.0).func_187315_a((double)prog, (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)ybb, 0.0).func_187315_a((double)(prog + 0.25f), (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yba, 0.0).func_187315_a((double)(prog + 0.25f), (double)y2).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yba, 0.0).func_187315_a((double)prog, (double)y2).func_181675_d();
            tessellator.func_78381_a();
        } else {
            double xp = x + width * (1.0f - prog) / 0.25f;
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)yab, 0.0).func_187315_a((double)prog, (double)y1).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yab, 0.0).func_187315_a(1.0, (double)y1).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yaa, 0.0).func_187315_a(1.0, (double)y0).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yaa, 0.0).func_187315_a((double)prog, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)ybb, 0.0).func_187315_a((double)prog, (double)y3).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)ybb, 0.0).func_187315_a(1.0, (double)y3).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yba, 0.0).func_187315_a(1.0, (double)y2).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yba, 0.0).func_187315_a((double)prog, (double)y2).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(xp, (double)yab, 0.0).func_187315_a(0.0, (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yab, 0.0).func_187315_a((double)(prog - 0.75f), (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yaa, 0.0).func_187315_a((double)(prog - 0.75f), (double)y0).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yaa, 0.0).func_187315_a(0.0, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(xp, (double)ybb, 0.0).func_187315_a(0.0, (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)ybb, 0.0).func_187315_a((double)(prog - 0.75f), (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yba, 0.0).func_187315_a((double)(prog - 0.75f), (double)y2).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yba, 0.0).func_187315_a(0.0, (double)y2).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    private static float getScaleQ(CelestialBody celestialBody) {
        float distance = celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        if (distance >= 1.375f) {
            distance = distance >= 1.5f ? (distance *= 1.15f) : (distance += 0.075f);
        }
        return 0.007142857f * distance * (celestialBody instanceof Planet ? 25.0f : 3.5f);
    }

    public static void drawCircleQ(CelestialBody cBody) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centreX, (float)centreY, (float)0.002f);
        GL11.glDisable((int)3553);
        float sd = 0.002514f * scale;
        float x = GameScreenCelestialReflector.getScaleQ(cBody);
        float y = 0.0f;
        float grey = 0.1f + 0.65f * Math.max(0.0f, 0.5f - x);
        x = x * scale / sd;
        GL11.glColor4f((float)grey, (float)grey, (float)grey, (float)1.0f);
        GL11.glLineWidth((float)0.002f);
        GL11.glScalef((float)sd, (float)sd, (float)sd);
        CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre(cBody, new Vector3f(0.0f, 0.0f, 0.0f));
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        if (!preEvent.isCanceled()) {
            GL11.glBegin((int)2);
            for (int i = 0; i < 90; ++i) {
                GL11.glVertex2f((float)x, (float)y);
                float temp = x;
                x = cos * x - sin * y;
                y = sin * temp + cos * y;
            }
            GL11.glEnd();
        }
        CelestialBodyRenderEvent.CelestialRingRenderEvent.Post postEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post(cBody);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    static {
        planes = BufferUtils.createDoubleBuffer((int)256);
        cos = MathHelper.func_76134_b((float)0.06981317f);
        sin = MathHelper.func_76126_a((float)0.06981317f);
    }
}

