/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.sky;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.sky.body.Asteroid;
import igentuman.galacticresearch.sky.body.Researchable;
import igentuman.galacticresearch.sky.body.Star;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;

public class SkyModel {
    public static int width = 1200;
    public static int height = 1200;
    private static int starsDensity = 2000;
    public long seed;
    private Star[] stars;
    private List<Asteroid> asteroids = new ArrayList<Asteroid>();
    private static SkyModel instance;

    private SkyModel() {
    }

    public void addAsteroid(String name) {
        this.asteroids.add(new Asteroid(name));
    }

    public void removeAsteroid(String name) {
        int i = 0;
        for (Asteroid a : this.asteroids) {
            if (a.getName().equals(name)) {
                this.asteroids.remove(i);
                return;
            }
            ++i;
        }
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public static SkyModel get() {
        if (instance == null) {
            instance = new SkyModel();
        }
        return instance;
    }

    public SolarSystem getSolarSystemByCelestialBody(CelestialBody body) {
        if (body instanceof Planet) {
            return ((Planet)body).getParentSolarSystem();
        }
        if (body instanceof Moon) {
            return ((Moon)body).getParentPlanet().getParentSolarSystem();
        }
        if (body instanceof Satellite) {
            return ((Satellite)body).getParentPlanet().getParentSolarSystem();
        }
        return null;
    }

    public List<Researchable> getCurrentSystemBodies(int dim) {
        ArrayList<Researchable> res = new ArrayList<Researchable>();
        CelestialBody body = GalaxyRegistry.getCelestialBodyFromDimensionID((int)dim);
        SolarSystem solar = this.getSolarSystemByCelestialBody(body);
        if (solar == null) {
            return res;
        }
        for (Planet pl : GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)solar)) {
            if (!pl.equals((Object)body)) {
                res.add(Researchable.get(pl.getName()));
                continue;
            }
            for (Moon moon : GalaxyRegistry.getMoonsForPlanet((Planet)pl)) {
                res.add(Researchable.get(moon.getName()));
            }
        }
        res.addAll(this.asteroids);
        return res;
    }

    public Star[] getStars() {
        if (this.stars == null) {
            this.stars = new Star[starsDensity];
            for (int i = 0; i < starsDensity; ++i) {
                this.stars[i] = Star.generate();
            }
        }
        return this.stars;
    }

    public void initSeed() {
        Random r = new Random(GalacticResearch.server.func_130014_f_().func_72905_C() / 10L);
        this.setSeed(r.nextLong());
    }

    public void removeAsteroids() {
        this.asteroids.clear();
    }
}

