/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.sky.body;

import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.sky.SkyModel;
import igentuman.galacticresearch.sky.body.ISkyBody;
import igentuman.galacticresearch.util.WorldUtil;
import java.util.HashMap;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import net.minecraft.util.ResourceLocation;

public class Researchable
implements ISkyBody {
    protected String name;
    protected Researchable parent;
    protected CelestialBody body;
    protected int x;
    protected int y;
    protected float size;
    protected int rarity;
    protected int speed = 0;
    protected ResourceLocation texture;
    protected Random rand;
    protected static HashMap<String, Researchable> cache = new HashMap();

    public Researchable(CelestialBody planet) {
        this.size = ModConfig.researchSystem.getSizes().getOrDefault(planet.getName(), 16).intValue();
        this.rarity = (int)Math.abs(Math.max(5.0f, planet.getRelativeOrbitTime() * 10.0f));
        this.name = planet.getName();
        this.x = this.initialX();
        this.y = this.initialY();
        this.body = planet;
        if (planet instanceof Moon) {
            this.parent = Researchable.get(((Moon)planet).getParentPlanet().getName());
        }
    }

    public Researchable getParent() {
        return this.parent;
    }

    public static Researchable get(String name) {
        if (!cache.keySet().contains(name)) {
            if (GalaxyRegistry.getRegisteredPlanets().get(name) == null) {
                cache.put(name, new Researchable((CelestialBody)GalaxyRegistry.getRegisteredMoons().get(name)));
            } else {
                cache.put(name, new Researchable((CelestialBody)GalaxyRegistry.getRegisteredPlanets().get(name)));
            }
        }
        return cache.get(name);
    }

    public float guiX(long lastTime, float ticks) {
        float sx = (float)this.x + (float)this.time() / (float)this.speed();
        int cx = (int)(sx / (float)SkyModel.width);
        float xc = sx - (float)(cx * SkyModel.width);
        if (this.isHorizontalReversed()) {
            xc = (float)SkyModel.width - (sx - (float)(cx * SkyModel.width));
        }
        sx = (float)this.x + (float)lastTime / (float)this.speed();
        cx = (int)(sx / (float)SkyModel.width);
        float xl = sx - (float)(cx * SkyModel.width);
        if (this.isHorizontalReversed()) {
            xl = (float)SkyModel.width - (sx - (float)(cx * SkyModel.width));
        }
        return xl + (xc - xl) * ticks;
    }

    public float guiY(long lastTime, float ticks) {
        float sy = (float)this.y + (float)this.time() / (float)this.speed();
        int cy = (int)(sy / (float)SkyModel.height);
        float yc = sy - (float)(cy * SkyModel.height);
        if (this.isVerticalReversed()) {
            yc = (float)SkyModel.height - (sy - (float)(cy * SkyModel.height));
        }
        sy = (float)this.y + (float)lastTime / (float)this.speed();
        cy = (int)(sy / (float)SkyModel.height);
        float yl = sy - (float)(cy * SkyModel.height);
        if (this.isVerticalReversed()) {
            yl = (float)SkyModel.height - (sy - (float)(cy * SkyModel.height));
        }
        return yl + (yc - yl) * ticks;
    }

    public boolean isVerticalReversed() {
        Random r = new Random(SkyModel.get().seed / 2L + (long)this.nameToSeed() + (long)this.rarity() + (long)WorldUtil.getDay());
        return r.nextInt(10) < 3;
    }

    public boolean isHorizontalReversed() {
        Random r = new Random(SkyModel.get().seed / 2L + (long)this.nameToSeed() + (long)this.rarity() + (long)WorldUtil.getDay() + 100L);
        return r.nextInt(10) < 4;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    private int nameToSeed() {
        return Math.abs(this.name.hashCode());
    }

    private int initialX() {
        long seed = SkyModel.get().seed + (long)this.nameToSeed();
        return new Random(seed).nextInt(SkyModel.width);
    }

    private int initialY() {
        long seed = (SkyModel.get().seed + (long)this.nameToSeed()) / 2L;
        return new Random(seed).nextInt(SkyModel.height);
    }

    @Override
    public boolean isVisible() {
        Random r = new Random(SkyModel.get().seed / 20L + (long)(this.nameToSeed() / 1000) + (long)this.rarity() + (long)WorldUtil.getDay());
        return r.nextInt((int)(10.0 / (1.0 / (double)this.rarity()))) < this.rarity() * 100;
    }

    public int rarity() {
        return Math.min(2, Math.abs(this.rarity));
    }

    public int speed() {
        if (this.speed == 0) {
            Random r = new Random(SkyModel.get().seed / 20L + (long)(this.nameToSeed() / 1000) + (long)this.rarity());
            this.speed = r.nextInt(20);
        }
        return Math.max(5, this.speed);
    }

    @Override
    public int getX() {
        int sx = (int)((long)this.x + this.time() / (long)this.speed());
        int cx = sx / SkyModel.width;
        if (this.isHorizontalReversed()) {
            return SkyModel.width - (sx - cx * SkyModel.width);
        }
        return sx - cx * SkyModel.width;
    }

    @Override
    public int getY() {
        int sy = (int)((long)this.y + this.time() / (long)this.speed());
        int cy = sy / SkyModel.height;
        if (this.isVerticalReversed()) {
            return SkyModel.height - (sy - cy * SkyModel.height);
        }
        return sy - cy * SkyModel.height;
    }

    public ResourceLocation getTexture() {
        if (this.texture == null) {
            if (this.name.equals("moon")) {
                this.texture = new ResourceLocation("galacticresearch", "textures/gui/planets/" + this.name + ".png");
                return this.texture;
            }
            this.texture = GalaxyRegistry.getRegisteredPlanets().keySet().contains(this.name) ? ((Planet)GalaxyRegistry.getRegisteredPlanets().get(this.name)).getBodyIcon() : (GalaxyRegistry.getRegisteredMoons().keySet().contains(this.name) ? ((Moon)GalaxyRegistry.getRegisteredMoons().get(this.name)).getBodyIcon() : new ResourceLocation("galacticresearch", "textures/gui/planets/" + this.name + ".png"));
        }
        return this.texture;
    }

    public int yTexOffset() {
        return 0;
    }

    public String getName() {
        return this.name;
    }
}

