/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.blocks;

import java.util.List;
import mod.casinocraft.CasinoCraft;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntitySlotMachine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockSlotMachine
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool PRIMARY = PropertyBool.func_177716_a((String)"primary");
    final EnumDyeColor color;

    public BlockSlotMachine(String name, EnumDyeColor colorIn) {
        super(Material.field_151574_g);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185858_k);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149675_a(false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(true)));
        this.color = colorIn;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBoard te = (TileEntityBoard)worldIn.func_175625_s(pos);
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(true)));
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(false)));
        } else {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        boolean isPrimary = (Boolean)state.func_177229_b((IProperty)PRIMARY);
        if (isPrimary && !worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List drops = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockSlotMachine.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean isPrimary = (Boolean)state.func_177229_b((IProperty)PRIMARY);
        if (isPrimary) {
            worldIn.func_175655_b(pos.func_177984_a(), true);
        } else {
            worldIn.func_175655_b(pos.func_177977_b(), true);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        boolean isPrimary = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)PRIMARY);
        if (isPrimary) {
            world.func_175655_b(pos.func_177984_a(), true);
        } else {
            world.func_175655_b(pos.func_177977_b(), true);
        }
        world.func_175698_g(pos);
        this.func_180652_a(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        BlockPos pos2 = pos;
        boolean isPrimary = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)PRIMARY);
        Item item = Items.field_151145_ak;
        if (!isPrimary) {
            pos2 = pos.func_177977_b();
        }
        if (world.func_175625_s(pos2) instanceof TileEntityBoard) {
            TileEntityBoard te = (TileEntityBoard)world.func_175625_s(pos2);
            if (player.func_70093_af()) {
                return true;
            }
            if (te.func_70301_a(0).func_190926_b() || te.func_70301_a(0).func_77973_b() == player.func_184586_b(hand).func_77973_b()) {
                player.openGui((Object)CasinoCraft.instance, 50, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else {
                player.openGui((Object)CasinoCraft.instance, 51, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            }
            te.func_70296_d();
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return meta < 8 ? null : new TileEntitySlotMachine(this.color, 3);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PRIMARY});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta % 8));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(meta / 8 > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)PRIMARY)).booleanValue()) {
            i += 8;
        }
        return i;
    }
}

